/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.notification.context.NotificationContextBuilder;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationTemplateLocalService;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionExecutor.class})
public class NotificationTemplateObjectActionExecutorImpl
implements ObjectActionExecutor {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private NotificationTemplateLocalService _notificationTemplateLocalService;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public void execute(long companyId, long objectActionId, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject, long userId) throws Exception {
        NotificationTemplate notificationTemplate = this._notificationTemplateLocalService.getNotificationTemplate(GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"notificationTemplateId"))));
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationTemplate.getType());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(payloadJSONObject.getLong("objectDefinitionId"));
        Map<String, Object> termValues = this._getTermValues(objectDefinition, ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionManagerRegistry));
        notificationType.sendNotification(new NotificationContextBuilder().className(objectDefinition.getClassName()).classPK(GetterUtil.getLong((Object)termValues.get("id"))).externalReferenceCode(GetterUtil.getString((Object)termValues.get("externalReferenceCode"))).groupId(GetterUtil.getLong((Object)termValues.get("groupId"))).notificationTemplate(notificationTemplate).termValues(termValues).userId(userId).portletId(objectDefinition.isUnmodifiableSystemObject() ? "" : objectDefinition.getPortletId()).build());
    }

    public String getKey() {
        return "notification";
    }

    private Map<String, Object> _getTermValues(ObjectDefinition objectDefinition, Map<String, Object> variables) {
        Map termValues = (Map)variables.get("baseModel");
        termValues.put("objectDefinitionId", objectDefinition.getObjectDefinitionId());
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            ListTypeEntry listTypeEntry;
            if (termValues.get(objectField.getName()) == null) continue;
            if (Objects.equals(objectField.getBusinessType(), "Date") && !Objects.equals(objectField.getName(), "createDate") && !Objects.equals(objectField.getName(), "modifiedDate")) {
                Timestamp timestamp;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Object object = termValues.get(objectField.getName());
                if (object instanceof Timestamp) {
                    timestamp = (Timestamp)object;
                    termValues.put(objectField.getName(), simpleDateFormat.format(new Date(timestamp.getTime())));
                    continue;
                }
                timestamp = new Timestamp((Long)object);
                termValues.put(objectField.getName(), simpleDateFormat.format(new Date(timestamp.getTime())));
                continue;
            }
            if (Objects.equals(objectField.getBusinessType(), "MultiselectPicklist")) {
                termValues.put(objectField.getName(), StringUtil.merge((Object[])TransformUtil.transform((Object[])StringUtil.split((String)String.valueOf(termValues.get(objectField.getName())), (String)", "), listTypeEntryKey -> {
                    ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), listTypeEntryKey);
                    return listTypeEntry.getNameCurrentValue();
                }, String.class), (String)", "));
                continue;
            }
            if (!Objects.equals(objectField.getBusinessType(), "Picklist") || (listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), (String)termValues.get(objectField.getName()))) == null) continue;
            termValues.put(objectField.getName(), listTypeEntry.getNameCurrentValue());
        }
        return termValues;
    }
}

