/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.sort;

import com.liferay.object.internal.sort.BaseSortDSLQueryVisitor;
import com.liferay.object.internal.sort.ObjectEntry1ToMRelationshipSortDSLQueryVisitor;
import com.liferay.object.internal.sort.ObjectEntryFieldSortDSLQueryVisitor;
import com.liferay.object.internal.sort.RelationshipSort;
import com.liferay.object.internal.sort.Sort;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.odata.sort.InvalidSortException;
import java.util.List;
import java.util.Objects;

public class SortDSLQueryVisitor
extends BaseSortDSLQueryVisitor {
    public SortDSLQueryVisitor(ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        super(objectFieldLocalService, objectRelationshipLocalService);
    }

    @Override
    public DSLQuery visit(DSLQuery dslQuery, Sort sort) throws PortalException {
        ObjectDefinition objectDefinition = sort.getObjectDefinition();
        List fieldPathParts = StringUtil.split((String)sort.getFieldPath(), (char)'/');
        List objectRelationshipNames = ListUtil.subList((List)fieldPathParts, (int)0, (int)(fieldPathParts.size() - 1));
        for (int i = 0; i < objectRelationshipNames.size(); ++i) {
            String objectRelationshipName = (String)objectRelationshipNames.get(i);
            ObjectRelationship objectRelationship = this.objectRelationshipLocalService.getObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
            ObjectDefinition relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
            dslQuery = this._visit(dslQuery, objectDefinition, objectRelationship, StringUtil.merge(objectRelationshipNames.subList(0, i + 1), (String)"/"), relatedObjectDefinition, sort);
            objectDefinition = relatedObjectDefinition;
        }
        ObjectEntryFieldSortDSLQueryVisitor objectEntryFieldSortDSLQueryVisitor = new ObjectEntryFieldSortDSLQueryVisitor(this.objectFieldLocalService);
        return objectEntryFieldSortDSLQueryVisitor.visit(dslQuery, new Sort(objectDefinition, sort));
    }

    private DSLQuery _visit(DSLQuery dslQuery, ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, String path, ObjectDefinition relatedObjectDefinition, Sort sort) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-18730")) {
            throw new InvalidSortException("Unable to sort by a related object field");
        }
        if (!Objects.equals(objectRelationship.getType(), "oneToMany")) {
            String relationshipType = CamelCaseUtil.fromCamelCase((String)objectRelationship.getType(), (char)' ');
            throw new InvalidSortException("Unable to sort by a " + relationshipType + " related object field");
        }
        if (objectDefinition.getObjectDefinitionId() != objectRelationship.getObjectDefinitionId1()) {
            throw new InvalidSortException("Unable to sort by a many to one related object field");
        }
        ObjectEntry1ToMRelationshipSortDSLQueryVisitor objectEntry1ToMRelationshipSortDSLQueryVisitor = new ObjectEntry1ToMRelationshipSortDSLQueryVisitor(this.objectFieldLocalService, this.objectRelationshipLocalService);
        return objectEntry1ToMRelationshipSortDSLQueryVisitor.visit(dslQuery, new RelationshipSort(objectDefinition, objectRelationship, path, relatedObjectDefinition, sort));
    }
}

