/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ObjectActionExecutorRegistry.class})
public class ObjectActionExecutorRegistryImpl
implements ObjectActionExecutorRegistry {
    private ServiceTrackerMap<String, ObjectActionExecutor> _serviceTrackerMap;

    public ObjectActionExecutor getObjectActionExecutor(long companyId, String objectActionExecutorKey) {
        ObjectActionExecutor objectActionExecutor = (ObjectActionExecutor)this._serviceTrackerMap.getService((Object)objectActionExecutorKey);
        if (objectActionExecutor == null) {
            objectActionExecutor = (ObjectActionExecutor)this._serviceTrackerMap.getService((Object)this._getCompanyScopedKey(objectActionExecutorKey, companyId));
        }
        if (objectActionExecutor == null) {
            throw new IllegalArgumentException("No object action executor found with key " + objectActionExecutorKey);
        }
        return objectActionExecutor;
    }

    public List<ObjectActionExecutor> getObjectActionExecutors(long companyId, String objectDefinitionName) {
        Collection objectActionExecutorsCollection = this._serviceTrackerMap.values();
        if (objectActionExecutorsCollection == null) {
            return Collections.emptyList();
        }
        return ListUtil.sort((List)ListUtil.filter((List)ListUtil.fromCollection((Collection)objectActionExecutorsCollection), objectActionExecutor -> {
            boolean companyAllowed = true;
            if (objectActionExecutor instanceof CompanyScoped) {
                CompanyScoped objectActionExecutorCompanyScoped = (CompanyScoped)objectActionExecutor;
                companyAllowed = objectActionExecutorCompanyScoped.isAllowedCompany(companyId);
            }
            boolean objectDefinitionAllowed = true;
            if (objectActionExecutor instanceof ObjectDefinitionScoped) {
                ObjectDefinitionScoped objectActionExecutorObjectDefinitionScoped = (ObjectDefinitionScoped)objectActionExecutor;
                objectDefinitionAllowed = objectActionExecutorObjectDefinitionScoped.isAllowedObjectDefinition(objectDefinitionName);
            }
            return companyAllowed && objectDefinitionAllowed;
        }), (objectActionExecutor1, objectActionExecutor2) -> {
            String key1 = objectActionExecutor1.getKey();
            String key2 = objectActionExecutor2.getKey();
            return key1.compareTo(key2);
        });
    }

    public boolean hasObjectActionExecutor(String objectActionExecutorKey) {
        return this._serviceTrackerMap.containsKey((Object)objectActionExecutorKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ObjectActionExecutor.class, null, (serviceReference, emitter) -> {
            ObjectActionExecutor objectActionExecutor = (ObjectActionExecutor)bundleContext.getService(serviceReference);
            String key = objectActionExecutor.getKey();
            if (objectActionExecutor instanceof CompanyScoped) {
                CompanyScoped objectActionExecutorCompanyScoped = (CompanyScoped)objectActionExecutor;
                key = this._getCompanyScopedKey(key, objectActionExecutorCompanyScoped.getAllowedCompanyId());
            }
            emitter.emit((Object)key);
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getCompanyScopedKey(String key, long company) {
        return StringBundler.concat((Object[])new Object[]{key, "#", company});
    }
}

