/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectValidationRuleSetting;
import com.liferay.object.model.ObjectValidationRuleSettingModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectValidationRuleSetting service. Represents a row in the &quot;ObjectValidationRuleSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectValidationRuleSettingModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectValidationRuleSettingImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectValidationRuleSettingImpl
 * @generated
 */
public class ObjectValidationRuleSettingModelImpl
	extends BaseModelImpl<ObjectValidationRuleSetting>
	implements ObjectValidationRuleSettingModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object validation rule setting model instance should use the <code>ObjectValidationRuleSetting</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectValidationRuleSetting";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectValidationRuleSettingId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"objectValidationRuleId", Types.BIGINT}, {"name", Types.VARCHAR},
		{"value", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectValidationRuleSettingId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectValidationRuleId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("value", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectValidationRuleSetting (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectValidationRuleSettingId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectValidationRuleId LONG,name VARCHAR(75) null,value VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table ObjectValidationRuleSetting";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectValidationRuleSetting.objectValidationRuleSettingId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectValidationRuleSetting.objectValidationRuleSettingId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVALIDATIONRULEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VALUE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVALIDATIONRULESETTINGID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectValidationRuleSettingModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectValidationRuleSettingId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectValidationRuleSettingId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectValidationRuleSettingId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectValidationRuleSetting.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectValidationRuleSetting.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectValidationRuleSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectValidationRuleSetting, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectValidationRuleSetting, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(ObjectValidationRuleSetting)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectValidationRuleSetting, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectValidationRuleSetting, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectValidationRuleSetting)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectValidationRuleSetting, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectValidationRuleSetting, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<ObjectValidationRuleSetting, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectValidationRuleSetting, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<ObjectValidationRuleSetting, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectValidationRuleSetting::getMvccVersion);
			attributeGetterFunctions.put(
				"uuid", ObjectValidationRuleSetting::getUuid);
			attributeGetterFunctions.put(
				"objectValidationRuleSettingId",
				ObjectValidationRuleSetting::getObjectValidationRuleSettingId);
			attributeGetterFunctions.put(
				"companyId", ObjectValidationRuleSetting::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectValidationRuleSetting::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectValidationRuleSetting::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectValidationRuleSetting::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectValidationRuleSetting::getModifiedDate);
			attributeGetterFunctions.put(
				"objectValidationRuleId",
				ObjectValidationRuleSetting::getObjectValidationRuleId);
			attributeGetterFunctions.put(
				"name", ObjectValidationRuleSetting::getName);
			attributeGetterFunctions.put(
				"value", ObjectValidationRuleSetting::getValue);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<ObjectValidationRuleSetting, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectValidationRuleSetting, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectValidationRuleSetting, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectValidationRuleSetting, Long>)
					ObjectValidationRuleSetting::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectValidationRuleSetting, String>)
					ObjectValidationRuleSetting::setUuid);
			attributeSetterBiConsumers.put(
				"objectValidationRuleSettingId",
				(BiConsumer<ObjectValidationRuleSetting, Long>)
					ObjectValidationRuleSetting::
						setObjectValidationRuleSettingId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectValidationRuleSetting, Long>)
					ObjectValidationRuleSetting::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectValidationRuleSetting, Long>)
					ObjectValidationRuleSetting::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectValidationRuleSetting, String>)
					ObjectValidationRuleSetting::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectValidationRuleSetting, Date>)
					ObjectValidationRuleSetting::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectValidationRuleSetting, Date>)
					ObjectValidationRuleSetting::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectValidationRuleId",
				(BiConsumer<ObjectValidationRuleSetting, Long>)
					ObjectValidationRuleSetting::setObjectValidationRuleId);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<ObjectValidationRuleSetting, String>)
					ObjectValidationRuleSetting::setName);
			attributeSetterBiConsumers.put(
				"value",
				(BiConsumer<ObjectValidationRuleSetting, String>)
					ObjectValidationRuleSetting::setValue);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectValidationRuleSettingId() {
		return _objectValidationRuleSettingId;
	}

	@Override
	public void setObjectValidationRuleSettingId(
		long objectValidationRuleSettingId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectValidationRuleSettingId = objectValidationRuleSettingId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectValidationRuleId() {
		return _objectValidationRuleId;
	}

	@Override
	public void setObjectValidationRuleId(long objectValidationRuleId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectValidationRuleId = objectValidationRuleId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectValidationRuleId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectValidationRuleId"));
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public String getValue() {
		if (_value == null) {
			return "";
		}
		else {
			return _value;
		}
	}

	@Override
	public void setValue(String value) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_value = value;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalValue() {
		return getColumnOriginalValue("value");
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				ObjectValidationRuleSetting.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectValidationRuleSetting.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectValidationRuleSetting toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectValidationRuleSetting>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectValidationRuleSettingImpl objectValidationRuleSettingImpl =
			new ObjectValidationRuleSettingImpl();

		objectValidationRuleSettingImpl.setMvccVersion(getMvccVersion());
		objectValidationRuleSettingImpl.setUuid(getUuid());
		objectValidationRuleSettingImpl.setObjectValidationRuleSettingId(
			getObjectValidationRuleSettingId());
		objectValidationRuleSettingImpl.setCompanyId(getCompanyId());
		objectValidationRuleSettingImpl.setUserId(getUserId());
		objectValidationRuleSettingImpl.setUserName(getUserName());
		objectValidationRuleSettingImpl.setCreateDate(getCreateDate());
		objectValidationRuleSettingImpl.setModifiedDate(getModifiedDate());
		objectValidationRuleSettingImpl.setObjectValidationRuleId(
			getObjectValidationRuleId());
		objectValidationRuleSettingImpl.setName(getName());
		objectValidationRuleSettingImpl.setValue(getValue());

		objectValidationRuleSettingImpl.resetOriginalValues();

		return objectValidationRuleSettingImpl;
	}

	@Override
	public ObjectValidationRuleSetting cloneWithOriginalValues() {
		ObjectValidationRuleSettingImpl objectValidationRuleSettingImpl =
			new ObjectValidationRuleSettingImpl();

		objectValidationRuleSettingImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectValidationRuleSettingImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectValidationRuleSettingImpl.setObjectValidationRuleSettingId(
			this.<Long>getColumnOriginalValue("objectValidationRuleSettingId"));
		objectValidationRuleSettingImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectValidationRuleSettingImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectValidationRuleSettingImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectValidationRuleSettingImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectValidationRuleSettingImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectValidationRuleSettingImpl.setObjectValidationRuleId(
			this.<Long>getColumnOriginalValue("objectValidationRuleId"));
		objectValidationRuleSettingImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectValidationRuleSettingImpl.setValue(
			this.<String>getColumnOriginalValue("value"));

		return objectValidationRuleSettingImpl;
	}

	@Override
	public int compareTo(
		ObjectValidationRuleSetting objectValidationRuleSetting) {

		long primaryKey = objectValidationRuleSetting.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectValidationRuleSetting)) {
			return false;
		}

		ObjectValidationRuleSetting objectValidationRuleSetting =
			(ObjectValidationRuleSetting)object;

		long primaryKey = objectValidationRuleSetting.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectValidationRuleSetting> toCacheModel() {
		ObjectValidationRuleSettingCacheModel
			objectValidationRuleSettingCacheModel =
				new ObjectValidationRuleSettingCacheModel();

		objectValidationRuleSettingCacheModel.mvccVersion = getMvccVersion();

		objectValidationRuleSettingCacheModel.uuid = getUuid();

		String uuid = objectValidationRuleSettingCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectValidationRuleSettingCacheModel.uuid = null;
		}

		objectValidationRuleSettingCacheModel.objectValidationRuleSettingId =
			getObjectValidationRuleSettingId();

		objectValidationRuleSettingCacheModel.companyId = getCompanyId();

		objectValidationRuleSettingCacheModel.userId = getUserId();

		objectValidationRuleSettingCacheModel.userName = getUserName();

		String userName = objectValidationRuleSettingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectValidationRuleSettingCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectValidationRuleSettingCacheModel.createDate =
				createDate.getTime();
		}
		else {
			objectValidationRuleSettingCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectValidationRuleSettingCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			objectValidationRuleSettingCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectValidationRuleSettingCacheModel.objectValidationRuleId =
			getObjectValidationRuleId();

		objectValidationRuleSettingCacheModel.name = getName();

		String name = objectValidationRuleSettingCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectValidationRuleSettingCacheModel.name = null;
		}

		objectValidationRuleSettingCacheModel.value = getValue();

		String value = objectValidationRuleSettingCacheModel.value;

		if ((value != null) && (value.length() == 0)) {
			objectValidationRuleSettingCacheModel.value = null;
		}

		return objectValidationRuleSettingCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectValidationRuleSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectValidationRuleSetting, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectValidationRuleSetting, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectValidationRuleSetting)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, ObjectValidationRuleSetting>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						ObjectValidationRuleSetting.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectValidationRuleSettingId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectValidationRuleId;
	private String _name;
	private String _value;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectValidationRuleSetting, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectValidationRuleSetting)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectValidationRuleSettingId", _objectValidationRuleSettingId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"objectValidationRuleId", _objectValidationRuleId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("value", _value);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectValidationRuleSettingId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectValidationRuleId", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("value", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectValidationRuleSetting _escapedModel;

}