/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectValidationRuleSetting;
import com.liferay.object.service.ObjectValidationRuleSettingLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectValidationRuleSetting service. Represents a row in the &quot;ObjectValidationRuleSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectValidationRuleSettingImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectValidationRuleSettingImpl
 * @see ObjectValidationRuleSetting
 * @generated
 */
public abstract class ObjectValidationRuleSettingBaseImpl
	extends ObjectValidationRuleSettingModelImpl
	implements ObjectValidationRuleSetting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object validation rule setting model instance should use the <code>ObjectValidationRuleSetting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectValidationRuleSettingLocalServiceUtil.
				addObjectValidationRuleSetting(this);
		}
		else {
			ObjectValidationRuleSettingLocalServiceUtil.
				updateObjectValidationRuleSetting(this);
		}
	}

}