/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.model.ObjectStateFlowModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectStateFlow service. Represents a row in the &quot;ObjectStateFlow&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectStateFlowModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectStateFlowImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectStateFlowImpl
 * @generated
 */
public class ObjectStateFlowModelImpl
	extends BaseModelImpl<ObjectStateFlow> implements ObjectStateFlowModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object state flow model instance should use the <code>ObjectStateFlow</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectStateFlow";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectStateFlowId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectFieldId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectStateFlowId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectFieldId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectStateFlow (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectStateFlowId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectFieldId LONG)";

	public static final String TABLE_SQL_DROP = "drop table ObjectStateFlow";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectStateFlow.objectStateFlowId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectStateFlow.objectStateFlowId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTSTATEFLOWID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectStateFlowModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectStateFlowId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectStateFlowId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectStateFlowId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectStateFlow.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectStateFlow.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectStateFlow, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectStateFlow, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectStateFlow, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectStateFlow)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectStateFlow, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectStateFlow, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectStateFlow)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectStateFlow, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectStateFlow, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectStateFlow, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectStateFlow, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectStateFlow, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectStateFlow::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectStateFlow::getUuid);
			attributeGetterFunctions.put(
				"objectStateFlowId", ObjectStateFlow::getObjectStateFlowId);
			attributeGetterFunctions.put(
				"companyId", ObjectStateFlow::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectStateFlow::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectStateFlow::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectStateFlow::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectStateFlow::getModifiedDate);
			attributeGetterFunctions.put(
				"objectFieldId", ObjectStateFlow::getObjectFieldId);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectStateFlow, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectStateFlow, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<ObjectStateFlow, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectStateFlow, Long>)
					ObjectStateFlow::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectStateFlow, String>)ObjectStateFlow::setUuid);
			attributeSetterBiConsumers.put(
				"objectStateFlowId",
				(BiConsumer<ObjectStateFlow, Long>)
					ObjectStateFlow::setObjectStateFlowId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectStateFlow, Long>)
					ObjectStateFlow::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectStateFlow, Long>)ObjectStateFlow::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectStateFlow, String>)
					ObjectStateFlow::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectStateFlow, Date>)
					ObjectStateFlow::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectStateFlow, Date>)
					ObjectStateFlow::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectFieldId",
				(BiConsumer<ObjectStateFlow, Long>)
					ObjectStateFlow::setObjectFieldId);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectStateFlowId() {
		return _objectStateFlowId;
	}

	@Override
	public void setObjectStateFlowId(long objectStateFlowId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectStateFlowId = objectStateFlowId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectFieldId() {
		return _objectFieldId;
	}

	@Override
	public void setObjectFieldId(long objectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldId = objectFieldId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectFieldId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectFieldId"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectStateFlow.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectStateFlow.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectStateFlow toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectStateFlow>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectStateFlowImpl objectStateFlowImpl = new ObjectStateFlowImpl();

		objectStateFlowImpl.setMvccVersion(getMvccVersion());
		objectStateFlowImpl.setUuid(getUuid());
		objectStateFlowImpl.setObjectStateFlowId(getObjectStateFlowId());
		objectStateFlowImpl.setCompanyId(getCompanyId());
		objectStateFlowImpl.setUserId(getUserId());
		objectStateFlowImpl.setUserName(getUserName());
		objectStateFlowImpl.setCreateDate(getCreateDate());
		objectStateFlowImpl.setModifiedDate(getModifiedDate());
		objectStateFlowImpl.setObjectFieldId(getObjectFieldId());

		objectStateFlowImpl.resetOriginalValues();

		return objectStateFlowImpl;
	}

	@Override
	public ObjectStateFlow cloneWithOriginalValues() {
		ObjectStateFlowImpl objectStateFlowImpl = new ObjectStateFlowImpl();

		objectStateFlowImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectStateFlowImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectStateFlowImpl.setObjectStateFlowId(
			this.<Long>getColumnOriginalValue("objectStateFlowId"));
		objectStateFlowImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectStateFlowImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectStateFlowImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectStateFlowImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectStateFlowImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectStateFlowImpl.setObjectFieldId(
			this.<Long>getColumnOriginalValue("objectFieldId"));

		return objectStateFlowImpl;
	}

	@Override
	public int compareTo(ObjectStateFlow objectStateFlow) {
		long primaryKey = objectStateFlow.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectStateFlow)) {
			return false;
		}

		ObjectStateFlow objectStateFlow = (ObjectStateFlow)object;

		long primaryKey = objectStateFlow.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectStateFlow> toCacheModel() {
		ObjectStateFlowCacheModel objectStateFlowCacheModel =
			new ObjectStateFlowCacheModel();

		objectStateFlowCacheModel.mvccVersion = getMvccVersion();

		objectStateFlowCacheModel.uuid = getUuid();

		String uuid = objectStateFlowCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectStateFlowCacheModel.uuid = null;
		}

		objectStateFlowCacheModel.objectStateFlowId = getObjectStateFlowId();

		objectStateFlowCacheModel.companyId = getCompanyId();

		objectStateFlowCacheModel.userId = getUserId();

		objectStateFlowCacheModel.userName = getUserName();

		String userName = objectStateFlowCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectStateFlowCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectStateFlowCacheModel.createDate = createDate.getTime();
		}
		else {
			objectStateFlowCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectStateFlowCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectStateFlowCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectStateFlowCacheModel.objectFieldId = getObjectFieldId();

		return objectStateFlowCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectStateFlow, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectStateFlow, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectStateFlow, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectStateFlow)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectStateFlow>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectStateFlow.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectStateFlowId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectFieldId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectStateFlow, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectStateFlow)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectStateFlowId", _objectStateFlowId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectFieldId", _objectFieldId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectStateFlowId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectFieldId", 256L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectStateFlow _escapedModel;

}