/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectAction;
import com.liferay.object.service.ObjectActionLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectAction service. Represents a row in the &quot;ObjectAction&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectActionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectActionImpl
 * @see ObjectAction
 * @generated
 */
public abstract class ObjectActionBaseImpl
	extends ObjectActionModelImpl implements ObjectAction {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object action model instance should use the <code>ObjectAction</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectActionLocalServiceUtil.addObjectAction(this);
		}
		else {
			ObjectActionLocalServiceUtil.updateObjectAction(this);
		}
	}

}