/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.persistence.impl;

import com.liferay.object.model.ObjectViewColumnTable;
import com.liferay.object.model.impl.ObjectViewColumnImpl;
import com.liferay.object.model.impl.ObjectViewColumnModelImpl;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;

@Component(service={ArgumentsResolver.class})
public class ObjectViewColumnModelArgumentsResolver
implements ArgumentsResolver {
    private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

    public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
        String[] columnNames = finderPath.getColumnNames();
        if (columnNames == null || columnNames.length == 0) {
            if (baseModel.isNew()) {
                return new Object[0];
            }
            return null;
        }
        ObjectViewColumnModelImpl objectViewColumnModelImpl = (ObjectViewColumnModelImpl)baseModel;
        long columnBitmask = objectViewColumnModelImpl.getColumnBitmask();
        if (!checkColumn || columnBitmask == 0L) {
            return ObjectViewColumnModelArgumentsResolver._getValue(objectViewColumnModelImpl, columnNames, original);
        }
        Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
        if (finderPathColumnBitmask == null) {
            finderPathColumnBitmask = 0L;
            for (String columnName : columnNames) {
                finderPathColumnBitmask = finderPathColumnBitmask | ObjectViewColumnModelImpl.getColumnBitmask(columnName);
            }
            _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
        }
        if ((columnBitmask & finderPathColumnBitmask) != 0L) {
            return ObjectViewColumnModelArgumentsResolver._getValue(objectViewColumnModelImpl, columnNames, original);
        }
        return null;
    }

    public String getClassName() {
        return ObjectViewColumnImpl.class.getName();
    }

    public String getTableName() {
        return ObjectViewColumnTable.INSTANCE.getTableName();
    }

    private static Object[] _getValue(ObjectViewColumnModelImpl objectViewColumnModelImpl, String[] columnNames, boolean original) {
        Object[] arguments = new Object[columnNames.length];
        for (int i = 0; i < arguments.length; ++i) {
            String columnName = columnNames[i];
            arguments[i] = original ? objectViewColumnModelImpl.getColumnOriginalValue(columnName) : objectViewColumnModelImpl.getColumnValue(columnName);
        }
        return arguments;
    }
}

