/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.model.AccountEntryOrganizationRelTable;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.model.AccountEntryUserRelTable;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectEntryValuesException;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.field.util.ObjectFieldFormulaEvaluatorUtil;
import com.liferay.object.internal.action.util.ObjectActionThreadLocal;
import com.liferay.object.internal.filter.parser.ObjectFilterParser;
import com.liferay.object.internal.filter.parser.ObjectFilterParserServiceRegistry;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFilter;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.petra.sql.dsl.expression.FilterPredicateFactory;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.object.service.base.ObjectEntryLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectFieldSettingPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.expression.ScalarDSLQueryAlias;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.query.QueryExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.dao.jdbc.postgresql.PostgreSQLJDBCUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.ResourcePermissionTable;
import com.liferay.portal.kernel.model.RoleTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleTable;
import com.liferay.portal.kernel.model.Users_OrgsTable;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.configuration.ObjectConfiguration"}, property={"model.class.name=com.liferay.object.model.ObjectEntry"}, service={AopService.class})
public class ObjectEntryLocalServiceImpl
extends ObjectEntryLocalServiceBaseImpl {
    private static final Expression<?>[] _EXPRESSIONS = new Expression[]{ObjectEntryTable.INSTANCE.objectEntryId, ObjectEntryTable.INSTANCE.userName, ObjectEntryTable.INSTANCE.createDate, ObjectEntryTable.INSTANCE.modifiedDate, ObjectEntryTable.INSTANCE.externalReferenceCode, ObjectEntryTable.INSTANCE.status};
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryLocalServiceImpl.class);
    private static final ThreadLocal<Boolean> _skipModelListeners = new CentralizedThreadLocal(ObjectEntryLocalServiceImpl.class + "._skipModelListeners", () -> false);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private FilterPredicateFactory _filterPredicateFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private Localization _localization;
    private volatile ObjectConfiguration _objectConfiguration;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFieldSettingPersistence _objectFieldSettingPersistence;
    @Reference
    private ObjectFilterParserServiceRegistry _objectFilterParserServiceRegistry;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private ObjectStateFlowLocalService _objectStateFlowLocalService;
    @Reference
    private ObjectStateLocalService _objectStateLocalService;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public ObjectEntry addObjectEntry(long userId, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateGroupId(groupId, objectDefinition.getScope());
        User user = this._userLocalService.getUser(userId);
        this._validateValues(user.isDefaultUser(), objectDefinitionId, null, objectDefinition.getPortletId(), serviceContext, userId, values);
        this._fillBusinessTypePicklistDefaultValue(this._objectFieldLocalService.getObjectFields(objectDefinitionId), values);
        long objectEntryId = this.counterLocalService.increment();
        this._insertIntoTable(this._getDynamicObjectDefinitionTable(objectDefinitionId), objectEntryId, values);
        this._insertIntoTable(this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId), objectEntryId, values);
        ObjectEntry objectEntry = this.objectEntryPersistence.create(objectEntryId);
        this._setExternalReferenceCode(objectEntry, values);
        objectEntry.setGroupId(groupId);
        objectEntry.setCompanyId(user.getCompanyId());
        objectEntry.setUserId(user.getUserId());
        objectEntry.setUserName(user.getFullName());
        objectEntry.setObjectDefinitionId(objectDefinitionId);
        objectEntry.setStatus(2);
        objectEntry.setStatusByUserId(user.getUserId());
        objectEntry.setStatusDate(serviceContext.getModifiedDate(null));
        this._resourceLocalService.addResources(objectEntry.getCompanyId(), objectEntry.getGroupId(), objectEntry.getUserId(), objectDefinition.getClassName(), objectEntry.getPrimaryKey(), false, false, false);
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this.updateAsset(serviceContext.getUserId(), objectEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this._startWorkflowInstance(userId, objectEntry, serviceContext);
        this._reindex(objectEntry);
        ObjectActionThreadLocal.clearObjectActionIds();
        return objectEntry;
    }

    public ObjectEntry addObjectEntry(String externalReferenceCode, long userId, ObjectDefinition objectDefinition) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.create(this.counterLocalService.increment());
        objectEntry.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        objectEntry.setCompanyId(user.getCompanyId());
        objectEntry.setUserId(user.getUserId());
        objectEntry.setUserName(user.getFullName());
        objectEntry.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectEntry.setStatus(2);
        objectEntry.setStatusDate(new Date());
        return this.objectEntryPersistence.updateImpl(objectEntry);
    }

    public void addOrUpdateExtensionDynamicObjectDefinitionTableValues(long userId, ObjectDefinition objectDefinition, long primaryKey, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateValues(user.isDefaultUser(), objectDefinition.getObjectDefinitionId(), null, objectDefinition.getClassName(), serviceContext, userId, values);
        this.insertIntoOrUpdateExtensionTable(objectDefinition.getObjectDefinitionId(), primaryKey, values);
        this._clearExtensionDynamicObjectDefinitionTableCache(objectDefinition.getObjectDefinitionId(), primaryKey);
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long userId, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (groupId != 0L) {
            Group group = this._groupLocalService.getGroup(groupId);
            if (user.getCompanyId() != group.getCompanyId()) {
                throw new PrincipalException();
            }
        }
        ObjectEntry objectEntry = null;
        if (Validator.isNotNull((String)externalReferenceCode) && (objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, user.getCompanyId(), objectDefinitionId)) != null) {
            return this.updateObjectEntry(userId, objectEntry.getObjectEntryId(), values, serviceContext);
        }
        objectEntry = this.addObjectEntry(userId, groupId, objectDefinitionId, values, serviceContext);
        if (Validator.isNotNull((String)externalReferenceCode)) {
            objectEntry.setExternalReferenceCode(externalReferenceCode);
            objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        }
        this._reindex(objectEntry);
        return objectEntry;
    }

    public void deleteExtensionDynamicObjectDefinitionTableValues(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        Map<String, Serializable> extensionDynamicObjectDefinitionTableValues = this.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, primaryKey);
        this._deleteFromTable(objectDefinition.getExtensionDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), primaryKey);
        this.deleteRelatedObjectEntries(0L, objectDefinition.getObjectDefinitionId(), primaryKey);
        this._deleteFileEntries(Collections.emptyMap(), objectDefinition.getObjectDefinitionId(), extensionDynamicObjectDefinitionTableValues);
        this._clearExtensionDynamicObjectDefinitionTableCache(objectDefinition.getObjectDefinitionId(), primaryKey);
    }

    @Override
    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    @Override
    @SystemEvent(type=1)
    public ObjectEntry deleteObjectEntry(ObjectEntry objectEntry) throws PortalException {
        Map values = objectEntry.getValues();
        objectEntry = (ObjectEntry)this.objectEntryPersistence.remove((BaseModel)objectEntry);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._resourceLocalService.deleteResource(objectEntry.getCompanyId(), objectDefinition.getClassName(), 4, objectEntry.getObjectEntryId());
        this._assetEntryLocalService.deleteEntry(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        this._deleteFromTable(objectDefinition.getDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), objectEntry.getObjectEntryId());
        this._deleteFromTable(objectDefinition.getExtensionDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), objectEntry.getObjectEntryId());
        this.deleteRelatedObjectEntries(objectEntry.getGroupId(), objectDefinition.getObjectDefinitionId(), objectEntry.getPrimaryKey());
        this._deleteFileEntries(Collections.emptyMap(), objectDefinition.getObjectDefinitionId(), values);
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition.getClassName());
        indexer.delete((Object)objectEntry);
        return objectEntry;
    }

    public ObjectEntry deleteObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    public void deleteRelatedObjectEntries(long groupId, long objectDefinitionId, long primaryKey) throws PortalException {
        List objectRelationships = this._objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId);
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition2.getClassName(), objectRelationship.getType());
            objectRelatedModelsProvider.deleteRelatedModel(PrincipalThreadLocal.getUserId(), groupId, objectRelationship.getObjectRelationshipId(), primaryKey);
        }
    }

    public ObjectEntry fetchObjectEntry(String externalReferenceCode, long objectDefinitionId) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public Map<Object, Long> getAggregationCounts(long objectDefinitionId, String aggregationTerm, Predicate predicate, int start, int end) throws PortalException {
        HashMap<Object, Long> aggregationCounts = new HashMap<Object, Long>();
        Table table = this._objectFieldLocalService.getTable(objectDefinitionId, aggregationTerm);
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, aggregationTerm);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{table.getColumn(objectField.getDBColumnName()), DSLFunctionFactoryUtil.countDistinct(dynamicObjectDefinitionTable.getPrimaryKeyColumn()).as("aggregationCount")}).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and((Expression)predicate).and(() -> {
            if (PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._inlineSQLHelper.getPermissionWherePredicate(dynamicObjectDefinitionTable.getName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[0]);
        })).groupBy(new Expression[]{table.getColumn(objectField.getDBColumnName())}).limit(start, end);
        for (Object[] values : (List)this.dslQuery(dslQuery)) {
            aggregationCounts.put(GetterUtil.getObject((Object)values[0]), GetterUtil.getLong((Object)values[1]));
        }
        return aggregationCounts;
    }

    public Map<String, Serializable> getExtensionDynamicObjectDefinitionTableValues(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        Expression<?>[] selectExpressions;
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinition.getObjectDefinitionId());
        List<Object[]> rows = this._list(this._getExtensionDynamicObjectDefinitionTableSelectDSLQuery(extensionDynamicObjectDefinitionTable, primaryKey, selectExpressions = this._getSelectExpressions(extensionDynamicObjectDefinitionTable)), selectExpressions);
        if (rows.isEmpty()) {
            return new HashMap<String, Serializable>();
        }
        Map<String, Serializable> values = this._getValues(rows.get(0), selectExpressions);
        values.remove(objectDefinition.getPKObjectFieldName());
        this._addObjectRelationshipERCFieldValue(objectDefinition.getObjectDefinitionId(), values);
        return values;
    }

    public List<ObjectEntry> getManyToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, int start, int end) throws PortalException {
        DSLQuery dslQuery = this._getManyToManyObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, related, reverse, DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE)).limit(start, end);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get many to many related object entries: " + dslQuery));
        }
        return (List)this.objectEntryPersistence.dslQuery(dslQuery);
    }

    public int getManyToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse) throws PortalException {
        GroupByStep dslQuery = this._getManyToManyObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, related, reverse, DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get many to many related object entries count: " + dslQuery));
        }
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public List<ObjectEntry> getObjectEntries(long groupId, long objectDefinitionId, int start, int end) throws PortalException {
        return this.objectEntryPersistence.findByG_ODI(groupId, objectDefinitionId, start, end);
    }

    public List<ObjectEntry> getObjectEntries(long groupId, long objectDefinitionId, int status, int start, int end) throws PortalException {
        return this.objectEntryPersistence.findByG_ODI_S(groupId, objectDefinitionId, status, start, end);
    }

    public int getObjectEntriesCount(long groupId, long objectDefinitionId) {
        return this.objectEntryPersistence.countByG_ODI(groupId, objectDefinitionId);
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.objectEntryPersistence.findByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        return this.objectEntryPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
    }

    public List<ObjectEntry> getOneToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, int start, int end) throws PortalException {
        DSLQuery dslQuery = this._getOneToManyObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, related, DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE)).limit(start, end);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries: " + dslQuery));
        }
        return (List)this.objectEntryPersistence.dslQuery(dslQuery);
    }

    public int getOneToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related) throws PortalException {
        GroupByStep dslQuery = this._getOneToManyObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, related, DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries count: " + dslQuery));
        }
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public Map<String, Object> getSystemModelAttributes(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        if (!objectDefinition.isSystem()) {
            return new HashMap<String, Object>();
        }
        Map baseModelAttributes = new HashMap();
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinition.getObjectDefinitionId());
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        List baseModels = (List)persistedModelLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)dynamicObjectDefinitionTable).where(primaryKeyColumn.eq((Object)primaryKey)));
        if (!baseModels.isEmpty()) {
            BaseModel baseModel = (BaseModel)baseModels.get(0);
            baseModelAttributes = baseModel.getModelAttributes();
        }
        HashMap modelAttributes = HashMapBuilder.put((Object)"createDate", (Object)GetterUtil.get(baseModelAttributes.get("createDate"), (long)primaryKey)).put((Object)"externalReferenceCode", (Object)GetterUtil.get(baseModelAttributes.get("externalReferenceCode"), (long)primaryKey)).put((Object)"modifiedDate", (Object)GetterUtil.get(baseModelAttributes.get("modifiedDate"), (long)primaryKey)).put((Object)"objectDefinitionId", (Object)objectDefinition.getObjectDefinitionId()).put((Object)"uuid", (Object)GetterUtil.get(baseModelAttributes.get("uuid"), (long)primaryKey)).build();
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            if (!objectField.isSystem()) continue;
            Object value = GetterUtil.getObject(baseModelAttributes.get(objectField.getDBColumnName()), (Object)primaryKey);
            if (value instanceof String) {
                value = this._localization.getLocalization((String)value, null, true);
            }
            modelAttributes.put(objectField.getName(), value);
        }
        modelAttributes.putAll(this.objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, primaryKey));
        return modelAttributes;
    }

    public Map<String, Serializable> getSystemValues(ObjectEntry objectEntry) throws PortalException {
        List<Object[]> rows = this._list((DSLQuery)DSLQueryFactoryUtil.select(_EXPRESSIONS).from((Table)ObjectEntryTable.INSTANCE).where(ObjectEntryTable.INSTANCE.objectEntryId.eq((Object)objectEntry.getObjectEntryId())), _EXPRESSIONS);
        return this._getValues(rows.get(0), _EXPRESSIONS);
    }

    public String getTitleValue(long objectDefinitionId, long primaryKey) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (!objectDefinition.isSystem()) {
            ObjectEntry objectEntry = this.getObjectEntry(primaryKey);
            return objectEntry.getTitleValue();
        }
        ObjectField titleObjectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
        if (Objects.isNull(titleObjectField)) {
            titleObjectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, "id");
        }
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(primaryKey))));
        return jsonObject.getString(titleObjectField.getDBColumnName());
    }

    public Map<String, Serializable> getValues(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        return this.getValues(objectEntry);
    }

    public Map<String, Serializable> getValues(ObjectEntry objectEntry) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId());
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId());
        Expression[] selectExpressions = (Expression[])ArrayUtil.append((Object[])this._getSelectExpressions(dynamicObjectDefinitionTable), (Object[])ArrayUtil.remove((Object[])this._getSelectExpressions(extensionDynamicObjectDefinitionTable), extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
        List<Object[]> rows = this._list((DSLQuery)DSLQueryFactoryUtil.select((Expression[])selectExpressions).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)extensionDynamicObjectDefinitionTable, dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)objectEntry.getObjectEntryId())), selectExpressions);
        Map<String, Serializable> values = this._getValues(rows.get(0), selectExpressions);
        this._addObjectRelationshipERCFieldValue(objectEntry.getObjectDefinitionId(), values);
        return this._putFormulaObjectFieldValues(objectEntry.getObjectDefinitionId(), values);
    }

    public List<Map<String, Serializable>> getValuesList(long groupId, long companyId, long userId, long objectDefinitionId, Predicate predicate, String search, int start, int end, OrderByExpression[] orderByExpressions) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        Expression[] selectExpressions = (Expression[])ArrayUtil.append((Object[][])new Expression[][]{this._getSelectExpressions(dynamicObjectDefinitionTable), (Expression[])ArrayUtil.remove((Object[])this._getSelectExpressions(extensionDynamicObjectDefinitionTable), extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn()), _EXPRESSIONS});
        List<Object[]> rows = this._list(DSLQueryFactoryUtil.select((Expression[])selectExpressions).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and(() -> {
            if (groupId == 0L) {
                return null;
            }
            return ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId);
        }).and((Expression)this._fillPredicate(objectDefinitionId, predicate, search)).and((Expression)this._getPermissionWherePredicate(dynamicObjectDefinitionTable, groupId))).orderBy(orderByExpressions).limit(start, end), selectExpressions);
        ArrayList<Map<String, Serializable>> valuesList = new ArrayList<Map<String, Serializable>>(rows.size());
        for (Object[] objects : rows) {
            valuesList.add(this._getValues(objects, selectExpressions));
        }
        return valuesList;
    }

    public int getValuesListCount(long groupId, long companyId, long userId, long objectDefinitionId, Predicate predicate, String search) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        GroupByStep dslQuery = DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and(() -> {
            if (groupId == 0L) {
                return null;
            }
            return ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId);
        }).and((Expression)this._fillPredicate(objectDefinitionId, predicate, search)).and((Expression)this._getPermissionWherePredicate(dynamicObjectDefinitionTable, groupId)));
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public void insertIntoOrUpdateExtensionTable(long objectDefinitionId, long primaryKey, Map<String, Serializable> values) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        int count = this.objectEntryPersistence.dslQueryCount(this._getExtensionDynamicObjectDefinitionTableCountDSLQuery(dynamicObjectDefinitionTable, primaryKey));
        if (count > 0) {
            this._updateTable(dynamicObjectDefinitionTable, primaryKey, values);
        } else {
            this._insertIntoTable(dynamicObjectDefinitionTable, primaryKey, values);
        }
    }

    public BaseModelSearchResult<ObjectEntry> searchObjectEntries(long groupId, long objectDefinitionId, String keywords, int cur, int delta) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{objectDefinition.getClassName()}).emptySearchEnabled(true).from(Integer.valueOf(cur)).size(Integer.valueOf(delta)).sorts(new Sort[]{this._sorts.field("entryClassPK", SortOrder.ASC)}).withSearchContext(searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(objectDefinition.getObjectDefinitionId()));
            searchContext.setCompanyId(objectDefinition.getCompanyId());
            if (objectScopeProvider.isGroupAware()) {
                searchContext.setGroupIds(new long[]{groupId});
            } else {
                searchContext.setGroupIds(new long[]{0L});
            }
            searchContext.setKeywords(keywords);
        });
        SearchResponse searchResponse = this._searcher.search(searchRequestBuilder.build());
        SearchHits searchHits = searchResponse.getSearchHits();
        List searchHitsList = searchHits.getSearchHits();
        Stream stream = searchHitsList.stream();
        List objectEntries = stream.map(searchHit -> {
            Document document = searchHit.getDocument();
            long objectEntryId = document.getLong("entryClassPK");
            return this.objectEntryPersistence.fetchByPrimaryKey(objectEntryId);
        }).collect(Collectors.toList());
        return new BaseModelSearchResult(objectEntries, searchResponse.getTotalHits());
    }

    public void updateAsset(long userId, ObjectEntry objectEntry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        String title;
        ObjectDefinition objectDefinition;
        block2: {
            objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
            title = "";
            try {
                title = objectEntry.getTitleValue();
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)portalException);
            }
        }
        AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, objectEntry.getNonzeroGroupId(), objectEntry.getCreateDate(), objectEntry.getModifiedDate(), objectDefinition.getClassName(), objectEntry.getObjectEntryId(), objectEntry.getUuid(), 0L, assetCategoryIds, assetTagNames, true, objectEntry.isApproved(), null, null, null, null, "text/plain", title, String.valueOf(objectEntry.getObjectEntryId()), null, null, null, 0, 0, priority);
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public ObjectEntry updateObjectEntry(long userId, long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._validateValues(user.isDefaultUser(), objectEntry.getObjectDefinitionId(), objectEntry, objectDefinition.getPortletId(), serviceContext, userId, values);
        Map transientValues = objectEntry.getValues();
        this._updateTable(this._getDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId()), objectEntryId, values);
        this._updateTable(this._getExtensionDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId()), objectEntryId, values);
        this.objectEntryPersistence.clearCache(SetUtil.fromArray((Object[])new Serializable[]{Long.valueOf(objectEntryId)}));
        objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        this._setExternalReferenceCode(objectEntry, values);
        objectEntry.setModifiedDate(serviceContext.getModifiedDate(null));
        objectEntry.setTransientValues(transientValues);
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this.updateAsset(serviceContext.getUserId(), objectEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this._startWorkflowInstance(userId, objectEntry, serviceContext);
        this._deleteFileEntries(values, objectEntry.getObjectDefinitionId(), transientValues);
        this._reindex(objectEntry);
        return objectEntry;
    }

    public ObjectEntry updateStatus(long userId, long objectEntryId, int status, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        if (objectEntry.getStatus() == status) {
            return objectEntry;
        }
        objectEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        objectEntry.setStatusByUserId(user.getUserId());
        objectEntry.setStatusByUserName(user.getFullName());
        objectEntry.setStatusDate(serviceContext.getModifiedDate(null));
        if (_skipModelListeners.get().booleanValue()) {
            while (objectEntry instanceof ModelWrapper) {
                ModelWrapper modelWrapper = (ModelWrapper)objectEntry;
                objectEntry = (ObjectEntry)modelWrapper.getWrappedModel();
            }
            objectEntry = this.objectEntryPersistence.updateImpl(objectEntry);
        } else {
            objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._assetEntryLocalService.updateEntry(objectDefinition.getClassName(), objectEntry.getObjectEntryId(), null, null, true, objectEntry.isApproved());
        this._reindex(objectEntry);
        return objectEntry;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._objectConfiguration = (ObjectConfiguration)ConfigurableUtil.createConfigurable(ObjectConfiguration.class, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addFileEntry(DLFileEntry dlFileEntry, Map.Entry<String, Serializable> entry, List<ObjectFieldSetting> objectFieldSettings, String portletId, ServiceContext serviceContext, long userId) throws PortalException {
        try {
            String fileSource = null;
            boolean showFilesInDocumentsAndMedia = false;
            String storageDLFolderPath = null;
            for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
                if (Objects.equals(objectFieldSetting.getName(), "fileSource")) {
                    fileSource = objectFieldSetting.getValue();
                    continue;
                }
                if (Objects.equals(objectFieldSetting.getName(), "showFilesInDocumentsAndMedia")) {
                    showFilesInDocumentsAndMedia = GetterUtil.getBoolean((String)objectFieldSetting.getValue());
                    continue;
                }
                if (!Objects.equals(objectFieldSetting.getName(), "storageDLFolderPath")) continue;
                storageDLFolderPath = objectFieldSetting.getValue();
            }
            if (Objects.equals("documentsAndMedia", fileSource)) {
                return;
            }
            DLFolder dlFileEntryFolder = dlFileEntry.getFolder();
            DLFolder dlFolder = this._getDLFolder(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), portletId, serviceContext, showFilesInDocumentsAndMedia, storageDLFolderPath, userId);
            if (Objects.equals(dlFileEntryFolder.getFolderId(), dlFolder.getFolderId())) {
                return;
            }
            String originalFileName = TempFileEntryUtil.getOriginalTempFileName((String)dlFileEntry.getFileName());
            FileEntry fileEntry = this._dlAppLocalService.addFileEntry(null, userId, dlFolder.getRepositoryId(), dlFolder.getFolderId(), DLUtil.getUniqueFileName((long)dlFileEntry.getGroupId(), (long)dlFolder.getFolderId(), (String)originalFileName, (boolean)true), dlFileEntry.getMimeType(), DLUtil.getUniqueTitle((long)dlFileEntry.getGroupId(), (long)dlFolder.getFolderId(), (String)FileUtil.stripExtension((String)originalFileName)), "", null, null, dlFileEntry.getContentStream(), dlFileEntry.getSize(), null, null, serviceContext);
            entry.setValue(Long.valueOf(fileEntry.getFileEntryId()));
        }
        finally {
            if (dlFileEntry != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)dlFileEntry.getFileEntryId());
            }
        }
    }

    private void _addObjectRelationshipERCFieldValue(long objectDefinitionId, Map<String, Serializable> values) {
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinitionId, false)) {
            long primaryKey;
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany") || (primaryKey = GetterUtil.getLong((Object)values.get(objectField.getName()))) == 0L) continue;
            ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectField.getObjectFieldId());
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField);
            if (objectDefinition.isSystem()) {
                SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataRegistry.getSystemObjectDefinitionMetadata(objectDefinition.getName());
                try {
                    values.put(objectRelationshipERCObjectFieldName, (Serializable)((Object)systemObjectDefinitionMetadata.getExternalReferenceCode(primaryKey)));
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)portalException);
                }
                continue;
            }
            ObjectEntry objectEntry = this.objectEntryPersistence.fetchByPrimaryKey(primaryKey);
            if (objectEntry == null) continue;
            values.put(objectRelationshipERCObjectFieldName, (Serializable)((Object)objectEntry.getExternalReferenceCode()));
        }
    }

    private void _clearExtensionDynamicObjectDefinitionTableCache(long objectDefinitionId, long primaryKey) throws PortalException {
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        String tableName = extensionDynamicObjectDefinitionTable.getTableName();
        this._clearFinderCache(this._getExtensionDynamicObjectDefinitionTableCountDSLQuery(extensionDynamicObjectDefinitionTable, primaryKey), primaryKey, tableName);
        this._clearFinderCache(this._getExtensionDynamicObjectDefinitionTableSelectDSLQuery(extensionDynamicObjectDefinitionTable, primaryKey, this._getSelectExpressions(extensionDynamicObjectDefinitionTable)), primaryKey, tableName);
    }

    private void _clearFinderCache(DSLQuery dslQuery, long primaryKey, String tableName) {
        StringBundler sb = new StringBundler();
        dslQuery.toSQL(arg_0 -> ((StringBundler)sb).append(arg_0), (ASTNodeListener)new DefaultASTNodeListener());
        FinderCacheUtil.removeResult((FinderPath)new FinderPath(FinderPath.encodeDSLQueryCacheName((String[])new String[]{tableName}), "dslQuery", sb.getStrings(), new String[0], false), (Object[])new Long[]{primaryKey});
    }

    private void _deleteFileEntries(Map<String, Serializable> newValues, long objectDefinitionId, Map<String, Serializable> oldValues) {
        List objectFields = this._objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            ObjectFieldSetting objectFieldSetting;
            if (objectField.isSystem()) continue;
            String objectFieldName = objectField.getName();
            if (!Objects.equals(objectField.getBusinessType(), "Attachment") || Objects.equals(GetterUtil.getLong((Object)newValues.get(objectFieldName)), GetterUtil.getLong((Object)oldValues.get(objectFieldName))) || !Objects.equals((objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "fileSource")).getValue(), "userComputer") || (objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "showFilesInDocumentsAndMedia")) != null && GetterUtil.getBoolean((String)objectFieldSetting.getValue())) continue;
            try {
                this._dlFileEntryLocalService.deleteFileEntry(GetterUtil.getLong((Object)oldValues.get(objectFieldName)));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
    }

    private void _deleteFromTable(String dbTableName, String pkObjectFieldDBColumnName, long primaryKey) throws PortalException {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", dbTableName, " where ", pkObjectFieldDBColumnName, " = ", primaryKey}));
        FinderCacheUtil.clearDSLQueryCache((String)dbTableName);
    }

    private void _fillBusinessTypePicklistDefaultValue(List<ObjectField> objectFields, Map<String, Serializable> values) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(objectField.getBusinessType(), "Picklist") || values.containsKey(objectField.getName()) || !Validator.isNotNull((String)objectField.getDefaultValue())) continue;
            values.put(objectField.getName(), (Serializable)((Object)objectField.getDefaultValue()));
        }
    }

    private Predicate _fillObjectFieldPredicate(Column<?, Object> column, String dbType, String search) {
        if (com.liferay.portal.kernel.util.StringUtil.equals((String)dbType, (String)"BigDecimal") || dbType.equals("Double")) {
            BigDecimal searchBigDecimal = BigDecimal.valueOf(GetterUtil.getDouble((String)search));
            if (searchBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                return column.eq((Object)searchBigDecimal);
            }
        } else {
            long searchLong;
            if (com.liferay.portal.kernel.util.StringUtil.equals((String)dbType, (String)"Clob") || com.liferay.portal.kernel.util.StringUtil.equals((String)dbType, (String)"String")) {
                return column.like("%" + search + "%");
            }
            if ((com.liferay.portal.kernel.util.StringUtil.equals((String)dbType, (String)"Integer") || com.liferay.portal.kernel.util.StringUtil.equals((String)dbType, (String)"Long")) && (searchLong = GetterUtil.getLong((String)search)) != 0L) {
                return column.eq((Object)searchLong);
            }
        }
        return null;
    }

    private Predicate _fillPredicate(long objectDefinitionId, Predicate predicate, String search) throws PortalException {
        if (Validator.isNull((String)search)) {
            return predicate;
        }
        List objectFields = this._objectFieldPersistence.findByODI_I(objectDefinitionId, true);
        if (objectFields.isEmpty()) {
            return predicate;
        }
        Predicate searchPredicate = null;
        for (ObjectField objectField : objectFields) {
            Table table = this._objectFieldLocalService.getTable(objectDefinitionId, objectField.getName());
            Column column = table.getColumn(objectField.getDBColumnName());
            if (column == null) continue;
            Predicate objectFieldPredicate = this._fillObjectFieldPredicate(column, objectField.getDBType(), search);
            if (searchPredicate == null) {
                searchPredicate = objectFieldPredicate;
                continue;
            }
            searchPredicate = searchPredicate.or((Expression)objectFieldPredicate);
        }
        long searchLong = GetterUtil.getLong((String)search);
        if (searchLong != 0L) {
            searchPredicate = searchPredicate.or((Expression)ObjectEntryTable.INSTANCE.objectEntryId.eq((Object)searchLong));
        }
        if (predicate == null) {
            return searchPredicate;
        }
        return predicate.and((Expression)searchPredicate.withParentheses());
    }

    private DSLQuery _getAccountEntriesDSLQuery(long companyId, long userId) throws PortalException {
        JoinStep joinStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}).from((Table)AccountEntryTable.INSTANCE);
        if (this._roleLocalService.hasUserRole(userId, companyId, "Administrator", true)) {
            return joinStep.where(AccountEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)AccountEntryTable.INSTANCE.status.eq((Object)0)));
        }
        Table tempOrganizationTable = DSLQueryFactoryUtil.select((Expression[])new Expression[]{OrganizationTable.INSTANCE.companyId, OrganizationTable.INSTANCE.treePath}).from((Table)OrganizationTable.INSTANCE).innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.organizationId.eq((Expression)OrganizationTable.INSTANCE.organizationId)).where(Users_OrgsTable.INSTANCE.userId.eq((Object)userId)).as("tempOrganizationTable", (Table)OrganizationTable.INSTANCE);
        return joinStep.innerJoinON((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryOrganizationRelTable.INSTANCE.organizationId.in((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{OrganizationTable.INSTANCE.organizationId}).from((Table)OrganizationTable.INSTANCE).innerJoinON(tempOrganizationTable, OrganizationTable.INSTANCE.companyId.eq((Expression)tempOrganizationTable.getColumn("companyId", Long.class)).and((Expression)OrganizationTable.INSTANCE.treePath.like(DSLFunctionFactoryUtil.concat((Expression[])new Expression[]{DSLFunctionFactoryUtil.castText((Expression)tempOrganizationTable.getColumn("treePath", String.class)), new Scalar((Object)"%")}))))).and((Expression)this._getAccountEntryWherePredicate())).union((DSLQuery)joinStep.where(AccountEntryTable.INSTANCE.userId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate()))).union((DSLQuery)joinStep.innerJoinON((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate())));
    }

    private Predicate _getAccountEntryWherePredicate() {
        return AccountEntryTable.INSTANCE.parentAccountEntryId.eq((Object)0L).and((Expression)AccountEntryTable.INSTANCE.status.eq((Object)0)).and((Expression)AccountEntryTable.INSTANCE.type.in((Object[])new String[]{"business", "person"}));
    }

    private DLFolder _getDLFolder(long companyId, long groupId, String portletId, ServiceContext serviceContext, boolean showFilesInDocumentsAndMedia, String storageDLFolderPath, long userId) {
        Long dlFolderId = null;
        dlFolderId = showFilesInDocumentsAndMedia ? this._getStorageDLFolderId(companyId, groupId, serviceContext, storageDLFolderPath) : this._getObjectRepositoryFolderId(companyId, groupId, portletId, serviceContext, userId);
        if (dlFolderId == null) {
            return null;
        }
        return this._dlFolderLocalService.fetchDLFolder(dlFolderId.longValue());
    }

    private DynamicObjectDefinitionTable _getDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
    }

    private DynamicObjectDefinitionTable _getExtensionDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    private DSLQuery _getExtensionDynamicObjectDefinitionTableCountDSLQuery(DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable, long primaryKey) {
        return DSLQueryFactoryUtil.count().from((Table)extensionDynamicObjectDefinitionTable).where(extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)primaryKey));
    }

    private DSLQuery _getExtensionDynamicObjectDefinitionTableSelectDSLQuery(DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable, long primaryKey, Expression<?>[] selectExpressions) {
        return DSLQueryFactoryUtil.select(selectExpressions).from((Table)extensionDynamicObjectDefinitionTable).where(extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)primaryKey));
    }

    private Expression<?> _getFunctionExpression(Map<String, Object> objectFieldSettingsValues, ObjectDefinition relatedObjectDefinition, DynamicObjectDefinitionTable relatedDynamicObjectDefinitionTable) {
        Column column = null;
        String function = GetterUtil.getString((Object)objectFieldSettingsValues.get("function"));
        column = !Objects.equals(function, "COUNT") ? this._objectFieldLocalService.getColumn(relatedObjectDefinition.getObjectDefinitionId(), GetterUtil.getString((Object)objectFieldSettingsValues.get("objectFieldName"))) : relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn();
        if (function.equals("AVERAGE")) {
            return DSLFunctionFactoryUtil.avg(column);
        }
        if (function.equals("COUNT")) {
            return DSLFunctionFactoryUtil.count((Expression)column);
        }
        if (function.equals("MAX")) {
            return DSLFunctionFactoryUtil.max((Expression)column);
        }
        if (function.equals("MIN")) {
            return DSLFunctionFactoryUtil.min((Expression)column);
        }
        if (function.equals("SUM")) {
            return DSLFunctionFactoryUtil.sum((Expression)column);
        }
        throw new IllegalArgumentException("Invalid function " + function);
    }

    private GroupByStep _getManyToManyObjectEntriesGroupByStep(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, FromStep fromStep) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        long objectDefinitionId1 = objectRelationship.getObjectDefinitionId1();
        long objectDefinitionId2 = objectRelationship.getObjectDefinitionId2();
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId2);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId2);
        Column<DynamicObjectDefinitionTable, Long> dynamicObjectDefinitionTablePrimaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId2);
        Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)reverse);
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable((String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), objectRelationship.getDBTableName());
        Column<DynamicObjectRelationshipMappingTable, Long> primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
        Column<DynamicObjectRelationshipMappingTable, Long> primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTablePrimaryKeyColumn)).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTablePrimaryKeyColumn)).leftJoinOn((Table)dynamicObjectRelationshipMappingTable, primaryKeyColumn2.eq(dynamicObjectDefinitionTablePrimaryKeyColumn)).where(ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)ObjectEntryTable.INSTANCE.companyId.eq((Object)objectRelationship.getCompanyId())).and((Expression)ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId2)).and(() -> {
            if (PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._inlineSQLHelper.getPermissionWherePredicate(objectDefinition2.getClassName(), dynamicObjectDefinitionTablePrimaryKeyColumn, new long[0]);
        }).and(() -> {
            if (related) {
                return primaryKeyColumn1.eq((Object)primaryKey);
            }
            return dynamicObjectDefinitionTablePrimaryKeyColumn.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{primaryKeyColumn2}).from((Table)dynamicObjectRelationshipMappingTable).where(primaryKeyColumn1.eq((Object)primaryKey)));
        }).and(() -> {
            if (objectDefinition1.getObjectDefinitionId() == objectDefinition2.getObjectDefinitionId()) {
                return dynamicObjectDefinitionTablePrimaryKeyColumn.neq((Object)primaryKey);
            }
            return null;
        }));
    }

    private Repository _getObjectRepository(long groupId, String portletId, ServiceContext serviceContext) {
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, portletId);
        if (repository != null) {
            return repository;
        }
        try {
            return this._portletFileRepository.addPortletRepository(groupId, portletId, serviceContext);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private Long _getObjectRepositoryFolderId(long companyId, long groupId, String portletId, ServiceContext serviceContext, long userId) {
        Repository repository = this._getObjectRepository(groupId, portletId, serviceContext);
        if (repository == null) {
            return null;
        }
        DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(repository.getGroupId(), repository.getDlFolderId(), String.valueOf(userId));
        if (dlFolder != null) {
            return dlFolder.getFolderId();
        }
        try {
            dlFolder = this._dlFolderLocalService.addFolder(this._userLocalService.getDefaultUserId(companyId), repository.getGroupId(), repository.getRepositoryId(), false, repository.getDlFolderId(), String.valueOf(userId), null, false, serviceContext);
            return dlFolder.getFolderId();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private GroupByStep _getOneToManyObjectEntriesGroupByStep(long groupId, long objectRelationshipId, long primaryKey, boolean related, FromStep fromStep) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(objectRelationship.getObjectFieldId2());
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(primaryKeyColumn)).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(primaryKeyColumn)).where(ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)ObjectEntryTable.INSTANCE.companyId.eq((Object)objectRelationship.getCompanyId())).and((Expression)ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectRelationship.getObjectDefinitionId2())).and(() -> {
            Column column = null;
            column = Objects.equals(objectField.getDBTableName(), dynamicObjectDefinitionTable.getName()) ? dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName()) : extensionDynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
            return column.eq((Object)(related ? primaryKey : 0L));
        }).and(() -> {
            if (objectRelationship.getObjectDefinitionId1() == objectRelationship.getObjectDefinitionId2()) {
                return primaryKeyColumn.neq((Object)primaryKey);
            }
            return null;
        }).and(() -> {
            if (PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            return this._inlineSQLHelper.getPermissionWherePredicate(objectDefinition2.getClassName(), primaryKeyColumn, new long[0]);
        }));
    }

    private Predicate _getPermissionWherePredicate(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long groupId) throws PortalException {
        ObjectDefinition objectDefinition = dynamicObjectDefinitionTable.getObjectDefinition();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !this._inlineSQLHelper.isEnabled(objectDefinition.getCompanyId(), groupId)) {
            return null;
        }
        Predicate individualScopePredicate = this._inlineSQLHelper.getPermissionWherePredicate(objectDefinition.getClassName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[]{groupId});
        if (individualScopePredicate == null) {
            return null;
        }
        if (!objectDefinition.isAccountEntryRestricted()) {
            return individualScopePredicate;
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        Table table = this._objectFieldLocalService.getTable(objectDefinition.getObjectDefinitionId(), objectField.getName());
        Column column = table.getColumn(objectField.getDBColumnName());
        Table tempOrganizationTable = DSLQueryFactoryUtil.select((Expression[])new Expression[]{AccountEntryOrganizationRelTable.INSTANCE.accountEntryId, OrganizationTable.INSTANCE.treePath}).from((Table)OrganizationTable.INSTANCE).innerJoinON((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.organizationId.eq((Expression)OrganizationTable.INSTANCE.organizationId)).as("tempOrganizationTable", Arrays.asList(AccountEntryOrganizationRelTable.INSTANCE.accountEntryId, OrganizationTable.INSTANCE.treePath));
        GroupByStep dslQuery = DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{RoleTable.INSTANCE.roleId}).from((Table)UserGroupRoleTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.groupId.eq((Expression)UserGroupRoleTable.INSTANCE.groupId)).innerJoinON((Table)RoleTable.INSTANCE, RoleTable.INSTANCE.roleId.eq((Expression)UserGroupRoleTable.INSTANCE.roleId)).where(UserGroupRoleTable.INSTANCE.userId.eq((Object)permissionChecker.getUserId()).and((Expression)UserGroupRoleTable.INSTANCE.companyId.eq((Object)permissionChecker.getCompanyId())).and((Expression)GroupTable.INSTANCE.classPK.eq((Expression)column).or((Expression)GroupTable.INSTANCE.classPK.in((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{OrganizationTable.INSTANCE.organizationId}).from((Table)OrganizationTable.INSTANCE).innerJoinON(tempOrganizationTable, tempOrganizationTable.getColumn("treePath", String.class).like(DSLFunctionFactoryUtil.concat((Expression[])new Expression[]{new Scalar((Object)"%"), OrganizationTable.INSTANCE.treePath, new Scalar((Object)"%")}))).where(tempOrganizationTable.getColumn("accountEntryId", Long.class).eq((Expression)column)))).withParentheses()));
        return individualScopePredicate.or((Expression)column.in(this._getAccountEntriesDSLQuery(objectDefinition.getCompanyId(), permissionChecker.getUserId())).and((Expression)new DefaultPredicate((Expression)new QueryExpression((DSLQuery)DSLQueryFactoryUtil.count().from((Table)ResourcePermissionTable.INSTANCE).where(ResourcePermissionTable.INSTANCE.companyId.eq((Object)permissionChecker.getCompanyId()).and((Expression)ResourcePermissionTable.INSTANCE.name.eq((Object)objectDefinition.getClassName())).and((Expression)ResourcePermissionTable.INSTANCE.scope.eq((Object)3)).and((Expression)ResourcePermissionTable.INSTANCE.primKey.eq((Object)"0")).and((Expression)ResourcePermissionTable.INSTANCE.roleId.in((DSLQuery)dslQuery)).and((Expression)ResourcePermissionTable.INSTANCE.viewActionId.eq((Object)true)))), Operand.GREATER_THAN, (Expression)new Scalar((Object)0))).withParentheses()).withParentheses();
    }

    private Object _getResult(Object entryValues, Expression<?> selectExpression) {
        Object result = null;
        try {
            ScalarDSLQueryAlias scalarDSLQueryAlias;
            if (selectExpression instanceof Column) {
                Column column = (Column)selectExpression;
                result = this._getValue(entryValues, column.getSQLType());
            } else if (selectExpression instanceof ScalarDSLQueryAlias && (result = this._getValue(entryValues, (scalarDSLQueryAlias = (ScalarDSLQueryAlias)selectExpression).getSQLType())) == null) {
                result = "0";
            }
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        return result;
    }

    private Expression<?>[] _getSelectExpressions(DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        ArrayList<Object> selectExpressions = new ArrayList<Object>();
        for (Column column : dynamicObjectDefinitionTable.getColumns()) {
            selectExpressions.add(column);
        }
        for (ObjectField objectField : dynamicObjectDefinitionTable.getObjectFields()) {
            if (!objectField.compareBusinessType("Aggregation")) continue;
            HashMap<String, Object> objectFieldSettingsValues = new HashMap<String, Object>();
            List objectFieldSettings = this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId());
            for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
                if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectFieldSetting.getName(), (String)"filters")) {
                    objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getObjectFilters());
                    continue;
                }
                objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getValue());
            }
            ObjectDefinition objectDefinition = dynamicObjectDefinitionTable.getObjectDefinition();
            ObjectRelationship objectRelationship = ObjectRelationshipUtil.getObjectRelationship((List)this._objectRelationshipPersistence.findByODI1_N(objectDefinition.getObjectDefinitionId(), GetterUtil.getString(objectFieldSettingsValues.get("objectRelationshipName"))));
            ObjectDefinition relatedObjectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            DynamicObjectDefinitionTable relatedDynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(relatedObjectDefinition, this._objectFieldLocalService.getObjectFields(relatedObjectDefinition.getObjectDefinitionId()), relatedObjectDefinition.getDBTableName());
            DynamicObjectDefinitionTable relatedExtensionDynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(relatedObjectDefinition, this._objectFieldLocalService.getObjectFields(relatedObjectDefinition.getObjectDefinitionId()), relatedObjectDefinition.getExtensionDBTableName());
            JoinStep joinStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{this._getFunctionExpression(objectFieldSettingsValues, relatedObjectDefinition, relatedDynamicObjectDefinitionTable)}).from((Table)relatedDynamicObjectDefinitionTable).innerJoinON((Table)relatedExtensionDynamicObjectDefinitionTable, relatedExtensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
            if (!relatedObjectDefinition.isSystem()) {
                joinStep = joinStep.innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
            }
            Predicate predicate = null;
            if (Objects.equals(objectRelationship.getType(), "oneToMany")) {
                ObjectField relatedField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
                Column relatedObjectDefinitionColumn = this._objectFieldLocalService.getColumn(relatedObjectDefinition.getObjectDefinitionId(), relatedField.getName());
                predicate = relatedObjectDefinitionColumn.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn());
            } else if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
                DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(objectDefinition.getPKObjectFieldDBColumnName(), relatedObjectDefinition.getPKObjectFieldDBColumnName(), objectRelationship.getDBTableName());
                Column<DynamicObjectRelationshipMappingTable, Long> primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
                joinStep = joinStep.innerJoinON((Table)dynamicObjectRelationshipMappingTable, primaryKeyColumn2.eq(relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
                Column<DynamicObjectRelationshipMappingTable, Long> primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
                predicate = primaryKeyColumn1.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn());
            }
            List oDataFilterStrings = TransformUtil.transform((Collection)((List)objectFieldSettingsValues.get("filters")), objectFilter -> {
                if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectFilter.getFilterType(), (String)"currentUser")) {
                    objectFilter.setJSON(JSONUtil.put((String)"currentUserId", (Object)PrincipalThreadLocal.getUserId()).toString());
                }
                ObjectFilterParser objectFilterParser = this._objectFilterParserServiceRegistry.getObjectFilterParser(objectFilter.getFilterType());
                return objectFilterParser.parse((ObjectFilter)objectFilter);
            });
            for (String oDataFilterString : oDataFilterStrings) {
                predicate = predicate.and((Expression)this._filterPredicateFactory.create(oDataFilterString, relatedObjectDefinition.getObjectDefinitionId()));
            }
            selectExpressions.add(DSLQueryFactoryUtil.scalarSubDSLQuery((DSLQuery)joinStep.where(predicate), DynamicObjectDefinitionTable.getJavaClass(objectField.getDBType()), (String)objectField.getName(), (int)DynamicObjectDefinitionTable.getSQLType(objectField.getDBType())));
        }
        return selectExpressions.toArray(new Expression[0]);
    }

    private Long _getStorageDLFolderId(long companyId, long groupId, ServiceContext serviceContext, String storageDLFolderPath) {
        long storageDLFolderId = 0L;
        for (String name : StringUtil.split((String)storageDLFolderPath, (char)'/')) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(groupId, storageDLFolderId, name);
            if (dlFolder != null) {
                storageDLFolderId = dlFolder.getFolderId();
                continue;
            }
            try {
                Folder folder = this._dlAppLocalService.addFolder(this._userLocalService.getDefaultUserId(companyId), groupId, storageDLFolderId, name, null, serviceContext);
                storageDLFolderId = folder.getFolderId();
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                return null;
            }
        }
        return storageDLFolderId;
    }

    private Object _getValue(Object object, int sqlType) throws SQLException {
        if (sqlType == -5) {
            return GetterUtil.getLong((Object)object);
        }
        if (sqlType == 16) {
            return GetterUtil.getBoolean((Object)object);
        }
        if (sqlType == 2005) {
            return GetterUtil.getString((Object)object);
        }
        if (sqlType == 91 || sqlType == 93) {
            if (object == null) {
                return null;
            }
            Date date = (Date)object;
            return new Timestamp(date.getTime());
        }
        if (sqlType == 3) {
            return object;
        }
        if (sqlType == 8) {
            return GetterUtil.getDouble((Object)object);
        }
        if (sqlType == 4) {
            return GetterUtil.getInteger((Object)object);
        }
        if (sqlType == 12) {
            return object;
        }
        throw new IllegalArgumentException("Unable to get value with SQL type " + sqlType);
    }

    private String _getValue(String valueString) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            return GetterUtil.getString((String)jsonArray.getString(0));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return GetterUtil.getString((String)valueString);
        }
    }

    private Map<String, Serializable> _getValues(Object[] objects, Expression<?>[] selectExpressions) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (int i = 0; i < selectExpressions.length; ++i) {
            Expression<?> selectExpression = selectExpressions[i];
            String columnName = null;
            Class javaTypeClass = null;
            if (selectExpression instanceof Column) {
                Column column = (Column)selectExpressions[i];
                columnName = column.getName();
                javaTypeClass = column.getJavaType();
            } else if (selectExpression instanceof ScalarDSLQueryAlias) {
                ScalarDSLQueryAlias scalarDSLQueryAlias = (ScalarDSLQueryAlias)selectExpressions[i];
                columnName = scalarDSLQueryAlias.getName();
                javaTypeClass = scalarDSLQueryAlias.getJavaType();
            }
            if (columnName.endsWith("_")) {
                columnName = columnName.substring(0, columnName.length() - 1);
            }
            this._putValue(javaTypeClass, columnName, objects[i], values);
        }
        return values;
    }

    private void _insertIntoTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId, Map<String, Serializable> values) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("insert into ");
        sb.append(dynamicObjectDefinitionTable.getName());
        sb.append(" (");
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        sb.append(primaryKeyColumn.getName());
        int count = 1;
        List<ObjectField> objectFields = dynamicObjectDefinitionTable.getObjectFields();
        for (ObjectField objectField : objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || !values.containsKey(objectField.getName())) {
                if (objectField.isRequired()) {
                    throw new ObjectEntryValuesException.Required(objectField.getName());
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No value was provided for object field \"" + objectField.getName() + "\""));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToOne")) {
                this._validateOneToOneInsert(objectField.getDBColumnName(), GetterUtil.getLong((Object)values.get(objectField.getName())), dynamicObjectDefinitionTable);
            }
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            ++count;
        }
        sb.append(") values (?");
        for (int i = 1; i < count; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int index = 1;
            this._setColumn(preparedStatement, index++, -5, objectEntryId);
            for (ObjectField objectField : objectFields) {
                if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || !values.containsKey(objectField.getName())) continue;
                this._setColumn(dynamicObjectDefinitionTable, index++, objectField, preparedStatement, values);
            }
            preparedStatement.executeUpdate();
            FinderCacheUtil.clearDSLQueryCache((String)dynamicObjectDefinitionTable.getTableName());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private List<Object[]> _list(DSLQuery dslQuery, Expression<?>[] selectExpressions) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        List entriesValues = (List)this.objectEntryPersistence.dslQuery(dslQuery);
        for (Object entryValues : entriesValues) {
            Object[] result = new Object[selectExpressions.length];
            if (selectExpressions.length == 1) {
                result[0] = this._getResult(entryValues, selectExpressions[0]);
            } else {
                for (int i = 0; i < selectExpressions.length; ++i) {
                    result[i] = this._getResult(((Object[])entryValues)[i], selectExpressions[i]);
                }
            }
            results.add(result);
        }
        return results;
    }

    private Map<String, Serializable> _putFormulaObjectFieldValues(long objectDefinitionId, Map<String, Serializable> values) throws PortalException {
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            if (!objectField.compareBusinessType("Formula")) continue;
            ObjectFieldFormulaEvaluatorUtil.evaluate((DDMExpressionFactory)this._ddmExpressionFactory, (List)this._objectFieldLocalService.getObjectFields(objectDefinitionId), (ObjectFieldSettingLocalService)this._objectFieldSettingLocalService, (UserLocalService)this._userLocalService, values);
        }
        return values;
    }

    private void _putValue(Class<?> javaTypeClass, String name, Object object, Map<String, Serializable> values) {
        if (javaTypeClass == BigDecimal.class) {
            values.put(name, (BigDecimal)object);
        } else if (javaTypeClass == Blob.class) {
            byte[] bytes = null;
            if (object != null) {
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    try {
                        bytes = blob.getBytes(1L, (int)blob.length());
                    }
                    catch (SQLException sqlException) {
                        throw new SystemException((Throwable)sqlException);
                    }
                } else if (object instanceof byte[]) {
                    bytes = (byte[])object;
                } else {
                    Class<?> objectClass = object.getClass();
                    throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to put \"", name, "\" with unknown object class ", objectClass.getName()}));
                }
            }
            values.put(name, (Serializable)bytes);
        } else if (javaTypeClass == Boolean.class) {
            if (object == null) {
                object = Boolean.FALSE;
            }
            if (object instanceof Byte) {
                Byte byteObject = (Byte)object;
                object = byteObject.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            values.put(name, (Boolean)object);
        } else if (javaTypeClass == Clob.class) {
            if (object == null) {
                values.put(name, (Serializable)((Object)""));
            } else {
                DB db = DBManagerUtil.getDB();
                if (db.getDBType() == DBType.POSTGRESQL) {
                    values.put(name, (Serializable)((Object)((String)object)));
                } else {
                    Clob clob = (Clob)object;
                    try {
                        InputStream inputStream = clob.getAsciiStream();
                        values.put(name, (Serializable)((Object)GetterUtil.getString((String)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8))));
                    }
                    catch (IOException | SQLException exception) {
                        throw new SystemException((Throwable)exception);
                    }
                }
            }
        } else if (javaTypeClass == Date.class) {
            values.put(name, (Date)object);
        } else if (javaTypeClass == Double.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0.0;
            } else if (!(number instanceof Double)) {
                number = number.doubleValue();
            }
            values.put(name, number);
        } else if (javaTypeClass == Integer.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0;
            } else if (!(number instanceof Integer)) {
                number = number.intValue();
            }
            values.put(name, number);
        } else if (javaTypeClass == Long.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0L;
            } else if (!(number instanceof Long)) {
                number = number.longValue();
            }
            values.put(name, number);
        } else if (javaTypeClass == String.class) {
            values.put(name, (Serializable)((Object)((String)object)));
        } else {
            throw new IllegalArgumentException("Unable to put value with class " + javaTypeClass.getName());
        }
    }

    private void _reindex(ObjectEntry objectEntry) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition.getClassName());
        indexer.reindex(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
    }

    private void _setColumn(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, int index, ObjectField objectField, PreparedStatement preparedStatement, Map<String, Serializable> values) throws Exception {
        Column column = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
        Serializable value = values.get(objectField.getName());
        if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getBusinessType(), (String)"MultiselectPicklist")) {
            String valueString = String.valueOf(value);
            if (com.liferay.portal.kernel.util.StringUtil.endsWith((String)valueString, (String)"]") && com.liferay.portal.kernel.util.StringUtil.startsWith((String)valueString, (String)"[")) {
                valueString = valueString.substring(1, valueString.length() - 1);
            }
            this._setColumn(preparedStatement, index, column.getSQLType(), valueString);
        } else {
            this._setColumn(preparedStatement, index, column.getSQLType(), value);
        }
    }

    private void _setColumn(PreparedStatement preparedStatement, int index, int sqlType, Object value) throws Exception {
        if (sqlType == -5) {
            preparedStatement.setLong(index, GetterUtil.getLong((Object)value));
        } else if (sqlType == 2004) {
            if (PostgreSQLJDBCUtil.isPGStatement((Statement)preparedStatement)) {
                PostgreSQLJDBCUtil.setLargeObject((PreparedStatement)preparedStatement, (int)index, (byte[])((byte[])value));
            } else {
                preparedStatement.setBytes(index, (byte[])value);
            }
        } else if (sqlType == 16) {
            preparedStatement.setBoolean(index, GetterUtil.getBoolean((Object)value));
        } else if (sqlType == 2005) {
            DB db = DBManagerUtil.getDB();
            if (db.getDBType() == DBType.POSTGRESQL) {
                preparedStatement.setString(index, String.valueOf(value));
            } else {
                preparedStatement.setClob(index, new StringReader(String.valueOf(value)));
            }
        } else if (sqlType == 91) {
            String valueString = GetterUtil.getString((Object)value);
            if (value instanceof Date) {
                Date date = (Date)value;
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            } else if (valueString.isEmpty()) {
                preparedStatement.setTimestamp(index, null);
            } else {
                Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)LocaleUtil.getSiteDefault());
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            }
        } else if (sqlType == 3) {
            preparedStatement.setBigDecimal(index, new BigDecimal(String.valueOf(value)));
        } else if (sqlType == 8) {
            preparedStatement.setDouble(index, GetterUtil.getDouble((Object)value));
        } else if (sqlType == 4) {
            preparedStatement.setInt(index, GetterUtil.getInteger((Object)value));
        } else if (sqlType == 12) {
            preparedStatement.setString(index, String.valueOf(value));
        } else {
            throw new IllegalArgumentException("Unable to set column with SQL type " + sqlType);
        }
    }

    private void _setExternalReferenceCode(ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            if (!com.liferay.portal.kernel.util.StringUtil.equals((String)entry.getKey(), (String)"externalReferenceCode")) continue;
            String externalReferenceCode = String.valueOf(entry.getValue());
            if (Validator.isNull((String)externalReferenceCode)) {
                externalReferenceCode = String.valueOf(objectEntry.getObjectEntryId());
            }
            this._validateExternalReferenceCode(externalReferenceCode, objectEntry.getCompanyId(), objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId());
            objectEntry.setExternalReferenceCode(externalReferenceCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startWorkflowInstance(long userId, ObjectEntry objectEntry, ServiceContext serviceContext) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            _skipModelListeners.set(true);
            WorkflowThreadLocal.setEnabled((boolean)true);
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)objectEntry.getCompanyId(), (long)objectEntry.getNonzeroGroupId(), (long)userId, (String)objectDefinition.getClassName(), (long)objectEntry.getObjectEntryId(), (Object)objectEntry, (ServiceContext)serviceContext);
        }
        finally {
            _skipModelListeners.set(false);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    private void _updateTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId, Map<String, Serializable> values) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("update ");
        sb.append(dynamicObjectDefinitionTable.getName());
        sb.append(" set ");
        int count = 0;
        List<ObjectField> objectFields = dynamicObjectDefinitionTable.getObjectFields();
        for (ObjectField objectField : objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula")) continue;
            if (!values.containsKey(objectField.getName())) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No value was provided for object field \"" + objectField.getName() + "\""));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToOne")) {
                this._validateOneToOneUpdate(objectField.getDBColumnName(), GetterUtil.getLong((Object)values.get(objectField.getName())), dynamicObjectDefinitionTable, objectEntryId);
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(objectField.getDBColumnName());
            sb.append(" = ?");
            ++count;
        }
        if (count == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No values were provided for object entry " + objectEntryId));
            }
            return;
        }
        sb.append(" where ");
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        sb.append(primaryKeyColumn.getName());
        sb.append(" = ?");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int index = 1;
            for (ObjectField objectField : objectFields) {
                if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || !values.containsKey(objectField.getName())) continue;
                this._setColumn(dynamicObjectDefinitionTable, index++, objectField, preparedStatement, values);
            }
            this._setColumn(preparedStatement, index++, -5, objectEntryId);
            preparedStatement.executeUpdate();
            FinderCacheUtil.clearDSLQueryCache((String)dynamicObjectDefinitionTable.getTableName());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long companyId, long objectDefinitionId, long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectEntry != null && objectEntry.getObjectEntryId() != objectEntryId) {
            throw new ObjectEntryValuesException.MustNotBeDuplicate(externalReferenceCode);
        }
    }

    private void _validateFileExtension(String fileExtension, long objectFieldId, String objectFieldName) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, "acceptedFileExtensions");
        String acceptedFileExtensions = objectFieldSetting.getValue();
        if (!ArrayUtil.contains((String[])acceptedFileExtensions.split("\\s*,\\s*"), (String)fileExtension, (boolean)true)) {
            throw new ObjectEntryValuesException.InvalidFileExtension(fileExtension, objectFieldName);
        }
    }

    private void _validateFileSize(boolean defaultUser, long fileSize, long objectFieldId, String objectFieldName) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, "maximumFileSize");
        long maximumFileSize = GetterUtil.getLong((String)objectFieldSetting.getValue());
        if (defaultUser && (long)this._objectConfiguration.maximumFileSizeForGuestUsers() < maximumFileSize) {
            maximumFileSize = this._objectConfiguration.maximumFileSizeForGuestUsers();
        }
        if (maximumFileSize > 0L && fileSize > maximumFileSize * 1024L * 1024L) {
            throw new ObjectEntryValuesException.ExceedsMaxFileSize(maximumFileSize, objectFieldName);
        }
    }

    private void _validateGroupId(long groupId, String scope) throws PortalException {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        if (!objectScopeProvider.isValidGroupId(groupId)) {
            throw new ObjectDefinitionScopeException(StringBundler.concat((Object[])new Object[]{"Group ID ", groupId, " is not valid for scope \"", scope, "\""}));
        }
    }

    private void _validateObjectStateTransition(Map.Entry<String, Serializable> entry, long listTypeDefinitionId, ObjectEntry objectEntry, long objectFieldId) throws PortalException {
        Map values = objectEntry.getValues();
        ListTypeEntry originalListTypeEntry = this._listTypeEntryLocalService.getListTypeEntry(listTypeDefinitionId, this._getValue(String.valueOf(values.get(entry.getKey()))));
        ObjectStateFlow objectStateFlow = this._objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(objectFieldId);
        ObjectState sourceObjectState = this._objectStateLocalService.getObjectStateFlowObjectState(originalListTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
        ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.getListTypeEntry(listTypeDefinitionId, String.valueOf(entry.getValue()));
        boolean invalidObjectStateTransition = true;
        for (ObjectState nextObjectState : this._objectStateLocalService.getNextObjectStates(sourceObjectState.getObjectStateId())) {
            if (nextObjectState.getListTypeEntryId() != listTypeEntry.getListTypeEntryId()) continue;
            invalidObjectStateTransition = false;
        }
        if (invalidObjectStateTransition) {
            ObjectState targetObjectState = this._objectStateLocalService.getObjectStateFlowObjectState(listTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
            if (sourceObjectState.getObjectStateId() != targetObjectState.getObjectStateId()) {
                throw new ObjectEntryValuesException.InvalidObjectStateTransition(sourceObjectState, targetObjectState);
            }
        }
    }

    private void _validateOneToOneInsert(String dbColumnName, long dbColumnValue, DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        if (dbColumnValue == 0L) {
            return;
        }
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dbColumnName, " = ", dbColumnValue}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        if (count > 0) {
            throw new ObjectEntryValuesException.OneToOneConstraintViolation(dbColumnName, dbColumnValue, dynamicObjectDefinitionTable.getTableName());
        }
    }

    private void _validateOneToOneUpdate(String dbColumnName, long dbColumnValue, DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId) throws PortalException {
        if (dbColumnValue == 0L) {
            return;
        }
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dynamicObjectDefinitionTable.getPrimaryKeyColumnName(), " != ", objectEntryId, " and ", dbColumnName, " = ", dbColumnValue}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        if (count > 0) {
            throw new ObjectEntryValuesException.OneToOneConstraintViolation(dbColumnName, dbColumnValue, dynamicObjectDefinitionTable.getTableName());
        }
    }

    private void _validateTextMaxLength(int defaultMaxLength, String objectEntryValue, long objectFieldId, String objectFieldName) throws PortalException {
        int maxLength = defaultMaxLength;
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, "maxLength");
        if (objectFieldSetting != null) {
            maxLength = GetterUtil.getInteger((String)objectFieldSetting.getValue());
        }
        if (objectEntryValue.length() > maxLength) {
            throw new ObjectEntryValuesException.ExceedsTextMaxLength(maxLength, objectFieldName);
        }
    }

    private void _validateValues(boolean defaultUser, long objectDefinitionId, ObjectEntry objectEntry, String portletId, ServiceContext serviceContext, long userId, Map<String, Serializable> values) throws PortalException {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            this._validateValues(defaultUser, entry, objectDefinitionId, objectEntry, portletId, serviceContext, userId, values);
        }
    }

    private void _validateValues(boolean defaultUser, Map.Entry<String, Serializable> entry, long objectDefinitionId, ObjectEntry objectEntry, String portletId, ServiceContext serviceContext, long userId, Map<String, Serializable> values) throws PortalException {
        String entryValueString;
        Serializable entryValue;
        ObjectField objectField = null;
        try {
            objectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, entry.getKey());
        }
        catch (NoSuchObjectFieldException noSuchObjectFieldException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchObjectFieldException);
            }
            return;
        }
        if (Validator.isNull((Object)values.get(objectField.getName())) && objectField.isRequired()) {
            throw new ObjectEntryValuesException.Required(objectField.getName());
        }
        if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getBusinessType(), (String)"Attachment")) {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(GetterUtil.getLong((Object)entry.getValue()));
            if (dlFileEntry != null) {
                this._validateFileExtension(dlFileEntry.getExtension(), objectField.getObjectFieldId(), objectField.getName());
                this._validateFileSize(defaultUser, dlFileEntry.getSize(), objectField.getObjectFieldId(), objectField.getName());
                this._addFileEntry(dlFileEntry, entry, objectField.getObjectFieldSettings(), portletId, serviceContext, userId);
                return;
            }
            if (objectField.isRequired()) {
                throw new ObjectEntryValuesException.Required(objectField.getName());
            }
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getBusinessType(), (String)"LongText")) {
            this._validateTextMaxLength(65000, GetterUtil.getString((Object)entry.getValue()), objectField.getObjectFieldId(), objectField.getName());
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getDBType(), (String)"Integer")) {
            int value;
            entryValue = entry.getValue();
            entryValueString = entryValue.toString();
            if (!entryValueString.isEmpty() && !com.liferay.portal.kernel.util.StringUtil.equals((String)String.valueOf(value = GetterUtil.getInteger((Object)entryValue)), (String)entryValueString)) {
                throw new ObjectEntryValuesException.ExceedsIntegerSize(9, objectField.getName());
            }
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getDBType(), (String)"Long")) {
            entryValue = entry.getValue();
            entryValueString = entryValue.toString();
            if (!entryValueString.isEmpty()) {
                long value = GetterUtil.getLong((Object)entryValue);
                if (!com.liferay.portal.kernel.util.StringUtil.equals((String)String.valueOf(value), (String)entryValue.toString())) {
                    throw new ObjectEntryValuesException.ExceedsLongSize(16, objectField.getName());
                }
                if (value > 0x1FFFFFFFFFFFFFL) {
                    throw new ObjectEntryValuesException.ExceedsLongMaxSize(0x1FFFFFFFFFFFFFL, objectField.getName());
                }
                if (value < -9007199254740991L) {
                    throw new ObjectEntryValuesException.ExceedsLongMinSize(-9007199254740991L, objectField.getName());
                }
            }
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getDBType(), (String)"String")) {
            this._validateTextMaxLength(280, GetterUtil.getString((Object)entry.getValue()), objectField.getObjectFieldId(), objectField.getName());
        }
        if (objectField.getListTypeDefinitionId() != 0L) {
            List listTypeEntries = this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId());
            Stream stream = listTypeEntries.stream();
            String value = this._getValue(String.valueOf(values.get(entry.getKey())));
            if (!(value.isEmpty() && !objectField.isRequired() || stream.anyMatch(listTypeEntry -> Objects.equals(listTypeEntry.getKey(), value)))) {
                throw new ObjectEntryValuesException.ListTypeEntry(entry.getKey());
            }
            if (objectEntry != null && objectField.isState()) {
                this._validateObjectStateTransition(entry, objectField.getListTypeDefinitionId(), objectEntry, objectField.getObjectFieldId());
            }
        }
    }
}

