/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.exception.ObjectActionConditionExpressionException;
import com.liferay.object.exception.ObjectActionErrorMessageException;
import com.liferay.object.exception.ObjectActionLabelException;
import com.liferay.object.exception.ObjectActionNameException;
import com.liferay.object.exception.ObjectActionParametersException;
import com.liferay.object.exception.ObjectActionTriggerKeyException;
import com.liferay.object.internal.action.trigger.util.ObjectActionTriggerUtil;
import com.liferay.object.internal.definition.util.ObjectDefinitionPermissionUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectActionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectAction"}, service={AopService.class})
public class ObjectActionLocalServiceImpl
extends ObjectActionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionLocalServiceImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectScriptingValidator _objectScriptingValidator;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction addObjectAction(long userId, long objectDefinitionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        this._validateErrorMessage(errorMessageMap, objectActionTriggerKey);
        this._validateLabel(labelMap);
        this._validateName(0L, objectDefinitionId, name);
        this._validateObjectActionExecutorKey(objectActionExecutorKey);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateObjectActionTriggerKey(conditionExpression, objectActionTriggerKey, objectDefinition);
        User user = this._userLocalService.getUser(userId);
        this._validateParametersUnicodeProperties(user.getCompanyId(), conditionExpression, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        ObjectAction objectAction = this.objectActionPersistence.create(this.counterLocalService.increment());
        objectAction.setCompanyId(user.getCompanyId());
        objectAction.setUserId(user.getUserId());
        objectAction.setUserName(user.getFullName());
        objectAction.setObjectDefinitionId(objectDefinitionId);
        objectAction.setActive(active);
        objectAction.setConditionExpression(conditionExpression);
        objectAction.setDescription(description);
        objectAction.setErrorMessageMap(errorMessageMap, LocaleUtil.getSiteDefault());
        objectAction.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectAction.setName(name);
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        objectAction.setStatus(0);
        objectAction = (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
        if (objectDefinition.isApproved() && Objects.equals(objectAction.getObjectActionTriggerKey(), "standalone")) {
            try {
                ObjectDefinitionPermissionUtil.populateResourceActions(this.objectActionLocalService, objectDefinition, this._portletLocalService, this._resourceActions);
            }
            catch (Exception exception) {
                ReflectionUtil.throwException((Throwable)exception);
            }
        }
        return objectAction;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectAction deleteObjectAction(long objectActionId) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        return this.deleteObjectAction(objectAction);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectAction deleteObjectAction(ObjectAction objectAction) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey((objectAction = (ObjectAction)this.objectActionPersistence.remove((BaseModel)objectAction)).getObjectDefinitionId());
        if (objectDefinition.isApproved() && Objects.equals(objectAction.getObjectActionTriggerKey(), "standalone")) {
            this._resourceActions.removeModelResource(objectDefinition.getClassName(), objectAction.getName());
        }
        return objectAction;
    }

    public void deleteObjectActions(long objectDefinitionId) throws PortalException {
        for (ObjectAction objectAction : this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            this.objectActionLocalService.deleteObjectAction(objectAction);
        }
    }

    public ObjectAction getObjectAction(long objectDefinitionId, String name, String objectActionTriggerKey) throws PortalException {
        return this.objectActionPersistence.findByODI_A_N_OATK(objectDefinitionId, true, name, objectActionTriggerKey);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId) {
        return this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId, String objectActionTriggerKey) {
        return this.objectActionPersistence.findByO_A_OATK(objectDefinitionId, true, objectActionTriggerKey);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateObjectAction(long objectActionId, boolean active, String conditionExpression, String description, Map<Locale, String> errorMessageMap, Map<Locale, String> labelMap, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        this._validateErrorMessage(errorMessageMap, objectActionTriggerKey);
        this._validateLabel(labelMap);
        this._validateObjectActionExecutorKey(objectActionExecutorKey);
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        this._validateParametersUnicodeProperties(objectAction.getCompanyId(), conditionExpression, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        objectAction.setActive(active);
        objectAction.setConditionExpression(conditionExpression);
        objectAction.setDescription(description);
        objectAction.setErrorMessageMap(errorMessageMap, LocaleUtil.getSiteDefault());
        objectAction.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        objectAction.setStatus(0);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectAction.getObjectDefinitionId());
        if (objectDefinition.isApproved()) {
            return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
        }
        this._validateName(objectActionId, objectDefinition.getObjectDefinitionId(), name);
        this._validateObjectActionTriggerKey(conditionExpression, objectActionTriggerKey, objectDefinition);
        objectAction.setName(name);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateStatus(long objectActionId, int status) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        objectAction.setStatus(status);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    private void _validateErrorMessage(Map<Locale, String> errorMessageMap, String objectActionTriggerKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (Objects.equals(objectActionTriggerKey, "standalone") && (errorMessageMap == null || Validator.isNull((String)errorMessageMap.get(locale)))) {
            throw new ObjectActionErrorMessageException("Error message is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectActionLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long objectActionId, long objectDefinitionId, String name) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectActionNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectActionNameException.MustOnlyContainLettersAndDigits();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectActionNameException.MustBeLessThan41Characters();
        }
        ObjectAction objectAction = this.objectActionPersistence.fetchByODI_N(objectDefinitionId, name);
        if (objectAction != null && objectAction.getObjectActionId() != objectActionId) {
            throw new ObjectActionNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateObjectActionExecutorKey(String objectActionExecutorKey) throws PortalException {
        if (!this._objectActionExecutorRegistry.hasObjectActionExecutor(objectActionExecutorKey) && _log.isDebugEnabled()) {
            _log.debug((Object)("No object action executor is registered with " + objectActionExecutorKey));
        }
    }

    private void _validateObjectActionTriggerKey(String conditionExpression, String objectActionTriggerKey, ObjectDefinition objectDefinition) throws PortalException {
        if (Objects.equals(objectActionTriggerKey, "standalone")) {
            if (objectDefinition.isSystem()) {
                throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action trigger key ", "standalone", " cannot be used by a system object definition"}));
            }
            if (Validator.isNotNull((String)conditionExpression)) {
                throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action trigger key ", "standalone", " cannot have a condition expression"}));
            }
        }
        if (!ListUtil.exists(ObjectActionTriggerUtil.getDefaultObjectActionTriggers(), objectActionTrigger -> StringUtil.equals((String)objectActionTrigger.getKey(), (String)objectActionTriggerKey))) {
            if (this._messageBus.getDestination(objectActionTriggerKey) == null) {
                throw new ObjectActionTriggerKeyException();
            }
            if (StringUtil.equals((String)objectActionTriggerKey, (String)"liferay/commerce_order_status") || StringUtil.equals((String)objectActionTriggerKey, (String)"liferay/commerce_payment_status") || StringUtil.equals((String)objectActionTriggerKey, (String)"liferay/commerce_shipment_status")) {
                return;
            }
            if (Validator.isNotNull((String)conditionExpression)) {
                throw new ObjectActionConditionExpressionException();
            }
        }
    }

    private void _validateParametersUnicodeProperties(long companyId, String conditionExpression, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        HashMap<String, Object> errorMessageKeys = new HashMap<String, Object>();
        if (Validator.isNotNull((String)conditionExpression)) {
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)conditionExpression).build());
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                errorMessageKeys.put("conditionExpression", "syntax-error");
            }
        }
        if (Objects.equals(objectActionExecutorKey, "update-object-entry") && Objects.equals(objectActionTriggerKey, "onAfterDelete")) {
            throw new ObjectActionTriggerKeyException(StringBundler.concat((String[])new String[]{"The object action executor key ", "update-object-entry", " cannot be associated with the object action trigger key", "onAfterDelete"}));
        }
        if (Objects.equals(objectActionExecutorKey, "add-object-entry") || Objects.equals(objectActionExecutorKey, "update-object-entry")) {
            ObjectDefinition existingObjectDefinition;
            long objectDefinitionId = GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"objectDefinitionId")));
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
            String objectDefinitionExternalReferenceCode = GetterUtil.getString((String)parametersUnicodeProperties.remove((Object)"objectDefinitionExternalReferenceCode"));
            if (Validator.isNotNull((String)objectDefinitionExternalReferenceCode) && (existingObjectDefinition = this._objectDefinitionPersistence.fetchByERC_C(objectDefinitionExternalReferenceCode, companyId)) != null) {
                objectDefinition = existingObjectDefinition;
                parametersUnicodeProperties.put("objectDefinitionId", String.valueOf(objectDefinition.getObjectDefinitionId()));
            }
            if (objectDefinition == null || !objectDefinition.isActive() || !objectDefinition.isApproved() || objectDefinition.isSystem()) {
                errorMessageKeys.put("objectDefinitionId", "invalid");
            } else {
                this._validatePredefinedValues(errorMessageKeys, objectActionExecutorKey, objectDefinitionId, this._jsonFactory.createJSONArray((String)parametersUnicodeProperties.get((Object)"predefinedValues")));
            }
        } else if (Objects.equals(objectActionExecutorKey, "groovy")) {
            String script = (String)parametersUnicodeProperties.get((Object)"script");
            if (Validator.isNotNull((String)script)) {
                try {
                    this._objectScriptingValidator.validate("groovy", script);
                }
                catch (ObjectScriptingException objectScriptingException) {
                    errorMessageKeys.put("script", objectScriptingException.getMessageKey());
                }
            }
        } else if (Objects.equals(objectActionExecutorKey, "webhook") && Validator.isNull((String)((String)parametersUnicodeProperties.get((Object)"url")))) {
            errorMessageKeys.put("url", "required");
        }
        if (MapUtil.isNotEmpty(errorMessageKeys)) {
            throw new ObjectActionParametersException(errorMessageKeys);
        }
    }

    private void _validatePredefinedValues(Map<String, Object> errorMessageKeys, String objectActionExecutorKey, long objectDefinitionId, JSONArray predefinedValuesJSONArray) {
        HashMap<String, String> predefinedValuesErrorMessageKeys = new HashMap<String, String>();
        HashMap<String, String> predefinedValuesMap = new HashMap<String, String>();
        for (int i = 0; i < predefinedValuesJSONArray.length(); ++i) {
            JSONObject predefinedValueJSONObject = predefinedValuesJSONArray.getJSONObject(i);
            String name = predefinedValueJSONObject.getString("name");
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId, name);
            if (objectField == null) {
                predefinedValuesErrorMessageKeys.put(name, "invalid");
                continue;
            }
            String value = predefinedValueJSONObject.getString("value");
            predefinedValuesMap.put(name, value);
            if (Objects.equals(objectActionExecutorKey, "update-object-entry") && objectField.isRequired() && Validator.isNull((String)value)) {
                predefinedValuesErrorMessageKeys.put(objectField.getName(), "required");
            }
            if (Validator.isNull((String)value) || predefinedValueJSONObject.getBoolean("inputAsValue")) continue;
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)value).build());
                continue;
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                predefinedValuesErrorMessageKeys.put(name, "syntax-error");
            }
        }
        if (Objects.equals(objectActionExecutorKey, "update-object-entry")) {
            return;
        }
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinitionId)) {
            if (!objectField.isRequired() || Validator.isNotNull((String)((String)predefinedValuesMap.get(objectField.getName()))) || StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) continue;
            predefinedValuesErrorMessageKeys.put(objectField.getName(), "required");
        }
        if (MapUtil.isNotEmpty(predefinedValuesErrorMessageKeys)) {
            errorMessageKeys.put("predefinedValues", predefinedValuesErrorMessageKeys);
        }
    }
}

