/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import java.util.Objects;

public class ObjectEntryMtoMObjectRelatedModelsProviderImpl
implements ObjectRelatedModelsProvider<ObjectEntry> {
    private final String _className;
    private final ObjectEntryService _objectEntryService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectEntryMtoMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryService objectEntryService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._objectEntryService = objectEntryService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._className = objectDefinition.getClassName();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        List<ObjectEntry> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, -1, -1);
        if (relatedModels.isEmpty()) {
            return;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(objectRelationship.getDeletionType(), "prevent") && !objectRelationship.isReverse()) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey);
        if (Objects.equals(objectRelationship.getDeletionType(), "cascade") && !objectRelationship.isReverse()) {
            for (ObjectEntry objectEntry : relatedModels) {
                this._objectEntryService.deleteObjectEntry(objectEntry.getObjectEntryId());
            }
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey1, primaryKey2);
    }

    public String getClassName() {
        return this._className;
    }

    public String getObjectRelationshipType() {
        return "manyToMany";
    }

    public List<ObjectEntry> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntries(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, true, objectRelationship.isReverse(), start, end);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntriesCount(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, true, objectRelationship.isReverse());
    }

    public List<ObjectEntry> getUnrelatedModels(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntries(groupId, objectRelationship.getObjectRelationshipId(), objectEntryId, false, objectRelationship.isReverse(), -1, -1);
    }
}

