/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.notification.term.contributor;

import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.definition.notification.term.util.ObjectDefinitionNotificationTermUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;

public class ObjectDefinitionNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final ObjectDefinition _objectDefinition;
    private volatile Map<String, Long> _objectFieldIds;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final UserLocalService _userLocalService;

    public ObjectDefinitionNotificationTermEvaluator(ObjectDefinition objectDefinition, ObjectFieldLocalService objectFieldLocalService, UserLocalService userLocalService) {
        this._objectDefinition = objectDefinition;
        this._objectFieldLocalService = objectFieldLocalService;
        this._userLocalService = userLocalService;
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map)) {
            return termName;
        }
        Map termValues = (Map)object;
        if (termName.contains("_CREATOR")) {
            if (context.equals((Object)NotificationTermEvaluator.Context.RECIPIENT)) {
                return String.valueOf(termValues.get("creator"));
            }
            User user = this._userLocalService.getUser(GetterUtil.getLong(termValues.get("creator")));
            return user.getFullName(true, true);
        }
        Map<String, Long> objectFieldIds = this._getObjectFieldIds();
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldIds.get(termName).longValue());
        if (objectField == null) {
            return termName;
        }
        Object termValue = termValues.get(objectField.getName());
        if (Validator.isNotNull(termValue)) {
            return String.valueOf(termValue);
        }
        return String.valueOf(termValues.get(objectField.getDBColumnName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> _getObjectFieldIds() {
        HashMap objectFieldIds = this._objectFieldIds;
        if (objectFieldIds != null) {
            return objectFieldIds;
        }
        ObjectDefinitionNotificationTermEvaluator objectDefinitionNotificationTermEvaluator = this;
        synchronized (objectDefinitionNotificationTermEvaluator) {
            if (this._objectFieldIds != null) {
                return this._objectFieldIds;
            }
            objectFieldIds = HashMapBuilder.put((Object)"[%OBJECT_ENTRY_CREATOR%]", (Object)0L).build();
            for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId())) {
                objectFieldIds.put(ObjectDefinitionNotificationTermUtil.getObjectFieldTermName((String)this._objectDefinition.getShortName(), (String)objectField.getName()), objectField.getObjectFieldId());
            }
            this._objectFieldIds = objectFieldIds;
        }
        return objectFieldIds;
    }
}

