/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.info.collection.provider;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.depot.util.SiteConnectedGroupGroupProviderUtil;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.ConfigurableInfoCollectionProvider;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.filter.InfoFilter;
import com.liferay.info.filter.KeywordsInfoFilter;
import com.liferay.info.form.InfoForm;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.localized.SingleValueInfoLocalizedValue;
import com.liferay.info.localized.bundle.FunctionInfoLocalizedValue;
import com.liferay.info.localized.bundle.ResourceBundleInfoLocalizedValue;
import com.liferay.info.pagination.InfoPage;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portlet.asset.util.comparator.AssetTagNameComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectEntrySingleFormVariationInfoCollectionProvider
implements ConfigurableInfoCollectionProvider<ObjectEntry>,
FilteredInfoCollectionProvider<ObjectEntry>,
SingleFormVariationInfoCollectionProvider<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntrySingleFormVariationInfoCollectionProvider.class);
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetTagLocalService _assetTagLocalService;
    private final AssetVocabularyLocalService _assetVocabularyLocalService;
    private final GroupLocalService _groupLocalService;
    private final ListTypeEntryLocalService _listTypeEntryLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectLayoutLocalService _objectLayoutLocalService;
    private final ObjectScopeProviderRegistry _objectScopeProviderRegistry;

    public ObjectEntrySingleFormVariationInfoCollectionProvider(AssetCategoryLocalService assetCategoryLocalService, AssetTagLocalService assetTagLocalService, AssetVocabularyLocalService assetVocabularyLocalService, GroupLocalService groupLocalService, ListTypeEntryLocalService listTypeEntryLocalService, ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectFieldLocalService objectFieldLocalService, ObjectLayoutLocalService objectLayoutLocalService, ObjectScopeProviderRegistry objectScopeProviderRegistry) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetTagLocalService = assetTagLocalService;
        this._assetVocabularyLocalService = assetVocabularyLocalService;
        this._groupLocalService = groupLocalService;
        this._listTypeEntryLocalService = listTypeEntryLocalService;
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectEntryManagerRegistry = objectEntryManagerRegistry;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectLayoutLocalService = objectLayoutLocalService;
        this._objectScopeProviderRegistry = objectScopeProviderRegistry;
    }

    public InfoPage<ObjectEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            if (this._objectDefinition.isDefaultStorageType()) {
                return this._getCollectionInfoPageByDefaultStorageType(collectionQuery);
            }
            return this._getCollectionInfoPageByObjectEntryManager(collectionQuery);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get object entries for object definition " + this._objectDefinition.getObjectDefinitionId(), exception);
        }
    }

    public String getCollectionItemClassName() {
        return this._objectDefinition.getClassName();
    }

    public InfoForm getConfigurationInfoForm() {
        return InfoForm.builder().infoFieldSetEntries(this._getInfoFieldSetEntries()).infoFieldSetEntry(InfoFieldSet.builder().infoFieldSetEntry(unsafeConsumer -> {
            InfoField<?> infoField = this._getInfoField();
            if (infoField != null) {
                unsafeConsumer.accept(infoField);
            }
        }).build()).infoFieldSetEntry(InfoFieldSet.builder().infoFieldSetEntry(unsafeConsumer -> {
            for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId())) {
                if (!Objects.equals(objectField.getDBType(), "Boolean") && (!Objects.equals(objectField.getDBType(), "String") || objectField.getListTypeDefinitionId() == 0L) || !objectField.isIndexed()) continue;
                unsafeConsumer.accept((Object)InfoField.builder().infoFieldType((InfoFieldType)SelectInfoFieldType.INSTANCE).namespace("").name(objectField.getName()).attribute(SelectInfoFieldType.OPTIONS, this._getOptions(objectField)).labelInfoLocalizedValue(InfoLocalizedValue.builder().values(objectField.getLabelMap()).build()).localizable(true).build());
            }
        }).build()).build();
    }

    public String getFormVariationKey() {
        return String.valueOf(this._objectDefinition.getObjectDefinitionId());
    }

    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{super.getKey(), "_", this._objectDefinition.getCompanyId(), "_", this._objectDefinition.getName()});
    }

    public String getLabel(Locale locale) {
        return this._objectDefinition.getPluralLabel(locale);
    }

    public List<InfoFilter> getSupportedInfoFilters() {
        return Arrays.asList(new KeywordsInfoFilter());
    }

    public boolean isAvailable() {
        return this._objectDefinition.getCompanyId() == CompanyThreadLocal.getCompanyId().longValue();
    }

    private SearchContext _buildSearchContext(CollectionQuery collectionQuery) throws Exception {
        SearchContext searchContext = new SearchContext();
        ArrayList assetCategoryIds = new ArrayList();
        Map configuration = collectionQuery.getConfiguration();
        if (configuration == null) {
            configuration = Collections.emptyMap();
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (AssetVocabulary assetVocabulary : this._getAssetVocabularies(serviceContext)) {
            String[] assetCategoryIdsArray = (String[])configuration.get(String.valueOf(assetVocabulary.getVocabularyId()));
            if (assetCategoryIdsArray == null || StringUtil.equals((String)assetCategoryIdsArray[0], (String)"null")) continue;
            Collections.addAll(assetCategoryIds, assetCategoryIdsArray);
        }
        searchContext.setAssetCategoryIds(ListUtil.toLongArray(assetCategoryIds, Long::parseLong));
        Object[] assetTagNames = (String[])configuration.get("assetTagNames");
        if (ArrayUtil.isNotEmpty((Object[])assetTagNames) && Validator.isNotNull((String)assetTagNames[0])) {
            searchContext.setAssetTagNames((String[])assetTagNames);
        }
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(this._objectDefinition.getObjectDefinitionId()));
        searchContext.setBooleanClauses(this._getBooleanClauses(collectionQuery));
        searchContext.setCompanyId(serviceContext.getCompanyId());
        com.liferay.info.pagination.Pagination pagination = collectionQuery.getPagination();
        searchContext.setEnd(pagination.getEnd());
        searchContext.setGroupIds(new long[]{this._getGroupId()});
        KeywordsInfoFilter keywordsInfoFilter = (KeywordsInfoFilter)collectionQuery.getInfoFilter(KeywordsInfoFilter.class);
        if (keywordsInfoFilter != null) {
            searchContext.setKeywords(keywordsInfoFilter.getKeywords());
        }
        searchContext.setStart(pagination.getStart());
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<AssetVocabulary> _getAssetVocabularies(ServiceContext serviceContext) {
        try {
            return ListUtil.filter((List)this._assetVocabularyLocalService.getGroupVocabularies(SiteConnectedGroupGroupProviderUtil.getCurrentAndAncestorSiteAndDepotGroupIds((long)serviceContext.getScopeGroupId())), assetVocabulary -> assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(PortalUtil.getClassNameId((String)this._objectDefinition.getClassName()), -1L));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    private BooleanClause[] _getBooleanClauses(CollectionQuery collectionQuery) throws Exception {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        List objectFields = this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId());
        Map configuration = collectionQuery.getConfiguration();
        if (configuration == null) {
            configuration = Collections.emptyMap();
        }
        for (Map.Entry entry : configuration.entrySet()) {
            ObjectField objectField;
            String[] values = (String[])entry.getValue();
            if (values == null || values.length == 0 || values[0].isEmpty() || (objectField = this._getObjectField((String)entry.getKey(), objectFields)) == null) continue;
            BooleanQueryImpl nestedBooleanQuery = new BooleanQueryImpl();
            nestedBooleanQuery.add((Query)new TermQueryImpl(this._getFieldName(objectField), ((String[])entry.getValue())[0]), BooleanClauseOccur.MUST);
            nestedBooleanQuery.add((Query)new TermQueryImpl("nestedFieldArray.fieldName", (String)entry.getKey()), BooleanClauseOccur.MUST);
            booleanQuery.add((Query)new NestedQuery("nestedFieldArray", (Query)nestedBooleanQuery), BooleanClauseOccur.MUST);
        }
        return new BooleanClause[]{BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.MUST.getName())};
    }

    private InfoPage<ObjectEntry> _getCollectionInfoPageByDefaultStorageType(CollectionQuery collectionQuery) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._objectDefinition.getClassName());
        Hits hits = indexer.search(this._buildSearchContext(collectionQuery));
        return InfoPage.of((List)TransformUtil.transformToList((Object[])hits.getDocs(), document -> {
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._objectEntryLocalService.fetchObjectEntry(classPK);
        }), (com.liferay.info.pagination.Pagination)collectionQuery.getPagination(), (int)hits.getLength());
    }

    private InfoPage<ObjectEntry> _getCollectionInfoPageByObjectEntryManager(CollectionQuery collectionQuery) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        Group scopeGroup = themeDisplay.getScopeGroup();
        com.liferay.info.pagination.Pagination pagination = collectionQuery.getPagination();
        Page objectEntriesPage = objectEntryManager.getObjectEntries(themeDisplay.getCompanyId(), this._objectDefinition, scopeGroup.getGroupKey(), null, (DTOConverterContext)new DefaultDTOConverterContext(false, null, null, null, null, themeDisplay.getLocale(), null, themeDisplay.getUser()), (Filter)null, Pagination.of((int)1, (int)pagination.getEnd()), null, null);
        ArrayList objectEntries = new ArrayList(objectEntriesPage.getItems());
        return InfoPage.of((List)TransformUtil.transform(objectEntries, objectEntry -> this._toObjectEntry(this._objectDefinition.getObjectDefinitionId(), (com.liferay.object.rest.dto.v1_0.ObjectEntry)objectEntry)), (com.liferay.info.pagination.Pagination)collectionQuery.getPagination(), (int)objectEntries.size());
    }

    private String _getFieldName(ObjectField objectField) {
        if (Objects.equals(objectField.getDBType(), "Boolean")) {
            return "nestedFieldArray.value_boolean";
        }
        if (Objects.equals(objectField.getDBType(), "String")) {
            return "nestedFieldArray.value_keyword_lowercase";
        }
        return "";
    }

    private long _getGroupId() throws Exception {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        if (!objectScopeProvider.isGroupAware()) {
            return 0L;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        return objectScopeProvider.getGroupId(serviceContext.getRequest());
    }

    private InfoField<?> _getInfoField() {
        if (!StringUtil.equals((String)this._objectDefinition.getStorageType(), (String)"default") || !this._hasCategorizationObjectLayoutBox()) {
            return null;
        }
        long groupId = 0L;
        if (StringUtil.equals((String)this._objectDefinition.getScope(), (String)"company")) {
            try {
                Group group = this._groupLocalService.getCompanyGroup(this._objectDefinition.getCompanyId());
                groupId = group.getGroupId();
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        } else {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            groupId = serviceContext.getScopeGroupId();
        }
        ArrayList assetTags = new ArrayList(this._assetTagLocalService.getGroupTags(groupId));
        assetTags.sort(new AssetTagNameComparator(true));
        ArrayList<SelectInfoFieldType.Option> options = new ArrayList<SelectInfoFieldType.Option>();
        for (AssetTag assetTag : assetTags) {
            options.add(new SelectInfoFieldType.Option((InfoLocalizedValue)new SingleValueInfoLocalizedValue((Object)assetTag.getName()), assetTag.getName()));
        }
        InfoField.FinalStep finalStep = InfoField.builder().infoFieldType((InfoFieldType)SelectInfoFieldType.INSTANCE).namespace("").name("assetTagNames").attribute(SelectInfoFieldType.MULTIPLE, (Object)true).attribute(SelectInfoFieldType.OPTIONS, options).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"tag")).localizable(true);
        return finalStep.build();
    }

    private List<InfoFieldSetEntry> _getInfoFieldSetEntries() {
        if (!StringUtil.equals((String)this._objectDefinition.getStorageType(), (String)"default") || !this._hasCategorizationObjectLayoutBox()) {
            return Collections.emptyList();
        }
        ArrayList<InfoFieldSetEntry> fieldSetEntries = new ArrayList<InfoFieldSetEntry>();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (AssetVocabulary assetVocabulary : this._getAssetVocabularies(serviceContext)) {
            ArrayList<SelectInfoFieldType.Option> options = new ArrayList<SelectInfoFieldType.Option>();
            for (AssetCategory assetCategory : this._assetCategoryLocalService.getVocabularyCategories(assetVocabulary.getVocabularyId(), -1, -1, null)) {
                options.add(new SelectInfoFieldType.Option((InfoLocalizedValue)new SingleValueInfoLocalizedValue((Object)assetCategory.getName()), String.valueOf(assetCategory.getCategoryId())));
            }
            if (options.isEmpty()) continue;
            fieldSetEntries.add((InfoFieldSetEntry)InfoField.builder().infoFieldType((InfoFieldType)SelectInfoFieldType.INSTANCE).namespace("").name(String.valueOf(assetVocabulary.getVocabularyId())).attribute(SelectInfoFieldType.MULTIPLE, (Object)true).attribute(SelectInfoFieldType.OPTIONS, options).labelInfoLocalizedValue(InfoLocalizedValue.singleValue((String)assetVocabulary.getTitle(serviceContext.getLocale()))).localizable(true).build());
        }
        return fieldSetEntries;
    }

    private ObjectField _getObjectField(String name, List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(name, objectField.getName())) continue;
            return objectField;
        }
        return null;
    }

    private List<SelectInfoFieldType.Option> _getOptions(ObjectField objectField) {
        ArrayList<SelectInfoFieldType.Option> options = new ArrayList<SelectInfoFieldType.Option>();
        options.add(new SelectInfoFieldType.Option((InfoLocalizedValue)new ResourceBundleInfoLocalizedValue(this.getClass(), "choose-an-option"), ""));
        if (Objects.equals(objectField.getDBType(), "Boolean")) {
            options.add(new SelectInfoFieldType.Option((InfoLocalizedValue)new ResourceBundleInfoLocalizedValue(this.getClass(), "true"), "true"));
            options.add(new SelectInfoFieldType.Option((InfoLocalizedValue)new ResourceBundleInfoLocalizedValue(this.getClass(), "false"), "false"));
        } else if (objectField.getListTypeDefinitionId() != 0L) {
            options.addAll(TransformUtil.transform((Collection)this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId(), -1, -1), listTypeEntry -> new SelectInfoFieldType.Option((InfoLocalizedValue)new FunctionInfoLocalizedValue(arg_0 -> ((ListTypeEntry)listTypeEntry).getName(arg_0)), listTypeEntry.getKey())));
        }
        return options;
    }

    private boolean _hasCategorizationObjectLayoutBox() {
        ObjectLayout objectLayout = null;
        try {
            objectLayout = this._objectLayoutLocalService.getDefaultObjectLayout(this._objectDefinition.getObjectDefinitionId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
        for (ObjectLayoutTab objectLayoutTab : objectLayout.getObjectLayoutTabs()) {
            if (!ListUtil.exists((List)objectLayoutTab.getObjectLayoutBoxes(), objectLayoutBox -> StringUtil.equals((String)objectLayoutBox.getType(), (String)"categorization"))) continue;
            return true;
        }
        return false;
    }

    private ObjectEntry _toObjectEntry(long objectDefinitionId, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryLocalService.createObjectEntry(0L);
        serviceBuilderObjectEntry.setExternalReferenceCode(objectEntry.getExternalReferenceCode());
        serviceBuilderObjectEntry.setObjectDefinitionId(objectDefinitionId);
        return serviceBuilderObjectEntry;
    }
}

