/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.NoSuchObjectRelationshipException;
import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFieldSettingModel;
import com.liferay.object.model.ObjectFilter;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Aggregation"}, service={AggregationObjectFieldBusinessType.class, ObjectFieldBusinessType.class})
public class AggregationObjectFieldBusinessType
implements ObjectFieldBusinessType {
    private static final String[] _FUNCTION = new String[]{"AVERAGE", "COUNT", "MAX", "MIN", "SUM"};
    private static final String[] _NUMERIC_BUSINESS_TYPES = new String[]{"Decimal", "Integer", "LongInteger", "PrecisionDecimal"};
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"filters", "function", "objectFieldName", "objectRelationshipName"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "summarize-data-values");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "aggregation");
    }

    public String getName() {
        return "Aggregation";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap properties = HashMapBuilder.put((Object)"readOnly", (Object)true).build();
        ListUtil.isNotEmptyForEach((List)this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()), objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getRequiredObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"function", "objectFieldName", "objectRelationshipName"});
    }

    public void validateObjectFieldSettings(long objectDefinitionId, String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        Stream stream = objectFieldSettings.stream();
        Map<String, Object> objectFieldSettingsValuesMap = stream.collect(Collectors.toMap(ObjectFieldSettingModel::getName, objectFieldSetting -> {
            if (Objects.equals(objectFieldSetting.getName(), "filters")) {
                return objectFieldSetting.getObjectFilters();
            }
            return objectFieldSetting.getValue();
        }));
        String function = GetterUtil.getString((Object)objectFieldSettingsValuesMap.get("function"));
        Set<String> requiredObjectFieldSettingsNames = this.getRequiredObjectFieldSettingsNames();
        if (!ArrayUtil.contains((Object[])_FUNCTION, (Object)function)) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "function", function);
        }
        if (Objects.equals(function, "COUNT")) {
            requiredObjectFieldSettingsNames.remove("objectFieldName");
        }
        HashSet<String> missingRequiredObjectFieldSettingsNames = new HashSet<String>();
        for (String requiredObjectFieldSettingName : requiredObjectFieldSettingsNames) {
            if (!Validator.isNull((Object)objectFieldSettingsValuesMap.get(requiredObjectFieldSettingName))) continue;
            missingRequiredObjectFieldSettingsNames.add(requiredObjectFieldSettingName);
        }
        if (!missingRequiredObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingValueException.MissingRequiredValues(objectFieldName, missingRequiredObjectFieldSettingsNames);
        }
        HashSet<String> notAllowedObjectFieldSettingsNames = new HashSet<String>(objectFieldSettingsValuesMap.keySet());
        notAllowedObjectFieldSettingsNames.removeAll(this.getAllowedObjectFieldSettingsNames());
        notAllowedObjectFieldSettingsNames.removeAll(requiredObjectFieldSettingsNames);
        if (!notAllowedObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, notAllowedObjectFieldSettingsNames);
        }
        try {
            ObjectField objectField;
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectDefinitionId, GetterUtil.getString((Object)objectFieldSettingsValuesMap.get("objectRelationshipName")));
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectRelationship.getObjectDefinitionId2());
            if (!Objects.equals(function, "COUNT") && !ArrayUtil.contains((Object[])_NUMERIC_BUSINESS_TYPES, (Object)(objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getObjectDefinitionId(), GetterUtil.getString((Object)objectFieldSettingsValuesMap.get("objectFieldName")))).getBusinessType())) {
                throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "objectFieldName", GetterUtil.getString((Object)objectFieldSettingsValuesMap.get("objectFieldName")));
            }
            this._validateObjectFilters(objectDefinition, objectFieldName, (List)objectFieldSettingsValuesMap.get("filters"));
        }
        catch (NoSuchObjectFieldException noSuchObjectFieldException) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "objectFieldName", GetterUtil.getString((Object)objectFieldSettingsValuesMap.get("objectFieldName")), (Throwable)noSuchObjectFieldException);
        }
        catch (NoSuchObjectRelationshipException noSuchObjectRelationshipException) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "objectRelationshipName", GetterUtil.getString((Object)objectFieldSettingsValuesMap.get("objectRelationshipName")), (Throwable)noSuchObjectRelationshipException);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private void _validateObjectFilters(ObjectDefinition objectDefinition, String objectFieldName, List<ObjectFilter> objectFilters) throws PortalException {
        if (ListUtil.isEmpty(objectFilters)) {
            return;
        }
        for (ObjectFilter objectFilter : objectFilters) {
            HashSet<String> missingObjectFilterValues = new HashSet<String>();
            this._validateObjectFilterValue(missingObjectFilterValues, "filterBy", objectFilter.getFilterBy());
            this._validateObjectFilterValue(missingObjectFilterValues, "filterType", objectFilter.getFilterType());
            this._validateObjectFilterValue(missingObjectFilterValues, "json", objectFilter.getJSON());
            if (!missingObjectFilterValues.isEmpty()) {
                throw new ObjectFieldSettingValueException.MissingRequiredValues(objectFieldName, missingObjectFilterValues);
            }
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), GetterUtil.getString((String)objectFilter.getFilterBy()));
            if (objectField != null && !objectField.compareBusinessType("Aggregation") && !objectField.compareBusinessType("Formula")) continue;
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "filterBy", GetterUtil.getString((String)objectFilter.getFilterBy()));
        }
    }

    private void _validateObjectFilterValue(Set<String> missingObjectFilterValues, String objectFilterName, String objectFilterValue) {
        if (Validator.isNull((String)objectFilterValue)) {
            missingObjectFilterValues.add(objectFilterName);
        }
    }
}

