/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.engine;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.internal.action.util.ObjectActionThreadLocal;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.internal.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionEngine.class})
public class ObjectActionEngineImpl
implements ObjectActionEngine {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionEngineImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void executeObjectAction(String objectActionName, String objectActionTriggerKey, long objectDefinitionId, JSONObject payloadJSONObject, long userId) throws Exception {
        ObjectAction objectAction = this._objectActionLocalService.getObjectAction(objectDefinitionId, objectActionName, objectActionTriggerKey);
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        this._updatePayloadJSONObject(objectDefinition, payloadJSONObject, this._userLocalService.getUser(userId));
        this._executeObjectAction(objectAction, objectDefinition, payloadJSONObject, userId, ObjectEntryVariablesUtil.getActionVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionMetadataRegistry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeObjectActions(String className, long companyId, String objectActionTriggerKey, JSONObject payloadJSONObject, long userId) {
        if (companyId == 0L || userId == 0L) {
            return;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null || companyId != user.getCompanyId()) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(user.getCompanyId(), className);
        if (objectDefinition == null) {
            return;
        }
        String name = PrincipalThreadLocal.getName();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission(true);
            PrincipalThreadLocal.setName((long)userId);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionCheckerFactory.create(user));
            this._updatePayloadJSONObject(objectDefinition, payloadJSONObject, user);
            Map<String, Object> variables = ObjectEntryVariablesUtil.getActionVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionMetadataRegistry);
            for (ObjectAction objectAction : this._objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), objectActionTriggerKey)) {
                try {
                    this._executeObjectAction(objectAction, objectDefinition, payloadJSONObject, userId, variables);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission(false);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private boolean _evaluateConditionExpression(String conditionExpression, Map<String, Object> variables) throws Exception {
        if (Validator.isNull((String)conditionExpression)) {
            return true;
        }
        DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)conditionExpression).build());
        ddmExpression.setVariables(variables);
        return (Boolean)ddmExpression.evaluate();
    }

    private void _executeObjectAction(ObjectAction objectAction, ObjectDefinition objectDefinition, JSONObject payloadJSONObject, long userId, Map<String, Object> variables) throws Exception {
        Set<Long> objectActionIds = ObjectActionThreadLocal.getObjectActionIds();
        try {
            if (objectActionIds.contains(objectAction.getObjectActionId()) || !this._evaluateConditionExpression(objectAction.getConditionExpression(), variables)) {
                return;
            }
            objectActionIds.add(objectAction.getObjectActionId());
            ObjectActionExecutor objectActionExecutor = this._objectActionExecutorRegistry.getObjectActionExecutor(objectAction.getObjectActionExecutorKey());
            objectActionExecutor.execute(objectDefinition.getCompanyId(), objectAction.getParametersUnicodeProperties(), payloadJSONObject, userId);
            this._objectActionLocalService.updateStatus(objectAction.getObjectActionId(), 1);
        }
        catch (Exception exception) {
            this._objectActionLocalService.updateStatus(objectAction.getObjectActionId(), 2);
            throw exception;
        }
    }

    private void _updatePayloadJSONObject(ObjectDefinition objectDefinition, JSONObject payloadJSONObject, User user) {
        payloadJSONObject.put("companyId", objectDefinition.getCompanyId()).put("objectDefinitionId", objectDefinition.getObjectDefinitionId()).put("status", objectDefinition.getStatus()).put("userId", user.getUserId()).put("userName", user.getFullName());
    }
}

