/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.service.base.ObjectValidationRuleServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectValidationRule"}, service={AopService.class})
public class ObjectValidationRuleServiceImpl
extends ObjectValidationRuleServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;

    public ObjectValidationRule addObjectValidationRule(long objectDefinitionId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String script) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "UPDATE");
        return this.objectValidationRuleLocalService.addObjectValidationRule(this.getUserId(), objectDefinitionId, active, engine, errorLabelMap, nameMap, script);
    }

    public ObjectValidationRule deleteObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectValidationRule.getObjectDefinitionId(), "UPDATE");
        return this.objectValidationRuleLocalService.deleteObjectValidationRule(objectValidationRule);
    }

    public ObjectValidationRule getObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectValidationRule.getObjectDefinitionId(), "VIEW");
        return this.objectValidationRuleLocalService.getObjectValidationRule(objectValidationRuleId);
    }

    public ObjectValidationRule updateObjectValidationRule(long objectValidationRuleId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String script) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectValidationRule.getObjectDefinitionId(), "UPDATE");
        return this.objectValidationRuleLocalService.updateObjectValidationRule(objectValidationRuleId, active, engine, errorLabelMap, nameMap, script);
    }
}

