/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.model.ObjectStateTransition;
import com.liferay.object.model.ObjectStateTransitionModel;
import com.liferay.object.service.base.ObjectStateTransitionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectStateTransition"}, service={AopService.class})
public class ObjectStateTransitionLocalServiceImpl
extends ObjectStateTransitionLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public ObjectStateTransition addObjectStateTransition(long userId, long objectStateFlowId, long sourceObjectStateId, long targetObjectStateId) throws PortalException {
        ObjectStateTransition objectStateTransition = this.createObjectStateTransition(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectStateTransition.setCompanyId(user.getCompanyId());
        objectStateTransition.setUserId(user.getUserId());
        objectStateTransition.setUserName(user.getFullName());
        objectStateTransition.setObjectStateFlowId(objectStateFlowId);
        objectStateTransition.setSourceObjectStateId(sourceObjectStateId);
        objectStateTransition.setTargetObjectStateId(targetObjectStateId);
        return this.addObjectStateTransition(objectStateTransition);
    }

    public void deleteObjectStateFlowObjectStateTransitions(long objectStateFlowId) {
        this.objectStateTransitionPersistence.removeByObjectStateFlowId(objectStateFlowId);
    }

    public void deleteObjectStateObjectStateTransitions(long objectStateId) {
        this.objectStateTransitionPersistence.removeBySourceObjectStateId(objectStateId);
        this.objectStateTransitionPersistence.removeByTargetObjectStateId(objectStateId);
    }

    public List<ObjectStateTransition> getObjectStateFlowObjectStateTransitions(long objectStateFlowId) {
        return this.objectStateTransitionPersistence.findByObjectStateFlowId(objectStateFlowId);
    }

    public List<ObjectStateTransition> getObjectStateObjectStateTransitions(long objectStateId) {
        return this.objectStateTransitionPersistence.findBySourceObjectStateId(objectStateId);
    }

    public void updateObjectStateTransitions(ObjectStateFlow objectStateFlow) throws PortalException {
        if (objectStateFlow == null) {
            return;
        }
        for (ObjectState objectState : objectStateFlow.getObjectStates()) {
            this._updateObjectStateTransitions(objectState.getObjectStateId(), objectState.getObjectStateTransitions());
        }
    }

    private void _updateObjectStateTransitions(long objectStateId, List<ObjectStateTransition> objectStateTransitions) throws PortalException {
        List persistedObjectStateTransitions = this.objectStateTransitionPersistence.findBySourceObjectStateId(objectStateId);
        if (persistedObjectStateTransitions.isEmpty()) {
            User user = this._userLocalService.fetchUser(PrincipalThreadLocal.getUserId());
            for (ObjectStateTransition objectStateTransition : objectStateTransitions) {
                this.addObjectStateTransition(user.getUserId(), objectStateTransition.getObjectStateFlowId(), objectStateTransition.getSourceObjectStateId(), objectStateTransition.getTargetObjectStateId());
            }
            return;
        }
        if (objectStateTransitions.isEmpty()) {
            for (ObjectStateTransition objectStateTransition : persistedObjectStateTransitions) {
                this.objectStateTransitionPersistence.remove(objectStateTransition.getObjectStateTransitionId());
            }
            return;
        }
        List targetObjectStateIds = ListUtil.toList(objectStateTransitions, ObjectStateTransitionModel::getTargetObjectStateId);
        for (ObjectStateTransition objectStateTransition : persistedObjectStateTransitions) {
            if (targetObjectStateIds.contains(objectStateTransition.getTargetObjectStateId())) continue;
            this.objectStateTransitionPersistence.remove(objectStateTransition.getObjectStateTransitionId());
        }
        List persistedTargetObjectStateIds = ListUtil.toList((List)persistedObjectStateTransitions, ObjectStateTransitionModel::getTargetObjectStateId);
        for (ObjectStateTransition objectStateTransition : objectStateTransitions) {
            if (persistedTargetObjectStateIds.contains(objectStateTransition.getTargetObjectStateId())) continue;
            this.addObjectStateTransition(objectStateTransition);
        }
    }
}

