/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.entry.permission.util.ObjectEntryPermissionUtil;
import com.liferay.object.exception.ObjectEntryCountException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectEntryServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.configuration.ObjectConfiguration"}, property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectEntry"}, service={AopService.class})
public class ObjectEntryServiceImpl
extends ObjectEntryServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    private volatile ServiceTrackerMap<String, ModelResourcePermission<ObjectEntry>> _modelResourcePermissionsServiceTrackerMap;
    private volatile ObjectConfiguration _objectConfiguration;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    private volatile ServiceTrackerMap<String, PortletResourcePermission> _portletResourcePermissionsServiceTrackerMap;

    public ObjectEntry addObjectEntry(long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        this._checkPortletResourcePermission(groupId, objectDefinitionId, "ADD_OBJECT_ENTRY");
        this._validateSubmissionLimit(objectDefinitionId, this.getUser());
        return this.objectEntryLocalService.addObjectEntry(this.getUserId(), groupId, objectDefinitionId, values, serviceContext);
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, serviceContext.getCompanyId(), objectDefinitionId);
        if (objectEntry == null) {
            this._checkPortletResourcePermission(groupId, objectDefinitionId, "ADD_OBJECT_ENTRY");
        } else {
            this._checkModelResourcePermission(objectDefinitionId, objectEntry.getObjectEntryId(), "UPDATE");
        }
        return this.objectEntryLocalService.addOrUpdateObjectEntry(externalReferenceCode, this.getUserId(), groupId, objectDefinitionId, values, serviceContext);
    }

    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        this._checkPermissions(this.objectEntryLocalService.getObjectEntry(objectEntryId), "DELETE");
        return this.objectEntryLocalService.deleteObjectEntry(objectEntryId);
    }

    public ObjectEntry deleteObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, groupId);
        this._checkPermissions(objectEntry, "DELETE");
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    public ObjectEntry fetchObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.fetchObjectEntry(objectEntryId);
        if (objectEntry != null) {
            this._checkPermissions(objectEntry, "VIEW");
        }
        return objectEntry;
    }

    public List<ObjectEntry> getManyToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, int start, int end) throws PortalException {
        List objectEntries = this.objectEntryLocalService.getManyToManyObjectEntries(groupId, objectRelationshipId, primaryKey, related, reverse, start, end);
        for (ObjectEntry objectEntry : objectEntries) {
            this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        }
        return objectEntries;
    }

    public int getManyToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse) throws PortalException {
        return this.objectEntryLocalService.getManyToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, related, reverse);
    }

    public ObjectEntry getObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        this._checkPermissions(objectEntry, "VIEW");
        return objectEntry;
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, groupId);
        this._checkPermissions(objectEntry, "VIEW");
        return objectEntry;
    }

    public List<ObjectEntry> getOneToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, int start, int end) throws PortalException {
        List objectEntries = this.objectEntryLocalService.getOneToManyObjectEntries(groupId, objectRelationshipId, primaryKey, related, start, end);
        for (ObjectEntry objectEntry : objectEntries) {
            this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        }
        return objectEntries;
    }

    public int getOneToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related) throws PortalException {
        return this.objectEntryLocalService.getOneToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, related);
    }

    public boolean hasModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ModelResourcePermission modelResourcePermission = (ModelResourcePermission)this._modelResourcePermissionsServiceTrackerMap.getService((Object)objectDefinition.getClassName());
        return modelResourcePermission.contains(this.getPermissionChecker(), objectEntryId, actionId);
    }

    public boolean hasModelResourcePermission(ObjectEntry objectEntry, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        ModelResourcePermission modelResourcePermission = (ModelResourcePermission)this._modelResourcePermissionsServiceTrackerMap.getService((Object)objectDefinition.getClassName());
        return modelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)objectEntry, actionId);
    }

    public ObjectEntry updateObjectEntry(long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "UPDATE");
        return this.objectEntryLocalService.updateObjectEntry(this.getUserId(), objectEntryId, values, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._modelResourcePermissionsServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ModelResourcePermission.class, (String)"(&(com.liferay.object=true)(model.class.name=*))", (serviceReference, emitter) -> emitter.emit((Object)((String)serviceReference.getProperty("model.class.name"))));
        this._objectConfiguration = (ObjectConfiguration)ConfigurableUtil.createConfigurable(ObjectConfiguration.class, properties);
        this._portletResourcePermissionsServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortletResourcePermission.class, (String)"(&(com.liferay.object=true)(resource.name=*))", (serviceReference, emitter) -> emitter.emit((Object)((String)serviceReference.getProperty("resource.name"))));
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this._modelResourcePermissionsServiceTrackerMap.close();
        this._portletResourcePermissionsServiceTrackerMap.close();
    }

    private void _checkModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ModelResourcePermission modelResourcePermission = (ModelResourcePermission)this._modelResourcePermissionsServiceTrackerMap.getService((Object)objectDefinition.getClassName());
        modelResourcePermission.check(this.getPermissionChecker(), objectEntryId, actionId);
    }

    private void _checkPermissions(ObjectEntry objectEntry, String actionId) throws PortalException {
        this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), actionId);
        ObjectEntryPermissionUtil.checkAccountEntryPermission((AccountEntryLocalService)this._accountEntryLocalService, (String)actionId, (ObjectDefinition)this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId()), (ObjectEntry)objectEntry, (ObjectFieldLocalService)this._objectFieldLocalService, (long)this.getUserId());
    }

    private void _checkPortletResourcePermission(long groupId, long objectDefinitionId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        PortletResourcePermission portletResourcePermission = (PortletResourcePermission)this._portletResourcePermissionsServiceTrackerMap.getService((Object)objectDefinition.getResourceName());
        portletResourcePermission.check(this.getPermissionChecker(), groupId, actionId);
    }

    private void _validateSubmissionLimit(long objectDefinitionId, User user) throws PortalException {
        long maximumNumberOfGuestUserObjectEntriesPerObjectDefinition;
        if (!user.isDefaultUser()) {
            return;
        }
        int count = this.objectEntryPersistence.countByU_ODI(user.getUserId(), objectDefinitionId);
        if ((long)count >= (maximumNumberOfGuestUserObjectEntriesPerObjectDefinition = (long)this._objectConfiguration.maximumNumberOfGuestUserObjectEntriesPerObjectDefinition())) {
            throw new ObjectEntryCountException(StringBundler.concat((Object[])new Object[]{"Unable to exceed ", maximumNumberOfGuestUserObjectEntriesPerObjectDefinition, " guest object entries for object definition ", objectDefinitionId}));
        }
    }
}

