/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.validation.rule;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectValidationRuleEngine.class})
public class DDMObjectValidationRuleEngineImpl
implements ObjectValidationRuleEngine {
    private static final Log _log = LogFactoryUtil.getLog(DDMObjectValidationRuleEngineImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;

    public Map<String, Object> execute(Map<String, Object> inputObjects, String script) {
        HashMap results = HashMapBuilder.put((Object)"invalidFields", (Object)false).put((Object)"invalidScript", (Object)false).build();
        try {
            DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
            ddmExpression.setVariables(inputObjects);
            results.put("invalidFields", (Boolean)ddmExpression.evaluate() == false);
        }
        catch (DDMExpressionException ddmExpressionException) {
            _log.error((Throwable)ddmExpressionException);
            results.put("invalidScript", true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            results.put("invalidFields", true);
        }
        return results;
    }

    public String getName() {
        return "ddm";
    }
}

