/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.scope;

import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.scope.provider.key=site"}, service={ObjectScopeProvider.class})
public class SiteObjectScopeProviderImpl
implements ObjectScopeProvider {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public long getGroupId(HttpServletRequest httpServletRequest) throws PortalException {
        return this._portal.getScopeGroupId(httpServletRequest);
    }

    public String getKey() {
        return "site";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "site");
    }

    public String[] getRootPanelCategoryKeys() {
        return new String[]{"site_administration"};
    }

    public boolean isGroupAware() {
        return true;
    }

    public boolean isValidGroupId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        return group != null && group.isSite();
    }
}

