/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectEntry1toMObjectRelatedModelsProviderImpl
implements ObjectRelatedModelsProvider<ObjectEntry> {
    private final String _className;
    private final ObjectEntryService _objectEntryService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectEntry1toMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryService objectEntryService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._objectEntryService = objectEntryService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._className = objectDefinition.getClassName();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        List<ObjectEntry> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, -1, -1);
        if (relatedModels.isEmpty()) {
            return;
        }
        if (Objects.equals(objectRelationship.getDeletionType(), "cascade")) {
            for (ObjectEntry objectEntry : relatedModels) {
                this._objectEntryService.deleteObjectEntry(objectEntry.getObjectEntryId());
            }
        } else if (Objects.equals(objectRelationship.getDeletionType(), "disassociate")) {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            for (ObjectEntry objectEntry : relatedModels) {
                this._objectEntryService.updateObjectEntry(objectEntry.getObjectEntryId(), (Map)HashMapBuilder.put((Object)objectField.getName(), (Object)0).build(), new ServiceContext());
            }
        } else if (Objects.equals(objectRelationship.getDeletionType(), "prevent")) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        this._objectEntryService.updateObjectEntry(primaryKey2, (Map)HashMapBuilder.put(() -> {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            return objectField.getName();
        }, (Object)0).build(), new ServiceContext());
    }

    public String getClassName() {
        return this._className;
    }

    public String getObjectRelationshipType() {
        return "oneToMany";
    }

    public List<ObjectEntry> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        return this._objectEntryService.getOneToManyObjectEntries(groupId, objectRelationshipId, primaryKey, true, start, end);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        return this._objectEntryService.getOneToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, true);
    }

    public List<ObjectEntry> getUnrelatedModels(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId) throws PortalException {
        return this._objectEntryService.getOneToManyObjectEntries(groupId, objectRelationshipId, objectEntryId, false, -1, -1);
    }
}

