/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.petra.sql.dsl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.base.BaseTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DynamicObjectDefinitionTable
extends BaseTable<DynamicObjectDefinitionTable> {
    private static final Log _log = LogFactoryUtil.getLog(DynamicObjectDefinitionTable.class);
    private static final Map<String, String> _dataTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)"DECIMAL(30, 16)").put((Object)"Blob", (Object)"BLOB").put((Object)"Boolean", (Object)"BOOLEAN").put((Object)"Clob", (Object)"TEXT").put((Object)"Date", (Object)"DATE").put((Object)"Double", (Object)"DOUBLE").put((Object)"Integer", (Object)"INTEGER").put((Object)"Long", (Object)"LONG").put((Object)"String", (Object)"VARCHAR(280)").build();
    private static final Map<String, Class<?>> _javaClasses = HashMapBuilder.put((Object)"BigDecimal", BigDecimal.class).put((Object)"Blob", Blob.class).put((Object)"Boolean", Boolean.class).put((Object)"Clob", String.class).put((Object)"Date", Date.class).put((Object)"Double", Double.class).put((Object)"Integer", Integer.class).put((Object)"Long", Long.class).put((Object)"String", String.class).build();
    private static final Map<String, Integer> _sqlTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)3).put((Object)"Blob", (Object)2004).put((Object)"Boolean", (Object)16).put((Object)"Clob", (Object)2005).put((Object)"Date", (Object)91).put((Object)"Double", (Object)8).put((Object)"Integer", (Object)4).put((Object)"Long", (Object)-5).put((Object)"String", (Object)12).build();
    private final ObjectDefinition _objectDefinition;
    private final List<ObjectField> _objectFields;
    private final String _primaryKeyColumnName;
    private final String _tableName;

    public static String getAlterTableAddColumnSQL(String tableName, String columnName, String type) {
        String sql = StringBundler.concat((String[])new String[]{"alter table ", tableName, " add ", columnName, " ", DynamicObjectDefinitionTable._getDataType(type), DynamicObjectDefinitionTable._getSQLColumnNull(type)});
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        return sql;
    }

    public static Class<?> getJavaClass(String type) {
        Class<?> javaClass = _javaClasses.get(type);
        if (javaClass == null) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return javaClass;
    }

    public static Integer getSQLType(String type) {
        Integer sqlType = _sqlTypes.get(type);
        if (sqlType == null) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return sqlType;
    }

    public DynamicObjectDefinitionTable(ObjectDefinition objectDefinition, List<ObjectField> objectFields, String tableName) {
        super(tableName, () -> null);
        this._objectDefinition = objectDefinition;
        this._objectFields = objectFields;
        this._tableName = tableName;
        this._primaryKeyColumnName = objectDefinition.getPKObjectFieldDBColumnName();
        this.createColumn(this._primaryKeyColumnName, Long.class, -5, 2);
        for (ObjectField objectField : objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula")) continue;
            this.createColumn(objectField.getDBColumnName(), DynamicObjectDefinitionTable.getJavaClass(objectField.getDBType()), DynamicObjectDefinitionTable.getSQLType(objectField.getDBType()), 0);
        }
    }

    public String getCreateTableSQL() {
        StringBundler sb = new StringBundler();
        sb.append("create table ");
        sb.append(this._tableName);
        sb.append(" (");
        sb.append(this._primaryKeyColumnName);
        sb.append(" LONG not null primary key");
        for (ObjectField objectField : this._objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula")) continue;
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            sb.append(" ");
            sb.append(DynamicObjectDefinitionTable._getDataType(objectField.getDBType()));
            sb.append(DynamicObjectDefinitionTable._getSQLColumnNull(objectField.getDBType()));
        }
        sb.append(")");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        return sql;
    }

    public ObjectDefinition getObjectDefinition() {
        return this._objectDefinition;
    }

    public List<ObjectField> getObjectFields() {
        return this._objectFields;
    }

    public Column<DynamicObjectDefinitionTable, Long> getPrimaryKeyColumn() {
        return this.getColumn(this._primaryKeyColumnName);
    }

    public String getPrimaryKeyColumnName() {
        return this._primaryKeyColumnName;
    }

    protected <C> Column<DynamicObjectDefinitionTable, C> createColumn(String name, Class<C> javaClass, int sqlType, int flags) {
        return super.createColumn(name, javaClass, sqlType, flags);
    }

    private static String _getDataType(String type) {
        String dataType = _dataTypes.get(type);
        if (dataType == null) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return dataType;
    }

    private static String _getSQLColumnNull(String type) {
        if (type.equals("BigDecimal") || type.equals("Double") || type.equals("Integer") || type.equals("Long")) {
            return " default 0";
        }
        if (type.equals("Boolean")) {
            return " default FALSE";
        }
        if (type.equals("Date")) {
            return " null";
        }
        return "";
    }
}

