/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectStateTransition;
import com.liferay.object.model.ObjectStateTransitionModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectStateTransition service. Represents a row in the &quot;ObjectStateTransition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectStateTransitionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectStateTransitionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectStateTransitionImpl
 * @generated
 */
public class ObjectStateTransitionModelImpl
	extends BaseModelImpl<ObjectStateTransition>
	implements ObjectStateTransitionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object state transition model instance should use the <code>ObjectStateTransition</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectStateTransition";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectStateTransitionId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectStateFlowId", Types.BIGINT},
		{"sourceObjectStateId", Types.BIGINT},
		{"targetObjectStateId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectStateTransitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectStateFlowId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("sourceObjectStateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("targetObjectStateId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectStateTransition (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectStateTransitionId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectStateFlowId LONG,sourceObjectStateId LONG,targetObjectStateId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table ObjectStateTransition";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectStateTransition.objectStateTransitionId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectStateTransition.objectStateTransitionId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTSTATEFLOWID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SOURCEOBJECTSTATEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TARGETOBJECTSTATEID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTSTATETRANSITIONID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectStateTransitionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectStateTransitionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectStateTransitionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectStateTransitionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectStateTransition.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectStateTransition.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectStateTransition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectStateTransition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectStateTransition, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectStateTransition)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectStateTransition, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectStateTransition, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectStateTransition)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectStateTransition, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectStateTransition, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<ObjectStateTransition, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ObjectStateTransition, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ObjectStateTransition, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<ObjectStateTransition, Object>>();
		Map<String, BiConsumer<ObjectStateTransition, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<ObjectStateTransition, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ObjectStateTransition::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setMvccVersion);
		attributeGetterFunctions.put("uuid", ObjectStateTransition::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ObjectStateTransition, String>)
				ObjectStateTransition::setUuid);
		attributeGetterFunctions.put(
			"objectStateTransitionId",
			ObjectStateTransition::getObjectStateTransitionId);
		attributeSetterBiConsumers.put(
			"objectStateTransitionId",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setObjectStateTransitionId);
		attributeGetterFunctions.put(
			"companyId", ObjectStateTransition::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setCompanyId);
		attributeGetterFunctions.put(
			"userId", ObjectStateTransition::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setUserId);
		attributeGetterFunctions.put(
			"userName", ObjectStateTransition::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ObjectStateTransition, String>)
				ObjectStateTransition::setUserName);
		attributeGetterFunctions.put(
			"createDate", ObjectStateTransition::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ObjectStateTransition, Date>)
				ObjectStateTransition::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ObjectStateTransition::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ObjectStateTransition, Date>)
				ObjectStateTransition::setModifiedDate);
		attributeGetterFunctions.put(
			"objectStateFlowId", ObjectStateTransition::getObjectStateFlowId);
		attributeSetterBiConsumers.put(
			"objectStateFlowId",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setObjectStateFlowId);
		attributeGetterFunctions.put(
			"sourceObjectStateId",
			ObjectStateTransition::getSourceObjectStateId);
		attributeSetterBiConsumers.put(
			"sourceObjectStateId",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setSourceObjectStateId);
		attributeGetterFunctions.put(
			"targetObjectStateId",
			ObjectStateTransition::getTargetObjectStateId);
		attributeSetterBiConsumers.put(
			"targetObjectStateId",
			(BiConsumer<ObjectStateTransition, Long>)
				ObjectStateTransition::setTargetObjectStateId);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectStateTransitionId() {
		return _objectStateTransitionId;
	}

	@Override
	public void setObjectStateTransitionId(long objectStateTransitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectStateTransitionId = objectStateTransitionId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectStateFlowId() {
		return _objectStateFlowId;
	}

	@Override
	public void setObjectStateFlowId(long objectStateFlowId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectStateFlowId = objectStateFlowId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectStateFlowId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectStateFlowId"));
	}

	@Override
	public long getSourceObjectStateId() {
		return _sourceObjectStateId;
	}

	@Override
	public void setSourceObjectStateId(long sourceObjectStateId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sourceObjectStateId = sourceObjectStateId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalSourceObjectStateId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("sourceObjectStateId"));
	}

	@Override
	public long getTargetObjectStateId() {
		return _targetObjectStateId;
	}

	@Override
	public void setTargetObjectStateId(long targetObjectStateId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_targetObjectStateId = targetObjectStateId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalTargetObjectStateId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("targetObjectStateId"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectStateTransition.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectStateTransition.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectStateTransition toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectStateTransition>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectStateTransitionImpl objectStateTransitionImpl =
			new ObjectStateTransitionImpl();

		objectStateTransitionImpl.setMvccVersion(getMvccVersion());
		objectStateTransitionImpl.setUuid(getUuid());
		objectStateTransitionImpl.setObjectStateTransitionId(
			getObjectStateTransitionId());
		objectStateTransitionImpl.setCompanyId(getCompanyId());
		objectStateTransitionImpl.setUserId(getUserId());
		objectStateTransitionImpl.setUserName(getUserName());
		objectStateTransitionImpl.setCreateDate(getCreateDate());
		objectStateTransitionImpl.setModifiedDate(getModifiedDate());
		objectStateTransitionImpl.setObjectStateFlowId(getObjectStateFlowId());
		objectStateTransitionImpl.setSourceObjectStateId(
			getSourceObjectStateId());
		objectStateTransitionImpl.setTargetObjectStateId(
			getTargetObjectStateId());

		objectStateTransitionImpl.resetOriginalValues();

		return objectStateTransitionImpl;
	}

	@Override
	public ObjectStateTransition cloneWithOriginalValues() {
		ObjectStateTransitionImpl objectStateTransitionImpl =
			new ObjectStateTransitionImpl();

		objectStateTransitionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectStateTransitionImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectStateTransitionImpl.setObjectStateTransitionId(
			this.<Long>getColumnOriginalValue("objectStateTransitionId"));
		objectStateTransitionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectStateTransitionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectStateTransitionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectStateTransitionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectStateTransitionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectStateTransitionImpl.setObjectStateFlowId(
			this.<Long>getColumnOriginalValue("objectStateFlowId"));
		objectStateTransitionImpl.setSourceObjectStateId(
			this.<Long>getColumnOriginalValue("sourceObjectStateId"));
		objectStateTransitionImpl.setTargetObjectStateId(
			this.<Long>getColumnOriginalValue("targetObjectStateId"));

		return objectStateTransitionImpl;
	}

	@Override
	public int compareTo(ObjectStateTransition objectStateTransition) {
		long primaryKey = objectStateTransition.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectStateTransition)) {
			return false;
		}

		ObjectStateTransition objectStateTransition =
			(ObjectStateTransition)object;

		long primaryKey = objectStateTransition.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectStateTransition> toCacheModel() {
		ObjectStateTransitionCacheModel objectStateTransitionCacheModel =
			new ObjectStateTransitionCacheModel();

		objectStateTransitionCacheModel.mvccVersion = getMvccVersion();

		objectStateTransitionCacheModel.uuid = getUuid();

		String uuid = objectStateTransitionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectStateTransitionCacheModel.uuid = null;
		}

		objectStateTransitionCacheModel.objectStateTransitionId =
			getObjectStateTransitionId();

		objectStateTransitionCacheModel.companyId = getCompanyId();

		objectStateTransitionCacheModel.userId = getUserId();

		objectStateTransitionCacheModel.userName = getUserName();

		String userName = objectStateTransitionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectStateTransitionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectStateTransitionCacheModel.createDate = createDate.getTime();
		}
		else {
			objectStateTransitionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectStateTransitionCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			objectStateTransitionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectStateTransitionCacheModel.objectStateFlowId =
			getObjectStateFlowId();

		objectStateTransitionCacheModel.sourceObjectStateId =
			getSourceObjectStateId();

		objectStateTransitionCacheModel.targetObjectStateId =
			getTargetObjectStateId();

		return objectStateTransitionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectStateTransition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectStateTransition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectStateTransition, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectStateTransition)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectStateTransition>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectStateTransition.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectStateTransitionId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectStateFlowId;
	private long _sourceObjectStateId;
	private long _targetObjectStateId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectStateTransition, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectStateTransition)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectStateTransitionId", _objectStateTransitionId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectStateFlowId", _objectStateFlowId);
		_columnOriginalValues.put("sourceObjectStateId", _sourceObjectStateId);
		_columnOriginalValues.put("targetObjectStateId", _targetObjectStateId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectStateTransitionId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectStateFlowId", 256L);

		columnBitmasks.put("sourceObjectStateId", 512L);

		columnBitmasks.put("targetObjectStateId", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectStateTransition _escapedModel;

}