/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.internal.persistence;

import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;

/**
 * @author Rafael Praxedes
 */
public class ObjectDefinitionTableArgumentsResolver
	implements ArgumentsResolver {

	public ObjectDefinitionTableArgumentsResolver(String tableName) {
		_tableName = tableName;
	}

	@Override
	public Object[] getArguments(
		FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn,
		boolean original) {

		throw new UnsupportedOperationException();
	}

	@Override
	public String getClassName() {
		return _tableName;
	}

	@Override
	public String getTableName() {
		return _tableName;
	}

	private final String _tableName;

}