/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.impl;

import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.service.base.OAuthClientASLocalMetadataServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=oauthclient", "json.web.service.context.path=OAuthClientASLocalMetadata"}, service={AopService.class})
public class OAuthClientASLocalMetadataServiceImpl
extends OAuthClientASLocalMetadataServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata)")
    private ModelResourcePermission<OAuthClientASLocalMetadata> _oAuthClientASLocalMetadataModelResourcePermission;

    public OAuthClientASLocalMetadata addOAuthClientASLocalMetadata(String metadataJSON, String wellKnownURISuffix) throws PortalException {
        ModelResourcePermissionUtil.check(this._oAuthClientASLocalMetadataModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)0L, (long)0L, (String)"ADD_OAUTH_CLIENT_AS_LOCAL_METADATA");
        return this.oAuthClientASLocalMetadataLocalService.addOAuthClientASLocalMetadata(this.getUserId(), metadataJSON, wellKnownURISuffix);
    }

    public OAuthClientASLocalMetadata addOAuthClientASLocalMetadata(String authorizationEndpoint, String issuer, String jwksURI, boolean localWellKnownEnabled, String[] supportedGrantTypes, String[] supportedScopes, String[] supportedSubjectTypes, String tokenEndpoint, String userInfoEndpoint) throws PortalException {
        ModelResourcePermissionUtil.check(this._oAuthClientASLocalMetadataModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)0L, (long)0L, (String)"ADD_OAUTH_CLIENT_AS_LOCAL_METADATA");
        return this.oAuthClientASLocalMetadataLocalService.addOAuthClientASLocalMetadata(this.getUserId(), authorizationEndpoint, issuer, jwksURI, localWellKnownEnabled, supportedGrantTypes, supportedScopes, supportedSubjectTypes, tokenEndpoint, userInfoEndpoint);
    }

    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataLocalService.getOAuthClientASLocalMetadata(oAuthClientASLocalMetadataId);
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "DELETE");
        return this.oAuthClientASLocalMetadataLocalService.deleteOAuthClientASLocalMetadata(oAuthClientASLocalMetadata);
    }

    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(String localWellKnownURI) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataLocalService.getOAuthClientASLocalMetadata(localWellKnownURI);
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "DELETE");
        return this.oAuthClientASLocalMetadataLocalService.deleteOAuthClientASLocalMetadata(oAuthClientASLocalMetadata);
    }

    public OAuthClientASLocalMetadata fetchOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.fetchByPrimaryKey(oAuthClientASLocalMetadataId);
        if (oAuthClientASLocalMetadata != null) {
            this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "VIEW");
        }
        return oAuthClientASLocalMetadata;
    }

    public OAuthClientASLocalMetadata fetchOAuthClientASLocalMetadata(long companyId, String issuer) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.fetchByC_I(companyId, issuer);
        if (oAuthClientASLocalMetadata != null) {
            this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "VIEW");
        }
        return oAuthClientASLocalMetadata;
    }

    public List<OAuthClientASLocalMetadata> getCompanyOAuthClientASLocalMetadata(long companyId) {
        return this.oAuthClientASLocalMetadataPersistence.filterFindByCompanyId(companyId);
    }

    public List<OAuthClientASLocalMetadata> getCompanyOAuthClientASLocalMetadata(long companyId, int start, int end) {
        return this.oAuthClientASLocalMetadataPersistence.filterFindByCompanyId(companyId, start, end);
    }

    public OAuthClientASLocalMetadata getOAuthClientASLocalMetadata(long companyId, boolean localWellKnownEnabled, OrderByComparator<OAuthClientASLocalMetadata> orderByComparator) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByC_L_First(companyId, localWellKnownEnabled, orderByComparator);
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "VIEW");
        return oAuthClientASLocalMetadata;
    }

    public OAuthClientASLocalMetadata getOAuthClientASLocalMetadata(long companyId, String issuer) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByC_I(companyId, issuer);
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "VIEW");
        return oAuthClientASLocalMetadata;
    }

    public OAuthClientASLocalMetadata getOAuthClientASLocalMetadata(String localWellKnownURI) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByLocalWellKnownURI(localWellKnownURI);
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientASLocalMetadata, "VIEW");
        return oAuthClientASLocalMetadata;
    }

    public List<OAuthClientASLocalMetadata> getUserOAuthClientASLocalMetadata(long userId) {
        return this.oAuthClientASLocalMetadataPersistence.filterFindByUserId(userId);
    }

    public List<OAuthClientASLocalMetadata> getUserOAuthClientASLocalMetadata(long userId, int start, int end) {
        return this.oAuthClientASLocalMetadataPersistence.filterFindByUserId(userId, start, end);
    }

    public OAuthClientASLocalMetadata updateOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId, String metadataJSON, String wellKnownURISuffix) throws PortalException {
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.oAuthClientASLocalMetadataPersistence.findByPrimaryKey(oAuthClientASLocalMetadataId), "UPDATE");
        return this.oAuthClientASLocalMetadataLocalService.updateOAuthClientASLocalMetadata(oAuthClientASLocalMetadataId, metadataJSON, wellKnownURISuffix);
    }

    public OAuthClientASLocalMetadata updateOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId, String authorizationEndpoint, String issuer, String jwksURI, boolean localWellKnownEnabled, String[] supportedGrantTypes, String[] supportedScopes, String[] supportedSubjectTypes, String tokenEndpoint, String userInfoEndpoint) throws PortalException {
        this._oAuthClientASLocalMetadataModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.oAuthClientASLocalMetadataPersistence.findByPrimaryKey(oAuthClientASLocalMetadataId), "UPDATE");
        return this.oAuthClientASLocalMetadataLocalService.updateOAuthClientASLocalMetadata(oAuthClientASLocalMetadataId, authorizationEndpoint, issuer, jwksURI, localWellKnownEnabled, supportedGrantTypes, supportedScopes, supportedSubjectTypes, tokenEndpoint, userInfoEndpoint);
    }
}

