/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.impl;

import com.liferay.oauth.client.persistence.exception.DuplicateOAuthClientASLocalMetadataException;
import com.liferay.oauth.client.persistence.exception.OAuthClientASLocalMetadataLocalWellKnownURIException;
import com.liferay.oauth.client.persistence.exception.OAuthClientASLocalMetadataMetadataJSONException;
import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.service.base.OAuthClientASLocalMetadataLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata"}, service={AopService.class})
public class OAuthClientASLocalMetadataLocalServiceImpl
extends OAuthClientASLocalMetadataLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public OAuthClientASLocalMetadata addOAuthClientASLocalMetadata(long userId, String metadataJSON, String wellKnownURISuffix) throws PortalException {
        AuthorizationServerMetadata authorizationServerMetadata = this._parseAuthorizationServerMetadata(metadataJSON, wellKnownURISuffix);
        return this.addOAuthClientASLocalMetadata(userId, String.valueOf(authorizationServerMetadata.getAuthorizationEndpointURI()), String.valueOf(authorizationServerMetadata.getIssuer()), String.valueOf(authorizationServerMetadata.getJWKSetURI()), false, StringUtil.split((String)StringUtil.merge((Collection)authorizationServerMetadata.getGrantTypes()), (String)","), StringUtil.split((String)StringUtil.merge((Collection)authorizationServerMetadata.getScopes()), (String)","), StringUtil.split((String)this._getSubjectTypes(authorizationServerMetadata), (String)","), String.valueOf(authorizationServerMetadata.getTokenEndpointURI()), this._getUserInfoEndpointURI(authorizationServerMetadata));
    }

    public OAuthClientASLocalMetadata addOAuthClientASLocalMetadata(long userId, String authorizationEndpoint, String issuer, String jwksURI, boolean localWellKnownEnabled, String[] supportedGrantTypes, String[] supportedScopes, String[] supportedSubjectTypes, String tokenEndpoint, String userInfoEndpoint) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.fetchByC_I(user.getCompanyId(), issuer);
        if (oAuthClientASLocalMetadata != null) {
            throw new DuplicateOAuthClientASLocalMetadataException();
        }
        String localWellKnownURI = this._generateLocalWellKnownURI(issuer, tokenEndpoint, "openid-configuration");
        oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.fetchByLocalWellKnownURI(localWellKnownURI);
        if (oAuthClientASLocalMetadata != null) {
            throw new DuplicateOAuthClientASLocalMetadataException();
        }
        oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.create(this.counterLocalService.increment());
        oAuthClientASLocalMetadata.setCompanyId(user.getCompanyId());
        oAuthClientASLocalMetadata.setUserId(user.getUserId());
        oAuthClientASLocalMetadata.setUserName(user.getFullName());
        oAuthClientASLocalMetadata.setIssuer(issuer);
        oAuthClientASLocalMetadata.setLocalWellKnownEnabled(localWellKnownEnabled);
        oAuthClientASLocalMetadata.setLocalWellKnownURI(localWellKnownURI);
        oAuthClientASLocalMetadata.setMetadataJSON(this._generateMetadataJSON(authorizationEndpoint, issuer, jwksURI, supportedGrantTypes, supportedScopes, supportedSubjectTypes, tokenEndpoint, userInfoEndpoint));
        oAuthClientASLocalMetadata.setOAuthASLocalWellKnownURI(this._generateLocalWellKnownURI(issuer, null, "oauth-authorization-server"));
        oAuthClientASLocalMetadata.setOAuthASMetadataJSON(this._generateAuthorizationServerMetadataJSON(authorizationEndpoint, issuer, jwksURI, supportedScopes, supportedGrantTypes, tokenEndpoint));
        oAuthClientASLocalMetadata = (OAuthClientASLocalMetadata)this.oAuthClientASLocalMetadataPersistence.update((BaseModel)oAuthClientASLocalMetadata);
        this._resourceLocalService.addResources(oAuthClientASLocalMetadata.getCompanyId(), 0L, oAuthClientASLocalMetadata.getUserId(), OAuthClientASLocalMetadata.class.getName(), oAuthClientASLocalMetadata.getOAuthClientASLocalMetadataId(), false, false, false);
        return oAuthClientASLocalMetadata;
    }

    @Override
    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByPrimaryKey(oAuthClientASLocalMetadataId);
        return this.deleteOAuthClientASLocalMetadata(oAuthClientASLocalMetadata);
    }

    @Override
    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(OAuthClientASLocalMetadata oAuthClientASLocalMetadata) throws PortalException {
        oAuthClientASLocalMetadata = (OAuthClientASLocalMetadata)this.oAuthClientASLocalMetadataPersistence.remove((BaseModel)oAuthClientASLocalMetadata);
        this._resourceLocalService.deleteResource(oAuthClientASLocalMetadata.getCompanyId(), OAuthClientASLocalMetadata.class.getName(), 4, oAuthClientASLocalMetadata.getOAuthClientASLocalMetadataId());
        return oAuthClientASLocalMetadata;
    }

    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(String localWellKnownURI) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByLocalWellKnownURI(localWellKnownURI);
        return this.deleteOAuthClientASLocalMetadata(oAuthClientASLocalMetadata);
    }

    public OAuthClientASLocalMetadata fetchOAuthClientASLocalMetadata(long companyId, boolean localWellKnownEnabled, OrderByComparator<OAuthClientASLocalMetadata> orderByComparator) {
        return this.oAuthClientASLocalMetadataPersistence.fetchByC_L_First(companyId, localWellKnownEnabled, orderByComparator);
    }

    public OAuthClientASLocalMetadata fetchOAuthClientASLocalMetadata(long companyId, String issuer) {
        return this.oAuthClientASLocalMetadataPersistence.fetchByC_I(companyId, issuer);
    }

    public OAuthClientASLocalMetadata fetchOAuthClientASLocalMetadata(String localWellKnownURI) {
        return this.oAuthClientASLocalMetadataPersistence.fetchByLocalWellKnownURI(localWellKnownURI);
    }

    public List<OAuthClientASLocalMetadata> getCompanyOAuthClientASLocalMetadata(long companyId) {
        return this.oAuthClientASLocalMetadataPersistence.findByCompanyId(companyId);
    }

    public List<OAuthClientASLocalMetadata> getCompanyOAuthClientASLocalMetadata(long companyId, int start, int end) {
        return this.oAuthClientASLocalMetadataPersistence.findByCompanyId(companyId, start, end);
    }

    public OAuthClientASLocalMetadata getOAuthClientASLocalMetadata(String localWellKnownURI) throws PortalException {
        return this.oAuthClientASLocalMetadataPersistence.findByLocalWellKnownURI(localWellKnownURI);
    }

    public int getOAuthClientASLocalMetadatasCount(long companyId) {
        return this.oAuthClientASLocalMetadataPersistence.countByCompanyId(companyId);
    }

    public List<OAuthClientASLocalMetadata> getUserOAuthClientASLocalMetadata(long userId) {
        return this.oAuthClientASLocalMetadataPersistence.findByUserId(userId);
    }

    public List<OAuthClientASLocalMetadata> getUserOAuthClientASLocalMetadata(long userId, int start, int end) {
        return this.oAuthClientASLocalMetadataPersistence.findByUserId(userId, start, end);
    }

    public OAuthClientASLocalMetadata updateOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId, String metadataJSON, String wellKnownURISuffix) throws PortalException {
        AuthorizationServerMetadata authorizationServerMetadata = this._parseAuthorizationServerMetadata(metadataJSON, wellKnownURISuffix);
        return this.updateOAuthClientASLocalMetadata(oAuthClientASLocalMetadataId, String.valueOf(authorizationServerMetadata.getIssuer()), String.valueOf(authorizationServerMetadata.getAuthorizationEndpointURI()), String.valueOf(authorizationServerMetadata.getJWKSetURI()), false, StringUtil.split((String)StringUtil.merge((Collection)authorizationServerMetadata.getGrantTypes()), (String)","), StringUtil.split((String)StringUtil.merge((Collection)authorizationServerMetadata.getScopes()), (String)","), StringUtil.split((String)this._getSubjectTypes(authorizationServerMetadata), (String)","), String.valueOf(authorizationServerMetadata.getTokenEndpointURI()), this._getUserInfoEndpointURI(authorizationServerMetadata));
    }

    public OAuthClientASLocalMetadata updateOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId, String authorizationEndpoint, String issuer, String jwksURI, boolean localWellKnownEnabled, String[] supportedGrantTypes, String[] supportedScopes, String[] supportedSubjectTypes, String tokenEndpoint, String userInfoEndpoint) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataLocalService.getOAuthClientASLocalMetadata(oAuthClientASLocalMetadataId);
        String localWellKnownURI = oAuthClientASLocalMetadata.getLocalWellKnownURI();
        if (!issuer.equals(oAuthClientASLocalMetadata.getIssuer()) || localWellKnownURI.contains("openid-configuration")) {
            oAuthClientASLocalMetadata.setIssuer(issuer);
            oAuthClientASLocalMetadata.setLocalWellKnownEnabled(localWellKnownEnabled);
            oAuthClientASLocalMetadata.setLocalWellKnownURI(this._generateLocalWellKnownURI(issuer, tokenEndpoint, "openid-configuration"));
            oAuthClientASLocalMetadata.setMetadataJSON(this._generateMetadataJSON(authorizationEndpoint, issuer, jwksURI, supportedGrantTypes, supportedScopes, supportedSubjectTypes, tokenEndpoint, userInfoEndpoint));
            oAuthClientASLocalMetadata.setOAuthASLocalWellKnownURI(this._generateLocalWellKnownURI(issuer, null, "oauth-authorization-server"));
            oAuthClientASLocalMetadata.setOAuthASMetadataJSON(this._generateAuthorizationServerMetadataJSON(authorizationEndpoint, issuer, jwksURI, supportedScopes, supportedGrantTypes, tokenEndpoint));
        }
        return (OAuthClientASLocalMetadata)this.oAuthClientASLocalMetadataPersistence.update((BaseModel)oAuthClientASLocalMetadata);
    }

    private String _generateAuthorizationServerMetadataJSON(String authorizationEndpoint, String issuer, String jwksURI, String[] supportedScopes, String[] supportedGrantTypes, String tokenEndpoint) throws PortalException {
        try {
            AuthorizationServerMetadata authorizationServerMetadata = new AuthorizationServerMetadata(new Issuer(issuer));
            authorizationServerMetadata.setAuthorizationEndpointURI(new URI(authorizationEndpoint));
            authorizationServerMetadata.setGrantTypes(TransformUtil.transformToList((Object[])supportedGrantTypes, GrantType::parse));
            authorizationServerMetadata.setJWKSetURI(new URI(jwksURI));
            authorizationServerMetadata.setScopes(new Scope(supportedScopes));
            authorizationServerMetadata.setTokenEndpointURI(new URI(tokenEndpoint));
            return String.valueOf(authorizationServerMetadata.toJSONObject());
        }
        catch (Exception exception) {
            throw new OAuthClientASLocalMetadataMetadataJSONException(exception.getMessage(), (Throwable)exception);
        }
    }

    private String _generateLocalWellKnownURI(String issuer, String tokenEndpoint, String wellKnownURISuffix) throws PortalException {
        try {
            URI issuerURI = URI.create(issuer);
            if (wellKnownURISuffix.equals("openid-configuration")) {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                return StringBundler.concat((Object[])new Object[]{issuerURI.getScheme(), "://", issuerURI.getAuthority(), "/.well-known/", wellKnownURISuffix, issuerURI.getPath(), Character.valueOf('/'), Base64.encodeToURL((byte[])messageDigest.digest(tokenEndpoint.getBytes())), "/local"});
            }
            return StringBundler.concat((String[])new String[]{issuerURI.getScheme(), "://", issuerURI.getAuthority(), "/o/.well-known/", wellKnownURISuffix});
        }
        catch (Exception exception) {
            throw new OAuthClientASLocalMetadataLocalWellKnownURIException((Throwable)exception);
        }
    }

    private String _generateMetadataJSON(String authorizationEndpoint, String issuer, String jwksURI, String[] supportedGrantTypes, String[] supportedScopes, String[] supportedSubjectTypes, String tokenEndpoint, String userInfoEndpoint) throws PortalException {
        try {
            OIDCProviderMetadata oidcProviderMetadata = new OIDCProviderMetadata(new Issuer(issuer), TransformUtil.transformToList((Object[])supportedSubjectTypes, SubjectType::parse), new URI(jwksURI));
            oidcProviderMetadata.setAuthorizationEndpointURI(new URI(authorizationEndpoint));
            oidcProviderMetadata.setGrantTypes(TransformUtil.transformToList((Object[])supportedGrantTypes, GrantType::parse));
            oidcProviderMetadata.setScopes(new Scope(supportedScopes));
            oidcProviderMetadata.setTokenEndpointURI(new URI(tokenEndpoint));
            oidcProviderMetadata.setUserInfoEndpointURI(new URI(userInfoEndpoint));
            return String.valueOf(oidcProviderMetadata.toJSONObject());
        }
        catch (Exception exception) {
            throw new OAuthClientASLocalMetadataMetadataJSONException(exception.getMessage(), (Throwable)exception);
        }
    }

    private String _getSubjectTypes(AuthorizationServerMetadata authorizationServerMetadata) {
        if (authorizationServerMetadata instanceof OIDCProviderMetadata) {
            OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)authorizationServerMetadata;
            return StringUtil.merge((Collection)oidcProviderMetadata.getSubjectTypes());
        }
        return "";
    }

    private String _getUserInfoEndpointURI(AuthorizationServerMetadata authorizationServerMetadata) {
        if (authorizationServerMetadata instanceof OIDCProviderMetadata) {
            OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)authorizationServerMetadata;
            return String.valueOf(oidcProviderMetadata.getUserInfoEndpointURI());
        }
        return "";
    }

    private AuthorizationServerMetadata _parseAuthorizationServerMetadata(String metadataJSON, String wellKnownURISuffix) throws PortalException {
        try {
            if (wellKnownURISuffix.equals("openid-configuration")) {
                return OIDCProviderMetadata.parse((String)metadataJSON);
            }
            return AuthorizationServerMetadata.parse((String)metadataJSON);
        }
        catch (Exception exception) {
            throw new OAuthClientASLocalMetadataMetadataJSONException(exception.getMessage(), (Throwable)exception);
        }
    }
}

