/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.internal.upgrade.v1_4_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class OAuthClientASLocalMetadataUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(OAuthClientASLocalMetadataUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this.runSQL("update OAuthClientASLocalMetadata set localWellKnownEnabled = [$FALSE$]");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update OAuthClientASLocalMetadata set issuer = ? where oAuthClientASLocalMetadataId = ?");
             Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select oAuthClientASLocalMetadataId, metadataJSON from OAuthClientASLocalMetadata");){
            while (resultSet.next()) {
                long oAuthClientASLocalMetadataId = resultSet.getLong("oAuthClientASLocalMetadataId");
                String metadataJSON = resultSet.getString("metadataJSON");
                if (Validator.isNull((String)metadataJSON)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to update issuer for OAuth 2 client authorization server local metadata " + oAuthClientASLocalMetadataId));
                    continue;
                }
                OIDCProviderMetadata oidcProviderMetadata = OIDCProviderMetadata.parse((String)metadataJSON);
                if (oidcProviderMetadata == null || oidcProviderMetadata.getIssuer() == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to update issuer for OAuth 2 client authorization server local metadata " + oAuthClientASLocalMetadataId));
                    continue;
                }
                preparedStatement.setString(1, String.valueOf(oidcProviderMetadata.getIssuer()));
                preparedStatement.setLong(2, oAuthClientASLocalMetadataId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"OAuthClientASLocalMetadata", (String[])new String[]{"issuer VARCHAR(75) null", "localWellKnownEnabled BOOLEAN", "oAuthASLocalWellKnownURI VARCHAR(256) null", "oAuthASMetadataJSON TEXT null"})};
    }
}

