/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.impl;

import com.liferay.oauth.client.persistence.exception.DuplicateOAuthClientASLocalMetadataException;
import com.liferay.oauth.client.persistence.exception.OAuthClientASLocalMetadataJSONException;
import com.liferay.oauth.client.persistence.exception.OAuthClientASLocalMetadataLocalWellKnownURIException;
import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.service.base.OAuthClientASLocalMetadataLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Base64;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.security.MessageDigest;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata"}, service={AopService.class})
public class OAuthClientASLocalMetadataLocalServiceImpl
extends OAuthClientASLocalMetadataLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public OAuthClientASLocalMetadata addOAuthClientASLocalMetadata(long userId, String metadataJSON, String wellKnownURISuffix) throws PortalException {
        AuthorizationServerMetadata authorizationServerMetadata = this._parseAuthorizationServerMetadata(metadataJSON, wellKnownURISuffix);
        String localWellKnownURI = this._generateLocalWellKnownURI(String.valueOf(authorizationServerMetadata.getIssuer()), String.valueOf(authorizationServerMetadata.getTokenEndpointURI()), wellKnownURISuffix);
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.fetchByLocalWellKnownURI(localWellKnownURI);
        if (oAuthClientASLocalMetadata != null) {
            throw new DuplicateOAuthClientASLocalMetadataException();
        }
        User user = this._userLocalService.getUser(userId);
        oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.create(this.counterLocalService.increment());
        oAuthClientASLocalMetadata.setCompanyId(user.getCompanyId());
        oAuthClientASLocalMetadata.setUserId(user.getUserId());
        oAuthClientASLocalMetadata.setUserName(user.getFullName());
        oAuthClientASLocalMetadata.setLocalWellKnownURI(localWellKnownURI);
        oAuthClientASLocalMetadata.setMetadataJSON(metadataJSON);
        oAuthClientASLocalMetadata = (OAuthClientASLocalMetadata)this.oAuthClientASLocalMetadataPersistence.update((BaseModel)oAuthClientASLocalMetadata);
        this._resourceLocalService.addResources(oAuthClientASLocalMetadata.getCompanyId(), 0L, oAuthClientASLocalMetadata.getUserId(), OAuthClientASLocalMetadata.class.getName(), oAuthClientASLocalMetadata.getOAuthClientASLocalMetadataId(), false, false, false);
        return oAuthClientASLocalMetadata;
    }

    @Override
    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByPrimaryKey(oAuthClientASLocalMetadataId);
        return this.deleteOAuthClientASLocalMetadata(oAuthClientASLocalMetadata);
    }

    @Override
    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(OAuthClientASLocalMetadata oAuthClientASLocalMetadata) throws PortalException {
        oAuthClientASLocalMetadata = (OAuthClientASLocalMetadata)this.oAuthClientASLocalMetadataPersistence.remove((BaseModel)oAuthClientASLocalMetadata);
        this._resourceLocalService.deleteResource(oAuthClientASLocalMetadata.getCompanyId(), OAuthClientASLocalMetadata.class.getName(), 4, oAuthClientASLocalMetadata.getOAuthClientASLocalMetadataId());
        return oAuthClientASLocalMetadata;
    }

    public OAuthClientASLocalMetadata deleteOAuthClientASLocalMetadata(String localWellKnownURI) throws PortalException {
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataPersistence.findByLocalWellKnownURI(localWellKnownURI);
        return this.deleteOAuthClientASLocalMetadata(oAuthClientASLocalMetadata);
    }

    public OAuthClientASLocalMetadata fetchOAuthClientASLocalMetadata(String localWellKnownURI) {
        return this.oAuthClientASLocalMetadataPersistence.fetchByLocalWellKnownURI(localWellKnownURI);
    }

    public List<OAuthClientASLocalMetadata> getCompanyOAuthClientASLocalMetadata(long companyId) {
        return this.oAuthClientASLocalMetadataPersistence.findByCompanyId(companyId);
    }

    public List<OAuthClientASLocalMetadata> getCompanyOAuthClientASLocalMetadata(long companyId, int start, int end) {
        return this.oAuthClientASLocalMetadataPersistence.findByCompanyId(companyId, start, end);
    }

    public OAuthClientASLocalMetadata getOAuthClientASLocalMetadata(String localWellKnownURI) throws PortalException {
        return this.oAuthClientASLocalMetadataPersistence.findByLocalWellKnownURI(localWellKnownURI);
    }

    public List<OAuthClientASLocalMetadata> getUserOAuthClientASLocalMetadata(long userId) {
        return this.oAuthClientASLocalMetadataPersistence.findByUserId(userId);
    }

    public List<OAuthClientASLocalMetadata> getUserOAuthClientASLocalMetadata(long userId, int start, int end) {
        return this.oAuthClientASLocalMetadataPersistence.findByUserId(userId, start, end);
    }

    public OAuthClientASLocalMetadata updateOAuthClientASLocalMetadata(long oAuthClientASLocalMetadataId, String metadataJSON, String wellKnownURISuffix) throws PortalException {
        AuthorizationServerMetadata authorizationServerMetadata = this._parseAuthorizationServerMetadata(metadataJSON, wellKnownURISuffix);
        OAuthClientASLocalMetadata oAuthClientASLocalMetadata = this.oAuthClientASLocalMetadataLocalService.getOAuthClientASLocalMetadata(oAuthClientASLocalMetadataId);
        AuthorizationServerMetadata currentAuthorizationServerMetadata = this._parseAuthorizationServerMetadata(oAuthClientASLocalMetadata.getMetadataJSON(), wellKnownURISuffix);
        oAuthClientASLocalMetadata.setMetadataJSON(metadataJSON);
        String currentIssuer = String.valueOf(currentAuthorizationServerMetadata.getIssuer());
        String currentLocalWellKnownURI = oAuthClientASLocalMetadata.getLocalWellKnownURI();
        if (!currentIssuer.equals(String.valueOf(authorizationServerMetadata.getIssuer())) || !currentLocalWellKnownURI.contains(wellKnownURISuffix)) {
            oAuthClientASLocalMetadata.setLocalWellKnownURI(this._generateLocalWellKnownURI(String.valueOf(authorizationServerMetadata.getIssuer()), String.valueOf(authorizationServerMetadata.getTokenEndpointURI()), wellKnownURISuffix));
        }
        return (OAuthClientASLocalMetadata)this.oAuthClientASLocalMetadataPersistence.update((BaseModel)oAuthClientASLocalMetadata);
    }

    private String _generateLocalWellKnownURI(String issuer, String tokenEndpoint, String wellKnownURISuffix) throws PortalException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            URI issuerURI = URI.create(issuer);
            return StringBundler.concat((Object[])new Object[]{issuerURI.getScheme(), "://", issuerURI.getAuthority(), "/.well-known/", wellKnownURISuffix, issuerURI.getPath(), Character.valueOf('/'), Base64.encodeToURL((byte[])messageDigest.digest(tokenEndpoint.getBytes())), "/local"});
        }
        catch (Exception exception) {
            throw new OAuthClientASLocalMetadataLocalWellKnownURIException((Throwable)exception);
        }
    }

    private AuthorizationServerMetadata _parseAuthorizationServerMetadata(String metadataJSON, String wellKnownURISuffix) throws PortalException {
        try {
            if (wellKnownURISuffix.equals("openid-configuration")) {
                return OIDCProviderMetadata.parse((String)metadataJSON);
            }
            return AuthorizationServerMetadata.parse((String)metadataJSON);
        }
        catch (Exception exception) {
            throw new OAuthClientASLocalMetadataJSONException(exception.getMessage(), (Throwable)exception);
        }
    }
}

