/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.model.impl;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.model.impl.OAuthClientEntryImpl;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.MVCCModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;

public class OAuthClientEntryCacheModel
implements CacheModel<OAuthClientEntry>,
Externalizable,
MVCCModel {
    public long mvccVersion;
    public long oAuthClientEntryId;
    public long companyId;
    public long userId;
    public String userName;
    public long createDate;
    public long modifiedDate;
    public String authRequestParametersJSON;
    public String authServerWellKnownURI;
    public String clientId;
    public String customClaimsJSON;
    public String infoJSON;
    public long metadataCacheTime;
    public String oidcUserInfoMapperJSON;
    public String tokenRequestParametersJSON;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuthClientEntryCacheModel)) {
            return false;
        }
        OAuthClientEntryCacheModel oAuthClientEntryCacheModel = (OAuthClientEntryCacheModel)object;
        return this.oAuthClientEntryId == oAuthClientEntryCacheModel.oAuthClientEntryId && this.mvccVersion == oAuthClientEntryCacheModel.mvccVersion;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (long)this.oAuthClientEntryId);
        return HashUtil.hash((int)hashCode, (long)this.mvccVersion);
    }

    public long getMvccVersion() {
        return this.mvccVersion;
    }

    public void setMvccVersion(long mvccVersion) {
        this.mvccVersion = mvccVersion;
    }

    public String toString() {
        StringBundler sb = new StringBundler(31);
        sb.append("{mvccVersion=");
        sb.append(this.mvccVersion);
        sb.append(", oAuthClientEntryId=");
        sb.append(this.oAuthClientEntryId);
        sb.append(", companyId=");
        sb.append(this.companyId);
        sb.append(", userId=");
        sb.append(this.userId);
        sb.append(", userName=");
        sb.append(this.userName);
        sb.append(", createDate=");
        sb.append(this.createDate);
        sb.append(", modifiedDate=");
        sb.append(this.modifiedDate);
        sb.append(", authRequestParametersJSON=");
        sb.append(this.authRequestParametersJSON);
        sb.append(", authServerWellKnownURI=");
        sb.append(this.authServerWellKnownURI);
        sb.append(", clientId=");
        sb.append(this.clientId);
        sb.append(", customClaimsJSON=");
        sb.append(this.customClaimsJSON);
        sb.append(", infoJSON=");
        sb.append(this.infoJSON);
        sb.append(", metadataCacheTime=");
        sb.append(this.metadataCacheTime);
        sb.append(", oidcUserInfoMapperJSON=");
        sb.append(this.oidcUserInfoMapperJSON);
        sb.append(", tokenRequestParametersJSON=");
        sb.append(this.tokenRequestParametersJSON);
        sb.append("}");
        return sb.toString();
    }

    public OAuthClientEntry toEntityModel() {
        OAuthClientEntryImpl oAuthClientEntryImpl = new OAuthClientEntryImpl();
        oAuthClientEntryImpl.setMvccVersion(this.mvccVersion);
        oAuthClientEntryImpl.setOAuthClientEntryId(this.oAuthClientEntryId);
        oAuthClientEntryImpl.setCompanyId(this.companyId);
        oAuthClientEntryImpl.setUserId(this.userId);
        if (this.userName == null) {
            oAuthClientEntryImpl.setUserName("");
        } else {
            oAuthClientEntryImpl.setUserName(this.userName);
        }
        if (this.createDate == Long.MIN_VALUE) {
            oAuthClientEntryImpl.setCreateDate(null);
        } else {
            oAuthClientEntryImpl.setCreateDate(new Date(this.createDate));
        }
        if (this.modifiedDate == Long.MIN_VALUE) {
            oAuthClientEntryImpl.setModifiedDate(null);
        } else {
            oAuthClientEntryImpl.setModifiedDate(new Date(this.modifiedDate));
        }
        if (this.authRequestParametersJSON == null) {
            oAuthClientEntryImpl.setAuthRequestParametersJSON("");
        } else {
            oAuthClientEntryImpl.setAuthRequestParametersJSON(this.authRequestParametersJSON);
        }
        if (this.authServerWellKnownURI == null) {
            oAuthClientEntryImpl.setAuthServerWellKnownURI("");
        } else {
            oAuthClientEntryImpl.setAuthServerWellKnownURI(this.authServerWellKnownURI);
        }
        if (this.clientId == null) {
            oAuthClientEntryImpl.setClientId("");
        } else {
            oAuthClientEntryImpl.setClientId(this.clientId);
        }
        if (this.customClaimsJSON == null) {
            oAuthClientEntryImpl.setCustomClaimsJSON("");
        } else {
            oAuthClientEntryImpl.setCustomClaimsJSON(this.customClaimsJSON);
        }
        if (this.infoJSON == null) {
            oAuthClientEntryImpl.setInfoJSON("");
        } else {
            oAuthClientEntryImpl.setInfoJSON(this.infoJSON);
        }
        oAuthClientEntryImpl.setMetadataCacheTime(this.metadataCacheTime);
        if (this.oidcUserInfoMapperJSON == null) {
            oAuthClientEntryImpl.setOIDCUserInfoMapperJSON("");
        } else {
            oAuthClientEntryImpl.setOIDCUserInfoMapperJSON(this.oidcUserInfoMapperJSON);
        }
        if (this.tokenRequestParametersJSON == null) {
            oAuthClientEntryImpl.setTokenRequestParametersJSON("");
        } else {
            oAuthClientEntryImpl.setTokenRequestParametersJSON(this.tokenRequestParametersJSON);
        }
        oAuthClientEntryImpl.resetOriginalValues();
        return oAuthClientEntryImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.mvccVersion = objectInput.readLong();
        this.oAuthClientEntryId = objectInput.readLong();
        this.companyId = objectInput.readLong();
        this.userId = objectInput.readLong();
        this.userName = objectInput.readUTF();
        this.createDate = objectInput.readLong();
        this.modifiedDate = objectInput.readLong();
        this.authRequestParametersJSON = objectInput.readUTF();
        this.authServerWellKnownURI = objectInput.readUTF();
        this.clientId = objectInput.readUTF();
        this.customClaimsJSON = (String)objectInput.readObject();
        this.infoJSON = (String)objectInput.readObject();
        this.metadataCacheTime = objectInput.readLong();
        this.oidcUserInfoMapperJSON = objectInput.readUTF();
        this.tokenRequestParametersJSON = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.mvccVersion);
        objectOutput.writeLong(this.oAuthClientEntryId);
        objectOutput.writeLong(this.companyId);
        objectOutput.writeLong(this.userId);
        if (this.userName == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.userName);
        }
        objectOutput.writeLong(this.createDate);
        objectOutput.writeLong(this.modifiedDate);
        if (this.authRequestParametersJSON == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.authRequestParametersJSON);
        }
        if (this.authServerWellKnownURI == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.authServerWellKnownURI);
        }
        if (this.clientId == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.clientId);
        }
        if (this.customClaimsJSON == null) {
            objectOutput.writeObject("");
        } else {
            objectOutput.writeObject(this.customClaimsJSON);
        }
        if (this.infoJSON == null) {
            objectOutput.writeObject("");
        } else {
            objectOutput.writeObject(this.infoJSON);
        }
        objectOutput.writeLong(this.metadataCacheTime);
        if (this.oidcUserInfoMapperJSON == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.oidcUserInfoMapperJSON);
        }
        if (this.tokenRequestParametersJSON == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.tokenRequestParametersJSON);
        }
    }
}

