/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth.client.persistence.model.impl;

import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.service.OAuthClientASLocalMetadataLocalServiceUtil;

/**
 * The extended model base implementation for the OAuthClientASLocalMetadata service. Represents a row in the &quot;OAuthClientASLocalMetadata&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuthClientASLocalMetadataImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthClientASLocalMetadataImpl
 * @see OAuthClientASLocalMetadata
 * @generated
 */
public abstract class OAuthClientASLocalMetadataBaseImpl
	extends OAuthClientASLocalMetadataModelImpl
	implements OAuthClientASLocalMetadata {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth client as local metadata model instance should use the <code>OAuthClientASLocalMetadata</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OAuthClientASLocalMetadataLocalServiceUtil.
				addOAuthClientASLocalMetadata(this);
		}
		else {
			OAuthClientASLocalMetadataLocalServiceUtil.
				updateOAuthClientASLocalMetadata(this);
		}
	}

}