/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth.client.persistence.model.impl;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalServiceUtil;

/**
 * The extended model base implementation for the OAuthClientEntry service. Represents a row in the &quot;OAuthClientEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuthClientEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthClientEntryImpl
 * @see OAuthClientEntry
 * @generated
 */
public abstract class OAuthClientEntryBaseImpl
	extends OAuthClientEntryModelImpl implements OAuthClientEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth client entry model instance should use the <code>OAuthClientEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OAuthClientEntryLocalServiceUtil.addOAuthClientEntry(this);
		}
		else {
			OAuthClientEntryLocalServiceUtil.updateOAuthClientEntry(this);
		}
	}

}