/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.impl;

import com.liferay.oauth.client.persistence.exception.DuplicateOAuthClientEntryException;
import com.liferay.oauth.client.persistence.exception.OAuthClientEntryAuthRequestParametersJSONException;
import com.liferay.oauth.client.persistence.exception.OAuthClientEntryAuthServerWellKnownURIException;
import com.liferay.oauth.client.persistence.exception.OAuthClientEntryInfoJSONException;
import com.liferay.oauth.client.persistence.exception.OAuthClientEntryOIDCUserInfoMapperJSONException;
import com.liferay.oauth.client.persistence.exception.OAuthClientEntryTokenRequestParametersJSONException;
import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.model.OAuthClientEntryTable;
import com.liferay.oauth.client.persistence.service.OAuthClientASLocalMetadataLocalService;
import com.liferay.oauth.client.persistence.service.base.OAuthClientEntryLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.net.URI;
import java.net.URL;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth.client.persistence.model.OAuthClientEntry"}, service={AopService.class})
public class OAuthClientEntryLocalServiceImpl
extends OAuthClientEntryLocalServiceBaseImpl {
    @Reference
    private OAuthClientASLocalMetadataLocalService _oAuthClientASLocalMetadataLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public OAuthClientEntry addOAuthClientEntry(long userId, String authRequestParametersJSON, String authServerWellKnownURI, String infoJSON, String oidcUserInfoMapperJSON, String tokenRequestParametersJSON) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateAuthServerWellKnownURI(authServerWellKnownURI);
        ClientInformation clientInformation = this._parseClientInformation(authServerWellKnownURI, infoJSON);
        ClientMetadata clientMetadata = clientInformation.getMetadata();
        clientMetadata.applyDefaults();
        String clientId = String.valueOf(clientInformation.getID());
        this._validateClientId(0L, user.getCompanyId(), authServerWellKnownURI, clientId);
        if (Validator.isNull((String)authRequestParametersJSON)) {
            authRequestParametersJSON = "{}";
        } else {
            this._validateAuthRequestParametersJSON(authRequestParametersJSON);
        }
        if (Validator.isNull((String)tokenRequestParametersJSON)) {
            tokenRequestParametersJSON = "{}";
        } else {
            this._validateTokenRequestParametersJSON(tokenRequestParametersJSON);
        }
        if (authServerWellKnownURI.contains("openid-configuration")) {
            this._validateOIDCUserInfoMapperJSON(oidcUserInfoMapperJSON);
        } else {
            oidcUserInfoMapperJSON = "{}";
        }
        JSONObject clientInformationJSONObject = clientInformation.toJSONObject();
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryPersistence.create(this.counterLocalService.increment());
        oAuthClientEntry.setCompanyId(user.getCompanyId());
        oAuthClientEntry.setUserId(user.getUserId());
        oAuthClientEntry.setUserName(user.getFullName());
        oAuthClientEntry.setAuthRequestParametersJSON(authRequestParametersJSON);
        oAuthClientEntry.setAuthServerWellKnownURI(authServerWellKnownURI);
        oAuthClientEntry.setClientId(clientId);
        oAuthClientEntry.setInfoJSON(clientInformationJSONObject.toString());
        oAuthClientEntry.setOIDCUserInfoMapperJSON(oidcUserInfoMapperJSON);
        oAuthClientEntry.setTokenRequestParametersJSON(tokenRequestParametersJSON);
        oAuthClientEntry = (OAuthClientEntry)this.oAuthClientEntryPersistence.update((BaseModel)oAuthClientEntry);
        this._resourceLocalService.addResources(oAuthClientEntry.getCompanyId(), 0L, oAuthClientEntry.getUserId(), OAuthClientEntry.class.getName(), oAuthClientEntry.getOAuthClientEntryId(), false, false, false);
        return oAuthClientEntry;
    }

    @Override
    public OAuthClientEntry deleteOAuthClientEntry(long oAuthClientEntryId) throws PortalException {
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryPersistence.findByPrimaryKey(oAuthClientEntryId);
        return this.deleteOAuthClientEntry(oAuthClientEntry);
    }

    public OAuthClientEntry deleteOAuthClientEntry(long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryPersistence.findByC_A_C(companyId, authServerWellKnownURI, clientId);
        return this.deleteOAuthClientEntry(oAuthClientEntry);
    }

    @Override
    public OAuthClientEntry deleteOAuthClientEntry(OAuthClientEntry oAuthClientEntry) throws PortalException {
        oAuthClientEntry = (OAuthClientEntry)this.oAuthClientEntryPersistence.remove((BaseModel)oAuthClientEntry);
        this._resourceLocalService.deleteResource(oAuthClientEntry.getCompanyId(), OAuthClientEntry.class.getName(), 4, oAuthClientEntry.getOAuthClientEntryId());
        return oAuthClientEntry;
    }

    public OAuthClientEntry fetchOAuthClientEntry(long companyId, String authServerWellKnownURI, String clientId) {
        return this.oAuthClientEntryPersistence.fetchByC_A_C(companyId, authServerWellKnownURI, clientId);
    }

    public List<OAuthClientEntry> getAuthServerWellKnownURISuffixOAuthClientEntries(long companyId, String authServerWellKnownURISuffix) {
        return (List)this.oAuthClientEntryPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)OAuthClientEntryTable.INSTANCE).from((Table)OAuthClientEntryTable.INSTANCE).where(OAuthClientEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)OAuthClientEntryTable.INSTANCE.authServerWellKnownURI.like(StringUtil.quote((String)authServerWellKnownURISuffix, (char)'%')))));
    }

    public List<OAuthClientEntry> getCompanyOAuthClientEntries(long companyId) {
        return this.oAuthClientEntryPersistence.findByCompanyId(companyId);
    }

    public OAuthClientEntry getOAuthClientEntry(long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        return this.oAuthClientEntryPersistence.findByC_A_C(companyId, authServerWellKnownURI, clientId);
    }

    public List<OAuthClientEntry> getUserOAuthClientEntries(long userId) {
        return this.oAuthClientEntryPersistence.findByUserId(userId);
    }

    public OAuthClientEntry updateOAuthClientEntry(long oAuthClientEntryId, String authRequestParametersJSON, String authServerWellKnownURI, String infoJSON, String oidcUserInfoMapperJSON, String tokenRequestParametersJSON) throws PortalException {
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryLocalService.getOAuthClientEntry(oAuthClientEntryId);
        this._validateAuthServerWellKnownURI(authServerWellKnownURI);
        ClientInformation clientInformation = this._parseClientInformation(authServerWellKnownURI, infoJSON);
        ClientMetadata clientMetadata = clientInformation.getMetadata();
        clientMetadata.applyDefaults();
        String clientId = String.valueOf(clientInformation.getID());
        this._validateClientId(oAuthClientEntryId, oAuthClientEntry.getCompanyId(), authServerWellKnownURI, clientId);
        if (Validator.isNull((String)authRequestParametersJSON)) {
            authRequestParametersJSON = "{}";
        } else {
            this._validateAuthRequestParametersJSON(authRequestParametersJSON);
        }
        if (Validator.isNull((String)tokenRequestParametersJSON)) {
            tokenRequestParametersJSON = "{}";
        } else {
            this._validateTokenRequestParametersJSON(tokenRequestParametersJSON);
        }
        if (authServerWellKnownURI.contains("openid-configuration")) {
            this._validateOIDCUserInfoMapperJSON(oidcUserInfoMapperJSON);
        } else {
            oidcUserInfoMapperJSON = "{}";
        }
        JSONObject clientInformationJSONObject = clientInformation.toJSONObject();
        oAuthClientEntry.setAuthRequestParametersJSON(authRequestParametersJSON);
        oAuthClientEntry.setAuthServerWellKnownURI(authServerWellKnownURI);
        oAuthClientEntry.setClientId(clientId);
        oAuthClientEntry.setInfoJSON(clientInformationJSONObject.toString());
        oAuthClientEntry.setOIDCUserInfoMapperJSON(oidcUserInfoMapperJSON);
        oAuthClientEntry.setTokenRequestParametersJSON(tokenRequestParametersJSON);
        return (OAuthClientEntry)this.oAuthClientEntryPersistence.update((BaseModel)oAuthClientEntry);
    }

    private ClientInformation _parseClientInformation(String authServerWellKnownURI, String infoJSON) throws PortalException {
        try {
            if (authServerWellKnownURI.contains("openid-configuration")) {
                return OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)infoJSON));
            }
            return ClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)infoJSON));
        }
        catch (Exception exception) {
            throw new OAuthClientEntryInfoJSONException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _validateAuthRequestParametersJSON(String authRequestParametersJSON) throws PortalException {
        try {
            this._validateRequestParametersJSON(authRequestParametersJSON);
        }
        catch (Exception exception) {
            throw new OAuthClientEntryAuthRequestParametersJSONException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _validateAuthServerWellKnownURI(String authServerWellKnownURI) throws PortalException {
        try {
            if (authServerWellKnownURI.endsWith("local")) {
                this._oAuthClientASLocalMetadataLocalService.getOAuthClientASLocalMetadata(authServerWellKnownURI);
                return;
            }
            HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, new URL(authServerWellKnownURI));
            HTTPResponse httpResponse = httpRequest.send();
            if (httpResponse.getStatusCode() != 200) {
                throw new OAuthClientEntryAuthServerWellKnownURIException(httpResponse.getStatusMessage());
            }
        }
        catch (Exception exception) {
            throw new OAuthClientEntryAuthServerWellKnownURIException((Throwable)exception);
        }
    }

    private void _validateClientId(long oAuthClientEntryId, long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        OAuthClientEntry oAuthClientEntry = null;
        if (oAuthClientEntryId > 0L && authServerWellKnownURI.equals((oAuthClientEntry = this.oAuthClientEntryPersistence.findByPrimaryKey(oAuthClientEntryId)).getAuthServerWellKnownURI()) && clientId.equals(oAuthClientEntry.getClientId())) {
            return;
        }
        oAuthClientEntry = this.oAuthClientEntryPersistence.fetchByC_A_C(companyId, authServerWellKnownURI, clientId);
        if (oAuthClientEntry != null) {
            throw new DuplicateOAuthClientEntryException("Client ID " + clientId);
        }
    }

    private void _validateCustomRequestParameters(JSONObject requestParametersJSONObject) throws Exception {
        if (requestParametersJSONObject.containsKey((Object)"custom_request_parameters")) {
            JSONObject customRequestParametersJSONObject = JSONObjectUtils.getJSONObject((JSONObject)requestParametersJSONObject, (String)"custom_request_parameters");
            for (String key : customRequestParametersJSONObject.keySet()) {
                JSONArray valueJSONArray = JSONObjectUtils.getJSONArray((JSONObject)customRequestParametersJSONObject, (String)key);
                for (Object value : valueJSONArray) {
                    if (value instanceof String) continue;
                    throw new ParseException("Value is not a string");
                }
            }
        }
    }

    private void _validateOIDCUserInfoMapperJSON(String oidcUserInfoMapperJSON) throws PortalException {
        try {
            JSONObject oidcUserInfoMapperJSONObject = JSONObjectUtils.parse((String)oidcUserInfoMapperJSON);
            this._validateOIDCUserInfoMapperJSON("user", oidcUserInfoMapperJSONObject, new String[]{"emailAddress", "firstName", "lastName"});
            if (oidcUserInfoMapperJSONObject.containsKey((Object)"address")) {
                this._validateOIDCUserInfoMapperJSON("address", oidcUserInfoMapperJSONObject, new String[]{"city", "street", "zip"});
            }
            if (oidcUserInfoMapperJSONObject.containsKey((Object)"contact")) {
                this._validateOIDCUserInfoMapperJSON("contact", oidcUserInfoMapperJSONObject, new String[0]);
            }
            if (oidcUserInfoMapperJSONObject.containsKey((Object)"phone")) {
                this._validateOIDCUserInfoMapperJSON("phone", oidcUserInfoMapperJSONObject, new String[]{"phone"});
            }
        }
        catch (Exception exception) {
            throw new OAuthClientEntryOIDCUserInfoMapperJSONException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _validateOIDCUserInfoMapperJSON(String key, JSONObject oidcUserInfoMapperJSONObject, String[] requiredKeys) throws Exception {
        JSONObject jsonObject = JSONObjectUtils.getJSONObject((JSONObject)oidcUserInfoMapperJSONObject, (String)key);
        for (String requiredKey : requiredKeys) {
            if (!Validator.isNull((String)jsonObject.getAsString(requiredKey))) continue;
            throw new OAuthClientEntryOIDCUserInfoMapperJSONException(requiredKey + " is required for " + key);
        }
        for (Object object : jsonObject.values()) {
            if (object instanceof String) continue;
            throw new OAuthClientEntryOIDCUserInfoMapperJSONException("Value is not a string");
        }
    }

    private void _validateRequestParametersJSON(String requestParametersJSON) throws Exception {
        JSONObject requestParametersJSONObject = JSONObjectUtils.parse((String)requestParametersJSON);
        this._validateSpecsRequestParameters(requestParametersJSONObject);
        this._validateCustomRequestParameters(requestParametersJSONObject);
    }

    private void _validateSpecsRequestParameters(JSONObject requestParametersJSONObject) throws Exception {
        if (requestParametersJSONObject.containsKey((Object)"redirect_uri")) {
            URI.create(JSONObjectUtils.getString((JSONObject)requestParametersJSONObject, (String)"redirect_uri"));
        }
        if (requestParametersJSONObject.containsKey((Object)"resource")) {
            for (Object uriObject : JSONObjectUtils.getJSONArray((JSONObject)requestParametersJSONObject, (String)"resource")) {
                if (!(uriObject instanceof String)) {
                    throw new ParseException("Resource must be a JSON array of Strings");
                }
                URI.create((String)uriObject);
            }
        }
        if (requestParametersJSONObject.containsKey((Object)"response_type")) {
            ResponseType.parse((String)JSONObjectUtils.getString((JSONObject)requestParametersJSONObject, (String)"response_type"));
        }
        if (requestParametersJSONObject.containsKey((Object)"scope")) {
            Scope.parse((String)JSONObjectUtils.getString((JSONObject)requestParametersJSONObject, (String)"scope"));
        }
    }

    private void _validateTokenRequestParametersJSON(String tokenRequestParametersJSON) throws PortalException {
        try {
            this._validateRequestParametersJSON(tokenRequestParametersJSON);
        }
        catch (Exception exception) {
            throw new OAuthClientEntryTokenRequestParametersJSONException(exception.getMessage(), (Throwable)exception);
        }
    }
}

