/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth.client.persistence.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadata;
import com.liferay.oauth.client.persistence.model.OAuthClientASLocalMetadataModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the OAuthClientASLocalMetadata service. Represents a row in the &quot;OAuthClientASLocalMetadata&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>OAuthClientASLocalMetadataModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuthClientASLocalMetadataImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthClientASLocalMetadataImpl
 * @generated
 */
@JSON(strict = true)
public class OAuthClientASLocalMetadataModelImpl
	extends BaseModelImpl<OAuthClientASLocalMetadata>
	implements OAuthClientASLocalMetadataModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth client as local metadata model instance should use the <code>OAuthClientASLocalMetadata</code> interface instead.
	 */
	public static final String TABLE_NAME = "OAuthClientASLocalMetadata";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT},
		{"oAuthClientASLocalMetadataId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"localWellKnownURI", Types.VARCHAR},
		{"metadataJSON", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("oAuthClientASLocalMetadataId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("localWellKnownURI", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("metadataJSON", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table OAuthClientASLocalMetadata (mvccVersion LONG default 0 not null,oAuthClientASLocalMetadataId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,localWellKnownURI VARCHAR(256) null,metadataJSON TEXT null)";

	public static final String TABLE_SQL_DROP =
		"drop table OAuthClientASLocalMetadata";

	public static final String ORDER_BY_JPQL =
		" ORDER BY oAuthClientASLocalMetadata.oAuthClientASLocalMetadataId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY OAuthClientASLocalMetadata.oAuthClientASLocalMetadataId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LOCALWELLKNOWNURI_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OAUTHCLIENTASLOCALMETADATAID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public OAuthClientASLocalMetadataModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _oAuthClientASLocalMetadataId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setOAuthClientASLocalMetadataId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _oAuthClientASLocalMetadataId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return OAuthClientASLocalMetadata.class;
	}

	@Override
	public String getModelClassName() {
		return OAuthClientASLocalMetadata.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<OAuthClientASLocalMetadata, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<OAuthClientASLocalMetadata, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuthClientASLocalMetadata, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(OAuthClientASLocalMetadata)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<OAuthClientASLocalMetadata, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<OAuthClientASLocalMetadata, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(OAuthClientASLocalMetadata)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<OAuthClientASLocalMetadata, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<OAuthClientASLocalMetadata, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<OAuthClientASLocalMetadata, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<OAuthClientASLocalMetadata, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<OAuthClientASLocalMetadata, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", OAuthClientASLocalMetadata::getMvccVersion);
			attributeGetterFunctions.put(
				"oAuthClientASLocalMetadataId",
				OAuthClientASLocalMetadata::getOAuthClientASLocalMetadataId);
			attributeGetterFunctions.put(
				"companyId", OAuthClientASLocalMetadata::getCompanyId);
			attributeGetterFunctions.put(
				"userId", OAuthClientASLocalMetadata::getUserId);
			attributeGetterFunctions.put(
				"userName", OAuthClientASLocalMetadata::getUserName);
			attributeGetterFunctions.put(
				"createDate", OAuthClientASLocalMetadata::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", OAuthClientASLocalMetadata::getModifiedDate);
			attributeGetterFunctions.put(
				"localWellKnownURI",
				OAuthClientASLocalMetadata::getLocalWellKnownURI);
			attributeGetterFunctions.put(
				"metadataJSON", OAuthClientASLocalMetadata::getMetadataJSON);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<OAuthClientASLocalMetadata, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<OAuthClientASLocalMetadata, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<OAuthClientASLocalMetadata, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<OAuthClientASLocalMetadata, Long>)
					OAuthClientASLocalMetadata::setMvccVersion);
			attributeSetterBiConsumers.put(
				"oAuthClientASLocalMetadataId",
				(BiConsumer<OAuthClientASLocalMetadata, Long>)
					OAuthClientASLocalMetadata::
						setOAuthClientASLocalMetadataId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<OAuthClientASLocalMetadata, Long>)
					OAuthClientASLocalMetadata::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<OAuthClientASLocalMetadata, Long>)
					OAuthClientASLocalMetadata::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<OAuthClientASLocalMetadata, String>)
					OAuthClientASLocalMetadata::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<OAuthClientASLocalMetadata, Date>)
					OAuthClientASLocalMetadata::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<OAuthClientASLocalMetadata, Date>)
					OAuthClientASLocalMetadata::setModifiedDate);
			attributeSetterBiConsumers.put(
				"localWellKnownURI",
				(BiConsumer<OAuthClientASLocalMetadata, String>)
					OAuthClientASLocalMetadata::setLocalWellKnownURI);
			attributeSetterBiConsumers.put(
				"metadataJSON",
				(BiConsumer<OAuthClientASLocalMetadata, String>)
					OAuthClientASLocalMetadata::setMetadataJSON);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getOAuthClientASLocalMetadataId() {
		return _oAuthClientASLocalMetadataId;
	}

	@Override
	public void setOAuthClientASLocalMetadataId(
		long oAuthClientASLocalMetadataId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_oAuthClientASLocalMetadataId = oAuthClientASLocalMetadataId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getLocalWellKnownURI() {
		if (_localWellKnownURI == null) {
			return "";
		}
		else {
			return _localWellKnownURI;
		}
	}

	@Override
	public void setLocalWellKnownURI(String localWellKnownURI) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_localWellKnownURI = localWellKnownURI;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLocalWellKnownURI() {
		return getColumnOriginalValue("localWellKnownURI");
	}

	@JSON
	@Override
	public String getMetadataJSON() {
		if (_metadataJSON == null) {
			return "";
		}
		else {
			return _metadataJSON;
		}
	}

	@Override
	public void setMetadataJSON(String metadataJSON) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_metadataJSON = metadataJSON;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), OAuthClientASLocalMetadata.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public OAuthClientASLocalMetadata toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, OAuthClientASLocalMetadata>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		OAuthClientASLocalMetadataImpl oAuthClientASLocalMetadataImpl =
			new OAuthClientASLocalMetadataImpl();

		oAuthClientASLocalMetadataImpl.setMvccVersion(getMvccVersion());
		oAuthClientASLocalMetadataImpl.setOAuthClientASLocalMetadataId(
			getOAuthClientASLocalMetadataId());
		oAuthClientASLocalMetadataImpl.setCompanyId(getCompanyId());
		oAuthClientASLocalMetadataImpl.setUserId(getUserId());
		oAuthClientASLocalMetadataImpl.setUserName(getUserName());
		oAuthClientASLocalMetadataImpl.setCreateDate(getCreateDate());
		oAuthClientASLocalMetadataImpl.setModifiedDate(getModifiedDate());
		oAuthClientASLocalMetadataImpl.setLocalWellKnownURI(
			getLocalWellKnownURI());
		oAuthClientASLocalMetadataImpl.setMetadataJSON(getMetadataJSON());

		oAuthClientASLocalMetadataImpl.resetOriginalValues();

		return oAuthClientASLocalMetadataImpl;
	}

	@Override
	public OAuthClientASLocalMetadata cloneWithOriginalValues() {
		OAuthClientASLocalMetadataImpl oAuthClientASLocalMetadataImpl =
			new OAuthClientASLocalMetadataImpl();

		oAuthClientASLocalMetadataImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		oAuthClientASLocalMetadataImpl.setOAuthClientASLocalMetadataId(
			this.<Long>getColumnOriginalValue("oAuthClientASLocalMetadataId"));
		oAuthClientASLocalMetadataImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		oAuthClientASLocalMetadataImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		oAuthClientASLocalMetadataImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		oAuthClientASLocalMetadataImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		oAuthClientASLocalMetadataImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		oAuthClientASLocalMetadataImpl.setLocalWellKnownURI(
			this.<String>getColumnOriginalValue("localWellKnownURI"));
		oAuthClientASLocalMetadataImpl.setMetadataJSON(
			this.<String>getColumnOriginalValue("metadataJSON"));

		return oAuthClientASLocalMetadataImpl;
	}

	@Override
	public int compareTo(
		OAuthClientASLocalMetadata oAuthClientASLocalMetadata) {

		long primaryKey = oAuthClientASLocalMetadata.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof OAuthClientASLocalMetadata)) {
			return false;
		}

		OAuthClientASLocalMetadata oAuthClientASLocalMetadata =
			(OAuthClientASLocalMetadata)object;

		long primaryKey = oAuthClientASLocalMetadata.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<OAuthClientASLocalMetadata> toCacheModel() {
		OAuthClientASLocalMetadataCacheModel
			oAuthClientASLocalMetadataCacheModel =
				new OAuthClientASLocalMetadataCacheModel();

		oAuthClientASLocalMetadataCacheModel.mvccVersion = getMvccVersion();

		oAuthClientASLocalMetadataCacheModel.oAuthClientASLocalMetadataId =
			getOAuthClientASLocalMetadataId();

		oAuthClientASLocalMetadataCacheModel.companyId = getCompanyId();

		oAuthClientASLocalMetadataCacheModel.userId = getUserId();

		oAuthClientASLocalMetadataCacheModel.userName = getUserName();

		String userName = oAuthClientASLocalMetadataCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			oAuthClientASLocalMetadataCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			oAuthClientASLocalMetadataCacheModel.createDate =
				createDate.getTime();
		}
		else {
			oAuthClientASLocalMetadataCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			oAuthClientASLocalMetadataCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			oAuthClientASLocalMetadataCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		oAuthClientASLocalMetadataCacheModel.localWellKnownURI =
			getLocalWellKnownURI();

		String localWellKnownURI =
			oAuthClientASLocalMetadataCacheModel.localWellKnownURI;

		if ((localWellKnownURI != null) && (localWellKnownURI.length() == 0)) {
			oAuthClientASLocalMetadataCacheModel.localWellKnownURI = null;
		}

		oAuthClientASLocalMetadataCacheModel.metadataJSON = getMetadataJSON();

		String metadataJSON = oAuthClientASLocalMetadataCacheModel.metadataJSON;

		if ((metadataJSON != null) && (metadataJSON.length() == 0)) {
			oAuthClientASLocalMetadataCacheModel.metadataJSON = null;
		}

		return oAuthClientASLocalMetadataCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<OAuthClientASLocalMetadata, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<OAuthClientASLocalMetadata, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuthClientASLocalMetadata, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(OAuthClientASLocalMetadata)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, OAuthClientASLocalMetadata>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						OAuthClientASLocalMetadata.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _oAuthClientASLocalMetadataId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _localWellKnownURI;
	private String _metadataJSON;

	public <T> T getColumnValue(String columnName) {
		Function<OAuthClientASLocalMetadata, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((OAuthClientASLocalMetadata)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"oAuthClientASLocalMetadataId", _oAuthClientASLocalMetadataId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("localWellKnownURI", _localWellKnownURI);
		_columnOriginalValues.put("metadataJSON", _metadataJSON);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("oAuthClientASLocalMetadataId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("localWellKnownURI", 128L);

		columnBitmasks.put("metadataJSON", 256L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private OAuthClientASLocalMetadata _escapedModel;

}