/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.internal.scheduler;

import com.liferay.notifications.internal.configuration.UserNotificationConfiguration;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.notifications.internal.configuration.UserNotificationConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={SchedulerJobConfiguration.class})
public class UserNotificationEventCleanerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private TriggerConfiguration _triggerConfiguration;
    private int _userNotificationEventDaysLimit;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            if (this._userNotificationEventDaysLimit <= 0) {
                return;
            }
            long timestamp = System.currentTimeMillis() - TimeUnit.DAY.toMillis((long)this._userNotificationEventDaysLimit);
            ActionableDynamicQuery actionableDynamicQuery = this._userNotificationEventLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property archivedProperty = PropertyFactoryUtil.forName((String)"archived");
                dynamicQuery.add(archivedProperty.eq((Object)true));
                Property timestampProperty = PropertyFactoryUtil.forName((String)"timestamp");
                dynamicQuery.add(timestampProperty.lt((Object)timestamp));
            });
            actionableDynamicQuery.setPerformActionMethod(userNotificationEvent -> this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent));
            actionableDynamicQuery.performActions();
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        UserNotificationConfiguration userNotificationConfiguration = (UserNotificationConfiguration)ConfigurableUtil.createConfigurable(UserNotificationConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)userNotificationConfiguration.userNotificationEventCheckInterval(), (TimeUnit)TimeUnit.DAY);
        this._userNotificationEventDaysLimit = userNotificationConfiguration.userNotificationEventDaysLimit();
    }
}

