/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.RoleUsersProvider;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.notification.type.util.NotificationTypeUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TermUsersProvider
implements UsersProvider {
    private static final Pattern _numberPattern = Pattern.compile("\\d+");
    private final NotificationTermEvaluatorTracker _notificationTermEvaluatorTracker;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final RoleLocalService _roleLocalService;
    private final RoleUsersProvider _roleUsersProvider;
    private final UserLocalService _userLocalService;

    public TermUsersProvider(NotificationTermEvaluatorTracker notificationTermEvaluatorTracker, PermissionCheckerFactory permissionCheckerFactory, RoleLocalService roleLocalService, RoleUsersProvider roleUsersProvider, UserLocalService userLocalService) {
        this._notificationTermEvaluatorTracker = notificationTermEvaluatorTracker;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._roleLocalService = roleLocalService;
        this._roleUsersProvider = roleUsersProvider;
        this._userLocalService = userLocalService;
    }

    @Override
    public String getRecipientType() {
        return "term";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext, List<String> values) throws PortalException {
        LinkedHashMap<Long, User> usersMap = new LinkedHashMap<Long, User>();
        ArrayList<String> screenNames = new ArrayList<String>();
        ArrayList<String> termNames = new ArrayList<String>();
        for (String value : values) {
            if (!NotificationTypeUtil.isTermValue((String)value)) {
                screenNames.add(value);
                continue;
            }
            termNames.add(value);
        }
        for (String screenName : screenNames) {
            User user = this._userLocalService.getUserByScreenName(notificationContext.getCompanyId(), screenName);
            if (usersMap.containsKey(user.getUserId()) || !this._hasViewPermission(user, notificationContext)) continue;
            usersMap.put(user.getUserId(), user);
        }
        for (NotificationTermEvaluator notificationTermEvaluator : this._notificationTermEvaluatorTracker.getNotificationTermEvaluators(notificationContext.getClassName())) {
            for (String termName : termNames) {
                String termValue;
                if (Objects.equals(termName, termValue = notificationTermEvaluator.evaluate(NotificationTermEvaluator.Context.RECIPIENT, (Object)notificationContext.getTermValues(), termName))) continue;
                Matcher matcher = _numberPattern.matcher(termValue);
                while (matcher.find()) {
                    User user;
                    long id = GetterUtil.getLong((Object)Long.valueOf(matcher.group()));
                    Role role = this._roleLocalService.fetchRole(id);
                    if (role != null) {
                        for (User user2 : this._roleUsersProvider.provide(notificationContext, Collections.singletonList(role.getName()))) {
                            usersMap.put(user2.getUserId(), user2);
                        }
                        continue;
                    }
                    if (usersMap.containsKey(id) || !this._hasViewPermission(user = this._userLocalService.getUser(id), notificationContext)) continue;
                    usersMap.put(id, user);
                }
            }
        }
        return new ArrayList<User>(usersMap.values());
    }

    private boolean _hasViewPermission(User user, NotificationContext notificationContext) {
        return ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW");
    }
}

