/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.LinkedHashSet;
import java.util.List;

public class RoleUsersProvider
implements UsersProvider {
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final RoleLocalService _roleLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;

    public RoleUsersProvider(PermissionCheckerFactory permissionCheckerFactory, RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._roleLocalService = roleLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String getRecipientType() {
        return "role";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext, List<String> values) throws PortalException {
        LinkedHashSet<Long> userIds = new LinkedHashSet<Long>();
        for (String value : values) {
            Role role = this._roleLocalService.getRole(notificationContext.getCompanyId(), value);
            if (role.getType() == 3 || role.getType() == 2) {
                userIds.addAll(ListUtil.toList((List)this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(notificationContext.getGroupId(), role.getRoleId()), UserGroupRoleModel::getUserId));
                continue;
            }
            for (User user : this._userLocalService.getInheritedRoleUsers(role.getRoleId(), -1, -1, null)) {
                userIds.add(user.getUserId());
            }
        }
        return TransformUtil.unsafeTransform(userIds, userId -> {
            User user = this._userLocalService.getUser(userId.longValue());
            if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) {
                return null;
            }
            return user;
        });
    }
}

