/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.upgrade.v3_6_0;

import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class NotificationQueueEntryUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final ResourceLocalService _resourceLocalService;

    public NotificationQueueEntryUpgradeProcess(ClassNameLocalService classNameLocalService, ResourceLocalService resourceLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select NotificationQueueEntry.notificationQueueEntryId, ", "NotificationQueueEntry.userId, ", "NotificationQueueEntry.notificationTemplateId, ", "NotificationQueueEntry.classNameId, ", "NotificationQueueEntry.classPK, ", "NotificationTemplate.companyId from ", "NotificationQueueEntry inner join NotificationTemplate ", "on NotificationQueueEntry.notificationTemplateId = ", "NotificationTemplate.notificationTemplateId where ", "notificationQueueEntryId not in (select primKeyId from ", "ResourcePermission where name = ?)"}));
             PreparedStatement preparedStatement2 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ObjectDefinition.className from ObjectDefinition ", "where ObjectDefinition.objectDefinitionId = (select ", "ObjectEntry.objectDefinitionId from ObjectEntry where ", "objectEntryId = ?)"}));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update NotificationQueueEntry set classNameId = ? where notificationQueueEntryId = ?");){
            preparedStatement1.setString(1, NotificationQueueEntry.class.getName());
            try (ResultSet resultSet1 = preparedStatement1.executeQuery();){
                while (resultSet1.next()) {
                    long classNameId;
                    ClassName className;
                    this._resourceLocalService.addResources(resultSet1.getLong("companyId"), 0L, resultSet1.getLong("userId"), NotificationQueueEntry.class.getName(), resultSet1.getLong("notificationQueueEntryId"), false, true, true);
                    String classNameString = null;
                    preparedStatement2.setLong(1, resultSet1.getLong("classPK"));
                    try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
                        if (resultSet2.next()) {
                            classNameString = resultSet2.getString("className");
                        }
                    }
                    if (classNameString == null || (className = this._classNameLocalService.fetchClassName(classNameString)) == null || (classNameId = className.getClassNameId()) == 0L || classNameId == resultSet1.getLong("classNameId")) continue;
                    preparedStatement3.setLong(1, classNameId);
                    preparedStatement3.setLong(2, resultSet1.getLong("notificationQueueEntryId"));
                    preparedStatement3.addBatch();
                }
            }
            preparedStatement3.executeBatch();
        }
    }
}

