/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.RoleUsersProvider;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.notification.type.util.NotificationTypeUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TermUsersProvider
implements UsersProvider {
    private final NotificationTermEvaluatorTracker _notificationTermEvaluatorTracker;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final RoleLocalService _roleLocalService;
    private final RoleUsersProvider _roleUsersProvider;
    private final UserLocalService _userLocalService;

    public TermUsersProvider(NotificationTermEvaluatorTracker notificationTermEvaluatorTracker, PermissionCheckerFactory permissionCheckerFactory, RoleLocalService roleLocalService, RoleUsersProvider roleUsersProvider, UserLocalService userLocalService) {
        this._notificationTermEvaluatorTracker = notificationTermEvaluatorTracker;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._roleLocalService = roleLocalService;
        this._roleUsersProvider = roleUsersProvider;
        this._userLocalService = userLocalService;
    }

    @Override
    public String getRecipientType() {
        return "term";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext, List<String> values) throws PortalException {
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<String> screenNames = new ArrayList<String>();
        ArrayList<String> termNames = new ArrayList<String>();
        for (String value : values) {
            if (!NotificationTypeUtil.isTermValue((String)value)) {
                screenNames.add(value);
                continue;
            }
            termNames.add(value);
        }
        users.addAll(TransformUtil.unsafeTransform(screenNames, screenName -> {
            User user = this._userLocalService.getUserByScreenName(notificationContext.getCompanyId(), screenName);
            if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) {
                return null;
            }
            return user;
        }));
        for (NotificationTermEvaluator notificationTermEvaluator : this._notificationTermEvaluatorTracker.getNotificationTermEvaluators(notificationContext.getClassName())) {
            users.addAll(TransformUtil.unsafeTransform(termNames, termName -> {
                String termValue = notificationTermEvaluator.evaluate(NotificationTermEvaluator.Context.RECIPIENT, (Object)notificationContext.getTermValues(), termName);
                if (Objects.equals(termName, termValue)) {
                    return null;
                }
                Role role = this._roleLocalService.fetchRole(GetterUtil.getLong((String)termValue));
                if (role != null) {
                    users.addAll(this._roleUsersProvider.provide(notificationContext, Collections.singletonList(role.getName())));
                    return null;
                }
                User user = this._userLocalService.getUser(GetterUtil.getLong((String)termValue));
                if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) {
                    return null;
                }
                return user;
            }));
        }
        return users;
    }
}

