/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.email.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SubscribersEmailProvider
implements EmailProvider {
    private final ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final SubscriptionLocalService _subscriptionLocalService;
    private final UserLocalService _userLocalService;

    public SubscribersEmailProvider(ObjectEntryFolderLocalService objectEntryFolderLocalService, ObjectEntryLocalService objectEntryLocalService, SubscriptionLocalService subscriptionLocalService, UserLocalService userLocalService) {
        this._objectEntryFolderLocalService = objectEntryFolderLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._subscriptionLocalService = subscriptionLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String provide(NotificationContext notificationContext, Object value) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            return null;
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(notificationContext.getClassPK());
        if (objectEntry == null) {
            return StringUtil.merge(this._getEmailAddresses(notificationContext.getCompanyId(), notificationContext.getClassName(), notificationContext.getClassPK()));
        }
        HashSet<String> emailAddresses = new HashSet<String>();
        emailAddresses.addAll(this._getEmailAddresses(objectEntry.getCompanyId(), ObjectEntryFolder.class.getName(), objectEntry.getGroupId()));
        emailAddresses.addAll(this._getEmailAddresses(objectEntry.getCompanyId(), objectEntry.getModelClassName(), objectEntry.getObjectEntryId()));
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.fetchObjectEntryFolder(objectEntry.getObjectEntryFolderId());
        if (objectEntryFolder == null) {
            return StringUtil.merge(emailAddresses);
        }
        emailAddresses.addAll(this._getEmailAddresses(objectEntry.getCompanyId(), ObjectEntryFolder.class.getName(), objectEntryFolder.getObjectEntryFolderId()));
        Iterator iterator = objectEntryFolder.getAncestorObjectEntryFolderIds().iterator();
        while (iterator.hasNext()) {
            long ancestorObjectEntryFolderId = (Long)iterator.next();
            emailAddresses.addAll(this._getEmailAddresses(objectEntry.getCompanyId(), ObjectEntryFolder.class.getName(), ancestorObjectEntryFolderId));
        }
        return StringUtil.merge(emailAddresses);
    }

    private Set<String> _getEmailAddresses(long companyId, String className, long classPK) {
        HashSet<String> emailAddresses = new HashSet<String>();
        for (Subscription subscription : this._subscriptionLocalService.getSubscriptions(companyId, className, classPK)) {
            User user = this._userLocalService.fetchUser(subscription.getUserId());
            emailAddresses.add(user.getEmailAddress());
        }
        return emailAddresses;
    }
}

