/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UserGroupUsersProvider
implements UsersProvider {
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final UserGroupLocalService _userGroupLocalService;
    private final UserLocalService _userLocalService;

    public UserGroupUsersProvider(PermissionCheckerFactory permissionCheckerFactory, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) {
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._userGroupLocalService = userGroupLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String getRecipientType() {
        return "user-group";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext) throws PortalException {
        HashSet users = new HashSet();
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            UserGroup userGroup = this._userGroupLocalService.getUserGroup(notificationRecipientSetting.getCompanyId(), notificationRecipientSetting.getValue());
            users.addAll(this._userLocalService.getUserGroupUsers(userGroup.getUserGroupId()));
        }
        return ListUtil.filter(new ArrayList(users), user -> ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW"));
    }
}

