/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.impl;

import com.liferay.notification.constants.NotificationTemplateConstants;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.template.util.NotificationTemplateUtil;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.service.NotificationRecipientLocalService;
import com.liferay.notification.service.NotificationRecipientSettingLocalService;
import com.liferay.notification.service.NotificationTemplateAttachmentLocalService;
import com.liferay.notification.service.base.NotificationTemplateLocalServiceBaseImpl;
import com.liferay.notification.service.persistence.NotificationQueueEntryPersistence;
import com.liferay.notification.service.persistence.NotificationTemplateAttachmentPersistence;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.notification.util.NotificationRecipientSettingUtil;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.notification.model.NotificationTemplate"}, service={AopService.class})
public class NotificationTemplateLocalServiceImpl
extends NotificationTemplateLocalServiceBaseImpl {
    @Reference
    private NotificationQueueEntryPersistence _notificationQueueEntryPersistence;
    @Reference
    private NotificationRecipientLocalService _notificationRecipientLocalService;
    @Reference
    private NotificationRecipientSettingLocalService _notificationRecipientSettingLocalService;
    @Reference
    private NotificationTemplateAttachmentLocalService _notificationTemplateAttachmentLocalService;
    @Reference
    private NotificationTemplateAttachmentPersistence _notificationTemplateAttachmentPersistence;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate addNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationTemplateUtil.validateInvokerBundle("Only allowed bundles can add system notification templates", notificationTemplate.isSystem());
        this._validate(notificationContext);
        notificationTemplate.setNotificationTemplateId(this.counterLocalService.increment());
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
        this._resourceLocalService.addResources(notificationTemplate.getCompanyId(), 0L, notificationTemplate.getUserId(), NotificationTemplate.class.getName(), notificationTemplate.getNotificationTemplateId(), false, true, true);
        NotificationRecipient notificationRecipient = notificationContext.getNotificationRecipient();
        notificationRecipient.setNotificationRecipientId(this.counterLocalService.increment());
        notificationRecipient.setClassNameId(this._portal.getClassNameId(NotificationTemplate.class));
        notificationRecipient.setClassPK(notificationTemplate.getNotificationTemplateId());
        notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationContext.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setNotificationRecipientSettingId(this.counterLocalService.increment());
            notificationRecipientSetting.setNotificationRecipientId(notificationRecipient.getNotificationRecipientId());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
        }
        Iterator iterator = notificationContext.getAttachmentObjectFieldIds().iterator();
        while (iterator.hasNext()) {
            long attachmentObjectFieldId = (Long)iterator.next();
            this._notificationTemplateAttachmentLocalService.addNotificationTemplateAttachment(notificationTemplate.getCompanyId(), notificationTemplate.getNotificationTemplateId(), attachmentObjectFieldId);
        }
        return notificationTemplate;
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate addNotificationTemplate(String externalReferenceCode, long userId, String type) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        NotificationTemplate notificationTemplate = this._addNotificationTemplate(externalReferenceCode, user, null, externalReferenceCode, null, null, false, type);
        NotificationRecipient notificationRecipient = this._notificationRecipientLocalService.addNotificationRecipient(user.getUserId(), this._portal.getClassNameId(NotificationTemplate.class), notificationTemplate.getNotificationTemplateId());
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "from", (Object)externalReferenceCode);
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "fromName", (Object)LocalizedMapUtil.getLocalizedMap((String)externalReferenceCode));
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "to", (Object)LocalizedMapUtil.getLocalizedMap((String)externalReferenceCode));
        return notificationTemplate;
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate addSubscriptionNotificationTemplate(String externalReferenceCode, long userId) throws PortalException {
        Map subscriptionNotificationTemplates = NotificationTemplateConstants.getSubscriptionNotificationTemplates();
        User user = this._userLocalService.getUser(userId);
        NotificationTemplate notificationTemplate = this._addNotificationTemplate(externalReferenceCode, user, MapUtil.getString((Map)((Map)subscriptionNotificationTemplates.get(externalReferenceCode)), (Object)"body"), MapUtil.getString((Map)((Map)subscriptionNotificationTemplates.get(externalReferenceCode)), (Object)"name"), "email", MapUtil.getString((Map)((Map)subscriptionNotificationTemplates.get(externalReferenceCode)), (Object)"subject"), true, "email");
        NotificationRecipient notificationRecipient = this._notificationRecipientLocalService.addNotificationRecipient(user.getUserId(), this._portal.getClassNameId(NotificationTemplate.class), notificationTemplate.getNotificationTemplateId());
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "from", (Object)"team@liferay.com");
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "fromName", (Object)LocalizedMapUtil.getLocalizedMap((String)"Liferay Team"));
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "singleRecipient", (Object)Boolean.TRUE.toString());
        this._notificationRecipientSettingLocalService.addNotificationRecipientSetting(user.getUserId(), notificationRecipient.getNotificationRecipientId(), "toType", (Object)"subscribers");
        return notificationTemplate;
    }

    public void deleteCompanyNotificationTemplates(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId)));
        actionableDynamicQuery.setPerformActionMethod(notificationTemplate -> this.deleteNotificationTemplate((NotificationTemplate)notificationTemplate));
        actionableDynamicQuery.performActions();
    }

    @Override
    public NotificationTemplate deleteNotificationTemplate(long notificationTemplateId) throws PortalException {
        NotificationTemplate notificationTemplate = this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplateId);
        return this.notificationTemplateLocalService.deleteNotificationTemplate(notificationTemplate);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public NotificationTemplate deleteNotificationTemplate(NotificationTemplate notificationTemplate) throws PortalException {
        NotificationTemplateUtil.validateInvokerBundle("Only allowed bundles can delete system notification templates", notificationTemplate.isSystem());
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.remove((BaseModel)notificationTemplate);
        this._resourceLocalService.deleteResource((AuditedModel)notificationTemplate, 4);
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        this._notificationRecipientLocalService.deleteNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            this._notificationRecipientSettingLocalService.deleteNotificationRecipientSetting(notificationRecipientSetting);
        }
        List notificationQueueEntries = this._notificationQueueEntryPersistence.findByNotificationTemplateId(notificationTemplate.getNotificationTemplateId());
        for (NotificationQueueEntry notificationQueueEntry : notificationQueueEntries) {
            notificationQueueEntry.setNotificationTemplateId(0L);
            this._notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
        }
        this._notificationTemplateAttachmentPersistence.removeByNotificationTemplateId(notificationTemplate.getNotificationTemplateId());
        return notificationTemplate;
    }

    @Override
    public NotificationTemplate getNotificationTemplate(long notificationTemplateId) throws PortalException {
        return this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplateId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate updateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        String name = notificationTemplate.getName();
        if (!FeatureFlagManagerUtil.isEnabled((long)(notificationTemplate = this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplate.getNotificationTemplateId())).getCompanyId(), (String)"LPD-42577")) {
            NotificationTemplateUtil.validateInvokerBundle("Only allowed bundles can update system notification templates", notificationTemplate.isSystem());
        }
        this._validate(notificationContext);
        NotificationRecipient notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationContext.getNotificationRecipient());
        if (FeatureFlagManagerUtil.isEnabled((long)notificationTemplate.getCompanyId(), (String)"LPD-42577") && notificationTemplate.isSystem() && !ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            notificationTemplate.setName(name);
            Map notificationRecipientSettings = NotificationRecipientSettingUtil.toMap((List)notificationContext.getNotificationRecipientSettings());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipient.getNotificationRecipientId(), "from", notificationRecipientSettings.get("from"));
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipient.getNotificationRecipientId(), "fromName", notificationRecipientSettings.get("fromName"));
            return (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
        }
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            this._notificationRecipientSettingLocalService.deleteNotificationRecipientSetting(notificationRecipientSetting.getNotificationRecipientSettingId());
        }
        for (NotificationRecipientSetting notificationRecipientSetting : notificationContext.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setNotificationRecipientSettingId(this.counterLocalService.increment());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
        }
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationContext.getNotificationTemplate());
        ArrayList<Long> oldAttachmentObjectFieldIds = new ArrayList<Long>();
        for (NotificationTemplateAttachment notificationTemplateAttachment : this._notificationTemplateAttachmentPersistence.findByNotificationTemplateId(notificationTemplate.getNotificationTemplateId())) {
            if (ListUtil.exists((List)notificationContext.getAttachmentObjectFieldIds(), attachmentObjectFieldId -> Objects.equals(attachmentObjectFieldId, notificationTemplateAttachment.getObjectFieldId()))) {
                oldAttachmentObjectFieldIds.add(notificationTemplateAttachment.getObjectFieldId());
                continue;
            }
            this._notificationTemplateAttachmentPersistence.remove((BaseModel)notificationTemplateAttachment);
        }
        Iterator iterator = ListUtil.remove((List)notificationContext.getAttachmentObjectFieldIds(), oldAttachmentObjectFieldIds).iterator();
        while (iterator.hasNext()) {
            long attachmentObjectFieldId2 = (Long)iterator.next();
            this._notificationTemplateAttachmentLocalService.addNotificationTemplateAttachment(notificationTemplate.getCompanyId(), notificationTemplate.getNotificationTemplateId(), attachmentObjectFieldId2);
        }
        return notificationTemplate;
    }

    private NotificationTemplate _addNotificationTemplate(String externalReferenceCode, User user, String body, String name, String recipientType, String subject, boolean system, String type) throws PortalException {
        NotificationTemplate notificationTemplate = this.notificationTemplatePersistence.create(this.counterLocalService.increment());
        notificationTemplate.setExternalReferenceCode(externalReferenceCode);
        notificationTemplate.setCompanyId(user.getCompanyId());
        notificationTemplate.setUserId(user.getUserId());
        notificationTemplate.setUserName(user.getFullName());
        if (body != null) {
            notificationTemplate.setBodyMap(LocalizedMapUtil.getLocalizedMap((String)body));
        }
        notificationTemplate.setEditorType("richText");
        notificationTemplate.setName(name);
        if (recipientType != null) {
            notificationTemplate.setRecipientType(recipientType);
        }
        if (subject != null) {
            notificationTemplate.setSubjectMap(LocalizedMapUtil.getLocalizedMap((String)subject));
        }
        notificationTemplate.setSystem(system);
        notificationTemplate.setType(type);
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
        this._resourceLocalService.addResources(notificationTemplate.getCompanyId(), 0L, notificationTemplate.getUserId(), NotificationTemplate.class.getName(), notificationTemplate.getNotificationTemplateId(), false, true, true);
        return notificationTemplate;
    }

    private void _validate(NotificationContext notificationContext) throws PortalException {
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationContext.getType());
        notificationType.validateNotificationTemplate(notificationContext);
    }
}

