/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notification.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationRecipientSettingModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the NotificationRecipientSetting service. Represents a row in the &quot;NotificationRecipientSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>NotificationRecipientSettingModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationRecipientSettingImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationRecipientSettingImpl
 * @generated
 */
public class NotificationRecipientSettingModelImpl
	extends BaseModelImpl<NotificationRecipientSetting>
	implements NotificationRecipientSettingModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification recipient setting model instance should use the <code>NotificationRecipientSetting</code> interface instead.
	 */
	public static final String TABLE_NAME = "NotificationRecipientSetting";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"notificationRecipientSettingId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"notificationRecipientId", Types.BIGINT}, {"name", Types.VARCHAR},
		{"value", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("notificationRecipientSettingId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("notificationRecipientId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("value", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table NotificationRecipientSetting (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,notificationRecipientSettingId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,notificationRecipientId LONG,name VARCHAR(75) null,value STRING null)";

	public static final String TABLE_SQL_DROP =
		"drop table NotificationRecipientSetting";

	public static final String ORDER_BY_JPQL =
		" ORDER BY notificationRecipientSetting.notificationRecipientSettingId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY NotificationRecipientSetting.notificationRecipientSettingId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NOTIFICATIONRECIPIENTID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NOTIFICATIONRECIPIENTSETTINGID_COLUMN_BITMASK =
		16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public NotificationRecipientSettingModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _notificationRecipientSettingId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setNotificationRecipientSettingId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _notificationRecipientSettingId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return NotificationRecipientSetting.class;
	}

	@Override
	public String getModelClassName() {
		return NotificationRecipientSetting.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<NotificationRecipientSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<NotificationRecipientSetting, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationRecipientSetting, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(NotificationRecipientSetting)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<NotificationRecipientSetting, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<NotificationRecipientSetting, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(NotificationRecipientSetting)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<NotificationRecipientSetting, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<NotificationRecipientSetting, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<NotificationRecipientSetting, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<NotificationRecipientSetting, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<NotificationRecipientSetting, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", NotificationRecipientSetting::getMvccVersion);
			attributeGetterFunctions.put(
				"uuid", NotificationRecipientSetting::getUuid);
			attributeGetterFunctions.put(
				"notificationRecipientSettingId",
				NotificationRecipientSetting::
					getNotificationRecipientSettingId);
			attributeGetterFunctions.put(
				"companyId", NotificationRecipientSetting::getCompanyId);
			attributeGetterFunctions.put(
				"userId", NotificationRecipientSetting::getUserId);
			attributeGetterFunctions.put(
				"userName", NotificationRecipientSetting::getUserName);
			attributeGetterFunctions.put(
				"createDate", NotificationRecipientSetting::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", NotificationRecipientSetting::getModifiedDate);
			attributeGetterFunctions.put(
				"notificationRecipientId",
				NotificationRecipientSetting::getNotificationRecipientId);
			attributeGetterFunctions.put(
				"name", NotificationRecipientSetting::getName);
			attributeGetterFunctions.put(
				"value", NotificationRecipientSetting::getValue);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<NotificationRecipientSetting, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<NotificationRecipientSetting, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<NotificationRecipientSetting, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<NotificationRecipientSetting, Long>)
					NotificationRecipientSetting::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<NotificationRecipientSetting, String>)
					NotificationRecipientSetting::setUuid);
			attributeSetterBiConsumers.put(
				"notificationRecipientSettingId",
				(BiConsumer<NotificationRecipientSetting, Long>)
					NotificationRecipientSetting::
						setNotificationRecipientSettingId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<NotificationRecipientSetting, Long>)
					NotificationRecipientSetting::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<NotificationRecipientSetting, Long>)
					NotificationRecipientSetting::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<NotificationRecipientSetting, String>)
					NotificationRecipientSetting::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<NotificationRecipientSetting, Date>)
					NotificationRecipientSetting::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<NotificationRecipientSetting, Date>)
					NotificationRecipientSetting::setModifiedDate);
			attributeSetterBiConsumers.put(
				"notificationRecipientId",
				(BiConsumer<NotificationRecipientSetting, Long>)
					NotificationRecipientSetting::setNotificationRecipientId);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<NotificationRecipientSetting, String>)
					NotificationRecipientSetting::setName);
			attributeSetterBiConsumers.put(
				"value",
				(BiConsumer<NotificationRecipientSetting, String>)
					NotificationRecipientSetting::setValue);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getNotificationRecipientSettingId() {
		return _notificationRecipientSettingId;
	}

	@Override
	public void setNotificationRecipientSettingId(
		long notificationRecipientSettingId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_notificationRecipientSettingId = notificationRecipientSettingId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getNotificationRecipientId() {
		return _notificationRecipientId;
	}

	@Override
	public void setNotificationRecipientId(long notificationRecipientId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_notificationRecipientId = notificationRecipientId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalNotificationRecipientId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("notificationRecipientId"));
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public String getValue() {
		if (_value == null) {
			return "";
		}
		else {
			return _value;
		}
	}

	@Override
	public String getValue(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getValue(languageId);
	}

	@Override
	public String getValue(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getValue(languageId, useDefault);
	}

	@Override
	public String getValue(String languageId) {
		return LocalizationUtil.getLocalization(getValue(), languageId);
	}

	@Override
	public String getValue(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getValue(), languageId, useDefault);
	}

	@Override
	public String getValueCurrentLanguageId() {
		return _valueCurrentLanguageId;
	}

	@JSON
	@Override
	public String getValueCurrentValue() {
		Locale locale = getLocale(_valueCurrentLanguageId);

		return getValue(locale);
	}

	@Override
	public Map<Locale, String> getValueMap() {
		return LocalizationUtil.getLocalizationMap(getValue());
	}

	@Override
	public void setValue(String value) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_value = value;
	}

	@Override
	public void setValue(String value, Locale locale) {
		setValue(value, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setValue(String value, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(value)) {
			setValue(
				LocalizationUtil.updateLocalization(
					getValue(), "Value", value, languageId, defaultLanguageId));
		}
		else {
			setValue(
				LocalizationUtil.removeLocalization(
					getValue(), "Value", languageId));
		}
	}

	@Override
	public void setValueCurrentLanguageId(String languageId) {
		_valueCurrentLanguageId = languageId;
	}

	@Override
	public void setValueMap(Map<Locale, String> valueMap) {
		setValueMap(valueMap, LocaleUtil.getDefault());
	}

	@Override
	public void setValueMap(
		Map<Locale, String> valueMap, Locale defaultLocale) {

		if (valueMap == null) {
			return;
		}

		setValue(
			LocalizationUtil.updateLocalization(
				valueMap, getValue(), "Value",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				NotificationRecipientSetting.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), NotificationRecipientSetting.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> valueMap = getValueMap();

		for (Map.Entry<Locale, String> entry : valueMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getValue();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			NotificationRecipientSetting.class.getName(), getPrimaryKey(),
			defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String value = getValue(defaultLocale);

		if (Validator.isNull(value)) {
			setValue(getValue(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setValue(getValue(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public NotificationRecipientSetting toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, NotificationRecipientSetting>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		NotificationRecipientSettingImpl notificationRecipientSettingImpl =
			new NotificationRecipientSettingImpl();

		notificationRecipientSettingImpl.setMvccVersion(getMvccVersion());
		notificationRecipientSettingImpl.setUuid(getUuid());
		notificationRecipientSettingImpl.setNotificationRecipientSettingId(
			getNotificationRecipientSettingId());
		notificationRecipientSettingImpl.setCompanyId(getCompanyId());
		notificationRecipientSettingImpl.setUserId(getUserId());
		notificationRecipientSettingImpl.setUserName(getUserName());
		notificationRecipientSettingImpl.setCreateDate(getCreateDate());
		notificationRecipientSettingImpl.setModifiedDate(getModifiedDate());
		notificationRecipientSettingImpl.setNotificationRecipientId(
			getNotificationRecipientId());
		notificationRecipientSettingImpl.setName(getName());
		notificationRecipientSettingImpl.setValue(getValue());

		notificationRecipientSettingImpl.resetOriginalValues();

		return notificationRecipientSettingImpl;
	}

	@Override
	public NotificationRecipientSetting cloneWithOriginalValues() {
		NotificationRecipientSettingImpl notificationRecipientSettingImpl =
			new NotificationRecipientSettingImpl();

		notificationRecipientSettingImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		notificationRecipientSettingImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		notificationRecipientSettingImpl.setNotificationRecipientSettingId(
			this.<Long>getColumnOriginalValue(
				"notificationRecipientSettingId"));
		notificationRecipientSettingImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		notificationRecipientSettingImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		notificationRecipientSettingImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		notificationRecipientSettingImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		notificationRecipientSettingImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		notificationRecipientSettingImpl.setNotificationRecipientId(
			this.<Long>getColumnOriginalValue("notificationRecipientId"));
		notificationRecipientSettingImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		notificationRecipientSettingImpl.setValue(
			this.<String>getColumnOriginalValue("value"));

		return notificationRecipientSettingImpl;
	}

	@Override
	public int compareTo(
		NotificationRecipientSetting notificationRecipientSetting) {

		long primaryKey = notificationRecipientSetting.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof NotificationRecipientSetting)) {
			return false;
		}

		NotificationRecipientSetting notificationRecipientSetting =
			(NotificationRecipientSetting)object;

		long primaryKey = notificationRecipientSetting.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<NotificationRecipientSetting> toCacheModel() {
		NotificationRecipientSettingCacheModel
			notificationRecipientSettingCacheModel =
				new NotificationRecipientSettingCacheModel();

		notificationRecipientSettingCacheModel.mvccVersion = getMvccVersion();

		notificationRecipientSettingCacheModel.uuid = getUuid();

		String uuid = notificationRecipientSettingCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			notificationRecipientSettingCacheModel.uuid = null;
		}

		notificationRecipientSettingCacheModel.notificationRecipientSettingId =
			getNotificationRecipientSettingId();

		notificationRecipientSettingCacheModel.companyId = getCompanyId();

		notificationRecipientSettingCacheModel.userId = getUserId();

		notificationRecipientSettingCacheModel.userName = getUserName();

		String userName = notificationRecipientSettingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			notificationRecipientSettingCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			notificationRecipientSettingCacheModel.createDate =
				createDate.getTime();
		}
		else {
			notificationRecipientSettingCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			notificationRecipientSettingCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			notificationRecipientSettingCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		notificationRecipientSettingCacheModel.notificationRecipientId =
			getNotificationRecipientId();

		notificationRecipientSettingCacheModel.name = getName();

		String name = notificationRecipientSettingCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			notificationRecipientSettingCacheModel.name = null;
		}

		notificationRecipientSettingCacheModel.value = getValue();

		String value = notificationRecipientSettingCacheModel.value;

		if ((value != null) && (value.length() == 0)) {
			notificationRecipientSettingCacheModel.value = null;
		}

		return notificationRecipientSettingCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<NotificationRecipientSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<NotificationRecipientSetting, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationRecipientSetting, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(NotificationRecipientSetting)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, NotificationRecipientSetting>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						NotificationRecipientSetting.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _notificationRecipientSettingId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _notificationRecipientId;
	private String _name;
	private String _value;
	private String _valueCurrentLanguageId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<NotificationRecipientSetting, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((NotificationRecipientSetting)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"notificationRecipientSettingId", _notificationRecipientSettingId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"notificationRecipientId", _notificationRecipientId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("value", _value);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("notificationRecipientSettingId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("notificationRecipientId", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("value", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private NotificationRecipientSetting _escapedModel;

}