/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notification.model.impl;

import com.liferay.notification.model.NotificationQueueEntryAttachment;
import com.liferay.notification.service.NotificationQueueEntryAttachmentLocalServiceUtil;

/**
 * The extended model base implementation for the NotificationQueueEntryAttachment service. Represents a row in the &quot;NQueueEntryAttachment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationQueueEntryAttachmentImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationQueueEntryAttachmentImpl
 * @see NotificationQueueEntryAttachment
 * @generated
 */
public abstract class NotificationQueueEntryAttachmentBaseImpl
	extends NotificationQueueEntryAttachmentModelImpl
	implements NotificationQueueEntryAttachment {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification queue entry attachment model instance should use the <code>NotificationQueueEntryAttachment</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			NotificationQueueEntryAttachmentLocalServiceUtil.
				addNotificationQueueEntryAttachment(this);
		}
		else {
			NotificationQueueEntryAttachmentLocalServiceUtil.
				updateNotificationQueueEntryAttachment(this);
		}
	}

}