/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.email.provider;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RoleEmailProvider
implements EmailProvider {
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    private final GroupLocalService _groupLocalService;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final OrganizationLocalService _organizationLocalService;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final RoleLocalService _roleLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;

    public RoleEmailProvider(AccountEntryLocalService accountEntryLocalService, AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, AccountEntryUserRelLocalService accountEntryUserRelLocalService, GroupLocalService groupLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectFieldLocalService objectFieldLocalService, OrganizationLocalService organizationLocalService, PermissionCheckerFactory permissionCheckerFactory, RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._accountEntryUserRelLocalService = accountEntryUserRelLocalService;
        this._groupLocalService = groupLocalService;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._organizationLocalService = organizationLocalService;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._roleLocalService = roleLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String provide(NotificationContext notificationContext, Object value) throws PortalException {
        if (value == null) {
            return "";
        }
        ObjectDefinition objectDefinition = null;
        Map termValues = notificationContext.getTermValues();
        if (termValues != null) {
            objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(MapUtil.getLong((Map)termValues, (String)"objectDefinitionId"));
        }
        HashMap<Integer, long[]> groupIdsMap = new HashMap<Integer, long[]>();
        if (objectDefinition == null || !objectDefinition.isAccountEntryRestricted()) {
            groupIdsMap.put(6, ListUtil.toLongArray((List)this._accountEntryLocalService.getAccountEntries(-1, -1), AccountEntry::getAccountEntryGroupId));
            groupIdsMap.put(3, ListUtil.toLongArray((List)this._organizationLocalService.getOrganizations(-1, -1), Organization::getGroupId));
            return this._getEmailAddresses(groupIdsMap, notificationContext, value);
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(MapUtil.getLong((Map)termValues, (String)objectField.getName()));
        groupIdsMap.put(6, new long[]{accountEntry.getAccountEntryGroupId()});
        HashSet<Long> groupIds = new HashSet<Long>();
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId())) {
            Organization organization = accountEntryOrganizationRel.getOrganization();
            groupIds.add(organization.getGroupId());
            for (Organization ancestorOrganization : organization.getAncestors()) {
                groupIds.add(ancestorOrganization.getGroupId());
            }
        }
        groupIdsMap.put(3, ArrayUtil.toLongArray(groupIds));
        return this._getEmailAddresses(groupIdsMap, notificationContext, value);
    }

    private String _getEmailAddresses(Map<Integer, long[]> groupIdsMap, NotificationContext notificationContext, Object value) throws PortalException {
        HashSet emailAddresses = new HashSet();
        for (Map roleMap : (List)value) {
            Role role = this._roleLocalService.fetchRole(notificationContext.getCompanyId(), (String)roleMap.get("roleName"));
            if (role == null || role.getType() != 6 && role.getType() != 3 && role.getType() != 1) continue;
            if (role.getType() == 1) {
                ListUtil.isNotEmptyForEach((List)this._userLocalService.getInheritedRoleUsers(role.getRoleId(), -1, -1, null), user -> {
                    if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) {
                        return;
                    }
                    emailAddresses.add(user.getEmailAddress());
                });
                continue;
            }
            for (long groupId : groupIdsMap.get(role.getType())) {
                Group group;
                String roleName = role.getName();
                if (roleName.equals("Account Member")) {
                    group = this._groupLocalService.fetchGroup(groupId);
                    ListUtil.isNotEmptyForEach((List)this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(group.getClassPK()), accountEntryUserRel -> {
                        User user = accountEntryUserRel.fetchUser();
                        if (user != null) {
                            emailAddresses.add(user.getEmailAddress());
                        }
                    });
                    continue;
                }
                if (roleName.equals("Organization User")) {
                    group = this._groupLocalService.fetchGroup(groupId);
                    ListUtil.isNotEmptyForEach((List)this._userLocalService.getOrganizationUsers(group.getClassPK()), user -> emailAddresses.add(user.getEmailAddress()));
                    continue;
                }
                ListUtil.isNotEmptyForEach((List)this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, role.getRoleId()), userGroupRole -> {
                    User user = this._userLocalService.fetchUser(userGroupRole.getUserId());
                    if (user != null) {
                        emailAddresses.add(user.getEmailAddress());
                    }
                });
            }
        }
        return StringUtil.merge(emailAddresses);
    }
}

