/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.upgrade.v3_0_0;

import com.liferay.notification.internal.upgrade.v3_0_0.util.NotificationRecipientSettingTable;
import com.liferay.notification.internal.upgrade.v3_0_0.util.NotificationRecipientTable;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;

public class NotificationRecipientUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select notificationQueueEntryId, companyId, userId, ", "userName, createDate, modifiedDate, bcc, cc, from_, ", "fromName, to_, toName FROM NotificationQueueEntry"}));
             ResultSet resultSet1 = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select notificationTemplateId, companyId, userId, ", "userName, createDate, modifiedDate, bcc, cc, from_, ", "fromName, to_ FROM NotificationTemplate"}));
             ResultSet resultSet2 = preparedStatement2.executeQuery();
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into NotificationRecipient (uuid_, ", "notificationRecipientId, companyId, userId, ", "userName, createDate, modifiedDate, classNameId, ", "classPK) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into NotificationRecipientSetting (uuid_, ", "notificationRecipientSettingId, companyId, userId, ", "userName, createDate, modifiedDate, ", "notificationRecipientId, name, value) VALUES (?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?)"}));){
            while (resultSet1.next()) {
                this._insert(this.increment(), resultSet1.getLong("companyId"), resultSet1.getLong("userId"), resultSet1.getString("userName"), resultSet1.getTimestamp("createDate"), resultSet1.getTimestamp("modifiedDate"), PortalUtil.getClassNameId(NotificationQueueEntry.class), resultSet1.getLong("notificationQueueEntryId"), Arrays.asList("bcc", "cc", "from_", "fromName", "to_", "toName"), preparedStatement3, preparedStatement4, resultSet1);
            }
            while (resultSet2.next()) {
                this._insert(this.increment(), resultSet2.getLong("companyId"), resultSet2.getLong("userId"), resultSet2.getString("userName"), resultSet2.getTimestamp("createDate"), resultSet2.getTimestamp("modifiedDate"), PortalUtil.getClassNameId(NotificationTemplate.class), resultSet2.getLong("notificationTemplateId"), Arrays.asList("bcc", "cc", "from_", "fromName", "to_"), preparedStatement3, preparedStatement4, resultSet2);
            }
            preparedStatement3.executeBatch();
            preparedStatement4.executeBatch();
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"NotificationQueueEntry", (String[])new String[]{"bcc", "cc", "from_", "fromName", "to_", "toName"}), UpgradeProcessFactory.dropColumns((String)"NotificationTemplate", (String[])new String[]{"bcc", "cc", "from_", "fromName", "to_"})};
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{NotificationRecipientTable.create(), NotificationRecipientSettingTable.create()};
    }

    private void _insert(long notificationRecipientId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long recipientClassNameId, long recipientClassPK, List<String> notificationRecipientSettingsName, PreparedStatement preparedStatement3, PreparedStatement preparedStatement4, ResultSet resultSet) throws SQLException {
        preparedStatement3.setString(1, PortalUUIDUtil.generate());
        preparedStatement3.setLong(2, notificationRecipientId);
        preparedStatement3.setLong(3, companyId);
        preparedStatement3.setLong(4, userId);
        preparedStatement3.setString(5, userName);
        preparedStatement3.setTimestamp(6, createDate);
        preparedStatement3.setTimestamp(7, modifiedDate);
        preparedStatement3.setLong(8, recipientClassNameId);
        preparedStatement3.setLong(9, recipientClassPK);
        preparedStatement3.addBatch();
        for (String notificationRecipientSettingName : notificationRecipientSettingsName) {
            preparedStatement4.setString(1, PortalUUIDUtil.generate());
            preparedStatement4.setLong(2, this.increment());
            preparedStatement4.setLong(3, companyId);
            preparedStatement4.setLong(4, userId);
            preparedStatement4.setString(5, userName);
            preparedStatement4.setTimestamp(6, createDate);
            preparedStatement4.setTimestamp(7, modifiedDate);
            preparedStatement4.setLong(8, notificationRecipientId);
            preparedStatement4.setString(9, StringUtil.removeSubstring((String)notificationRecipientSettingName, (String)"_"));
            preparedStatement4.setString(10, resultSet.getString(notificationRecipientSettingName));
            preparedStatement4.addBatch();
        }
    }
}

