/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.impl;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.template.util.NotificationTemplateUtil;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.service.NotificationRecipientLocalService;
import com.liferay.notification.service.NotificationRecipientSettingLocalService;
import com.liferay.notification.service.NotificationTemplateAttachmentLocalService;
import com.liferay.notification.service.base.NotificationTemplateLocalServiceBaseImpl;
import com.liferay.notification.service.persistence.NotificationQueueEntryPersistence;
import com.liferay.notification.service.persistence.NotificationTemplateAttachmentPersistence;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.notification.model.NotificationTemplate"}, service={AopService.class})
public class NotificationTemplateLocalServiceImpl
extends NotificationTemplateLocalServiceBaseImpl {
    @Reference
    private NotificationQueueEntryPersistence _notificationQueueEntryPersistence;
    @Reference
    private NotificationRecipientLocalService _notificationRecipientLocalService;
    @Reference
    private NotificationRecipientSettingLocalService _notificationRecipientSettingLocalService;
    @Reference
    private NotificationTemplateAttachmentLocalService _notificationTemplateAttachmentLocalService;
    @Reference
    private NotificationTemplateAttachmentPersistence _notificationTemplateAttachmentPersistence;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate addNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationTemplateUtil.validateInvokerBundle("Only allowed bundles can add system notification templates", notificationTemplate.isSystem());
        this._validate(notificationContext);
        notificationTemplate.setNotificationTemplateId(this.counterLocalService.increment());
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
        this._resourceLocalService.addResources(notificationTemplate.getCompanyId(), 0L, notificationTemplate.getUserId(), NotificationTemplate.class.getName(), notificationTemplate.getNotificationTemplateId(), false, true, true);
        NotificationRecipient notificationRecipient = notificationContext.getNotificationRecipient();
        notificationRecipient.setNotificationRecipientId(this.counterLocalService.increment());
        notificationRecipient.setClassNameId(this._portal.getClassNameId(NotificationTemplate.class));
        notificationRecipient.setClassPK(notificationTemplate.getNotificationTemplateId());
        notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationContext.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setNotificationRecipientSettingId(this.counterLocalService.increment());
            notificationRecipientSetting.setNotificationRecipientId(notificationRecipient.getNotificationRecipientId());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
        }
        Iterator iterator = notificationContext.getAttachmentObjectFieldIds().iterator();
        while (iterator.hasNext()) {
            long attachmentObjectFieldId = (Long)iterator.next();
            this._notificationTemplateAttachmentLocalService.addNotificationTemplateAttachment(notificationTemplate.getCompanyId(), notificationTemplate.getNotificationTemplateId(), attachmentObjectFieldId);
        }
        return notificationTemplate;
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate addNotificationTemplate(String externalReferenceCode, long userId, String type) throws PortalException {
        NotificationTemplate notificationTemplate = this.notificationTemplatePersistence.create(this.counterLocalService.increment());
        notificationTemplate.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        notificationTemplate.setUserId(userId);
        notificationTemplate.setUserName(user.getFullName());
        notificationTemplate.setEditorType("richText");
        notificationTemplate.setName(externalReferenceCode);
        notificationTemplate.setSystem(false);
        notificationTemplate.setType(type);
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
        this._resourceLocalService.addResources(notificationTemplate.getCompanyId(), 0L, userId, NotificationTemplate.class.getName(), notificationTemplate.getNotificationTemplateId(), false, true, true);
        NotificationRecipient notificationRecipient = this._notificationRecipientLocalService.createNotificationRecipient(this.counterLocalService.increment());
        notificationRecipient.setUserId(userId);
        notificationRecipient.setUserName(user.getFullName());
        notificationRecipient.setClassNameId(this._portal.getClassNameId(NotificationTemplate.class));
        notificationRecipient.setClassPK(notificationTemplate.getNotificationTemplateId());
        notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationRecipient);
        this._addNotificationRecipientSetting(null, "from", notificationRecipient.getNotificationRecipientId(), user, externalReferenceCode);
        this._addNotificationRecipientSetting(LocaleUtil.getDefault(), "fromName", notificationRecipient.getNotificationRecipientId(), user, externalReferenceCode);
        this._addNotificationRecipientSetting(LocaleUtil.getDefault(), "to", notificationRecipient.getNotificationRecipientId(), user, externalReferenceCode);
        return notificationTemplate;
    }

    @Override
    public NotificationTemplate deleteNotificationTemplate(long notificationTemplateId) throws PortalException {
        NotificationTemplate notificationTemplate = this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplateId);
        return this.notificationTemplateLocalService.deleteNotificationTemplate(notificationTemplate);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public NotificationTemplate deleteNotificationTemplate(NotificationTemplate notificationTemplate) throws PortalException {
        NotificationTemplateUtil.validateInvokerBundle("Only allowed bundles can delete system notification templates", notificationTemplate.isSystem());
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.remove((BaseModel)notificationTemplate);
        this._resourceLocalService.deleteResource((AuditedModel)notificationTemplate, 4);
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        this._notificationRecipientLocalService.deleteNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            this._notificationRecipientSettingLocalService.deleteNotificationRecipientSetting(notificationRecipientSetting);
        }
        List notificationQueueEntries = this._notificationQueueEntryPersistence.findByNotificationTemplateId(notificationTemplate.getNotificationTemplateId());
        for (NotificationQueueEntry notificationQueueEntry : notificationQueueEntries) {
            notificationQueueEntry.setNotificationTemplateId(0L);
            this._notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
        }
        this._notificationTemplateAttachmentPersistence.removeByNotificationTemplateId(notificationTemplate.getNotificationTemplateId());
        return notificationTemplate;
    }

    @Override
    public NotificationTemplate getNotificationTemplate(long notificationTemplateId) throws PortalException {
        return this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplateId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate updateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        notificationTemplate = this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplate.getNotificationTemplateId());
        NotificationTemplateUtil.validateInvokerBundle("Only allowed bundles can update system notification templates", notificationTemplate.isSystem());
        this._validate(notificationContext);
        NotificationRecipient notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationContext.getNotificationRecipient());
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            this._notificationRecipientSettingLocalService.deleteNotificationRecipientSetting(notificationRecipientSetting.getNotificationRecipientSettingId());
        }
        for (NotificationRecipientSetting notificationRecipientSetting : notificationContext.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setNotificationRecipientSettingId(this.counterLocalService.increment());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
        }
        notificationTemplate = (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationContext.getNotificationTemplate());
        ArrayList<Long> oldAttachmentObjectFieldIds = new ArrayList<Long>();
        for (NotificationTemplateAttachment notificationTemplateAttachment : this._notificationTemplateAttachmentPersistence.findByNotificationTemplateId(notificationTemplate.getNotificationTemplateId())) {
            if (ListUtil.exists((List)notificationContext.getAttachmentObjectFieldIds(), attachmentObjectFieldId -> Objects.equals(attachmentObjectFieldId, notificationTemplateAttachment.getObjectFieldId()))) {
                oldAttachmentObjectFieldIds.add(notificationTemplateAttachment.getObjectFieldId());
                continue;
            }
            this._notificationTemplateAttachmentPersistence.remove((BaseModel)notificationTemplateAttachment);
        }
        Iterator iterator = ListUtil.remove((List)notificationContext.getAttachmentObjectFieldIds(), oldAttachmentObjectFieldIds).iterator();
        while (iterator.hasNext()) {
            long attachmentObjectFieldId2 = (Long)iterator.next();
            this._notificationTemplateAttachmentLocalService.addNotificationTemplateAttachment(notificationTemplate.getCompanyId(), notificationTemplate.getNotificationTemplateId(), attachmentObjectFieldId2);
        }
        return notificationTemplate;
    }

    private void _addNotificationRecipientSetting(Locale locale, String name, long notificationRecipientId, User user, String value) {
        NotificationRecipientSetting notificationRecipientSetting = this._notificationRecipientSettingLocalService.createNotificationRecipientSetting(this.counterLocalService.increment());
        notificationRecipientSetting.setUserId(user.getUserId());
        notificationRecipientSetting.setUserName(user.getFullName());
        notificationRecipientSetting.setNotificationRecipientId(notificationRecipientId);
        notificationRecipientSetting.setName(name);
        if (locale != null) {
            notificationRecipientSetting.setValue(value, LocaleUtil.getDefault());
        } else {
            notificationRecipientSetting.setValue(value);
        }
        this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
    }

    private void _validate(NotificationContext notificationContext) throws PortalException {
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationContext.getType());
        notificationType.validateNotificationTemplate(notificationContext);
    }
}

