/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.persistence.impl;

import com.liferay.notification.exception.NoSuchNotificationRecipientException;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientTable;
import com.liferay.notification.model.impl.NotificationRecipientImpl;
import com.liferay.notification.model.impl.NotificationRecipientModelImpl;
import com.liferay.notification.service.persistence.NotificationRecipientPersistence;
import com.liferay.notification.service.persistence.NotificationRecipientUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationRecipientPersistence.class})
public class NotificationRecipientPersistenceImpl
extends BasePersistenceImpl<NotificationRecipient>
implements NotificationRecipientPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = NotificationRecipientImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "notificationRecipient.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(notificationRecipient.uuid IS NULL OR notificationRecipient.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "notificationRecipient.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(notificationRecipient.uuid IS NULL OR notificationRecipient.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "notificationRecipient.companyId = ?";
    private FinderPath _finderPathFetchByClassPK;
    private FinderPath _finderPathCountByClassPK;
    private static final String _FINDER_COLUMN_CLASSPK_CLASSPK_2 = "notificationRecipient.classPK = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_NOTIFICATIONRECIPIENT = "SELECT notificationRecipient FROM NotificationRecipient notificationRecipient";
    private static final String _SQL_SELECT_NOTIFICATIONRECIPIENT_WHERE = "SELECT notificationRecipient FROM NotificationRecipient notificationRecipient WHERE ";
    private static final String _SQL_COUNT_NOTIFICATIONRECIPIENT = "SELECT COUNT(notificationRecipient) FROM NotificationRecipient notificationRecipient";
    private static final String _SQL_COUNT_NOTIFICATIONRECIPIENT_WHERE = "SELECT COUNT(notificationRecipient) FROM NotificationRecipient notificationRecipient WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "notificationRecipient.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No NotificationRecipient exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No NotificationRecipient exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(NotificationRecipientPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<NotificationRecipient> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<NotificationRecipient> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<NotificationRecipient> findByUuid(String uuid, int start, int end, OrderByComparator<NotificationRecipient> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<NotificationRecipient> findByUuid(String uuid, int start, int end, OrderByComparator<NotificationRecipient> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (NotificationRecipient notificationRecipient : list) {
                if (uuid.equals(notificationRecipient.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_NOTIFICATIONRECIPIENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY notificationRecipient.notificationRecipientId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public NotificationRecipient findByUuid_First(String uuid, OrderByComparator<NotificationRecipient> orderByComparator) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = this.fetchByUuid_First(uuid, orderByComparator);
        if (notificationRecipient != null) {
            return notificationRecipient;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchNotificationRecipientException(sb.toString());
    }

    public NotificationRecipient fetchByUuid_First(String uuid, OrderByComparator<NotificationRecipient> orderByComparator) {
        List<NotificationRecipient> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public NotificationRecipient findByUuid_Last(String uuid, OrderByComparator<NotificationRecipient> orderByComparator) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = this.fetchByUuid_Last(uuid, orderByComparator);
        if (notificationRecipient != null) {
            return notificationRecipient;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchNotificationRecipientException(sb.toString());
    }

    public NotificationRecipient fetchByUuid_Last(String uuid, OrderByComparator<NotificationRecipient> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<NotificationRecipient> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public NotificationRecipient[] findByUuid_PrevAndNext(long notificationRecipientId, String uuid, OrderByComparator<NotificationRecipient> orderByComparator) throws NoSuchNotificationRecipientException {
        uuid = Objects.toString(uuid, "");
        NotificationRecipient notificationRecipient = this.findByPrimaryKey(notificationRecipientId);
        Session session = null;
        try {
            session = this.openSession();
            NotificationRecipient[] array = new NotificationRecipientImpl[]{this.getByUuid_PrevAndNext(session, notificationRecipient, uuid, orderByComparator, true), notificationRecipient, this.getByUuid_PrevAndNext(session, notificationRecipient, uuid, orderByComparator, false)};
            NotificationRecipient[] notificationRecipientArray = array;
            return notificationRecipientArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected NotificationRecipient getByUuid_PrevAndNext(Session session, NotificationRecipient notificationRecipient, String uuid, OrderByComparator<NotificationRecipient> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_NOTIFICATIONRECIPIENT_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY notificationRecipient.notificationRecipientId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)notificationRecipient)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (NotificationRecipient)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (NotificationRecipient notificationRecipient : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)notificationRecipient);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_NOTIFICATIONRECIPIENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<NotificationRecipient> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<NotificationRecipient> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<NotificationRecipient> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<NotificationRecipient> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<NotificationRecipient> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<NotificationRecipient> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (NotificationRecipient notificationRecipient : list) {
                if (uuid.equals(notificationRecipient.getUuid()) && companyId == notificationRecipient.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_NOTIFICATIONRECIPIENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY notificationRecipient.notificationRecipientId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public NotificationRecipient findByUuid_C_First(String uuid, long companyId, OrderByComparator<NotificationRecipient> orderByComparator) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (notificationRecipient != null) {
            return notificationRecipient;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchNotificationRecipientException(sb.toString());
    }

    public NotificationRecipient fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<NotificationRecipient> orderByComparator) {
        List<NotificationRecipient> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public NotificationRecipient findByUuid_C_Last(String uuid, long companyId, OrderByComparator<NotificationRecipient> orderByComparator) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (notificationRecipient != null) {
            return notificationRecipient;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchNotificationRecipientException(sb.toString());
    }

    public NotificationRecipient fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<NotificationRecipient> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<NotificationRecipient> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public NotificationRecipient[] findByUuid_C_PrevAndNext(long notificationRecipientId, String uuid, long companyId, OrderByComparator<NotificationRecipient> orderByComparator) throws NoSuchNotificationRecipientException {
        uuid = Objects.toString(uuid, "");
        NotificationRecipient notificationRecipient = this.findByPrimaryKey(notificationRecipientId);
        Session session = null;
        try {
            session = this.openSession();
            NotificationRecipient[] array = new NotificationRecipientImpl[]{this.getByUuid_C_PrevAndNext(session, notificationRecipient, uuid, companyId, orderByComparator, true), notificationRecipient, this.getByUuid_C_PrevAndNext(session, notificationRecipient, uuid, companyId, orderByComparator, false)};
            NotificationRecipient[] notificationRecipientArray = array;
            return notificationRecipientArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected NotificationRecipient getByUuid_C_PrevAndNext(Session session, NotificationRecipient notificationRecipient, String uuid, long companyId, OrderByComparator<NotificationRecipient> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_NOTIFICATIONRECIPIENT_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY notificationRecipient.notificationRecipientId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)notificationRecipient)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (NotificationRecipient)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (NotificationRecipient notificationRecipient : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)notificationRecipient);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_NOTIFICATIONRECIPIENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public NotificationRecipient findByClassPK(long classPK) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = this.fetchByClassPK(classPK);
        if (notificationRecipient == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classPK=");
            sb.append(classPK);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchNotificationRecipientException(sb.toString());
        }
        return notificationRecipient;
    }

    public NotificationRecipient fetchByClassPK(long classPK) {
        return this.fetchByClassPK(classPK, true);
    }

    public NotificationRecipient fetchByClassPK(long classPK, boolean useFinderCache) {
        NotificationRecipient notificationRecipient;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{classPK};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByClassPK, finderArgs, (BasePersistence)this);
        }
        if (result instanceof NotificationRecipient && classPK != (notificationRecipient = (NotificationRecipient)result).getClassPK()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_NOTIFICATIONRECIPIENT_WHERE);
            sb.append(_FINDER_COLUMN_CLASSPK_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classPK);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByClassPK, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{classPK};
                            }
                            _log.warn((Object)("NotificationRecipientPersistenceImpl.fetchByClassPK(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    NotificationRecipient notificationRecipient2 = (NotificationRecipient)list.get(0);
                    result = notificationRecipient2;
                    this.cacheResult(notificationRecipient2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (NotificationRecipient)result;
    }

    public NotificationRecipient removeByClassPK(long classPK) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = this.findByClassPK(classPK);
        return (NotificationRecipient)this.remove((BaseModel)notificationRecipient);
    }

    public int countByClassPK(long classPK) {
        FinderPath finderPath = this._finderPathCountByClassPK;
        Object[] finderArgs = new Object[]{classPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_NOTIFICATIONRECIPIENT_WHERE);
            sb.append(_FINDER_COLUMN_CLASSPK_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classPK);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public NotificationRecipientPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(NotificationRecipient.class);
        this.setModelImplClass(NotificationRecipientImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)NotificationRecipientTable.INSTANCE);
    }

    public void cacheResult(NotificationRecipient notificationRecipient) {
        this.entityCache.putResult(NotificationRecipientImpl.class, (Serializable)Long.valueOf(notificationRecipient.getPrimaryKey()), (Serializable)notificationRecipient);
        this.finderCache.putResult(this._finderPathFetchByClassPK, new Object[]{notificationRecipient.getClassPK()}, (Object)notificationRecipient);
    }

    public void cacheResult(List<NotificationRecipient> notificationRecipients) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && notificationRecipients.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (NotificationRecipient notificationRecipient : notificationRecipients) {
            if (this.entityCache.getResult(NotificationRecipientImpl.class, (Serializable)Long.valueOf(notificationRecipient.getPrimaryKey())) != null) continue;
            this.cacheResult(notificationRecipient);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(NotificationRecipientImpl.class);
        this.finderCache.clearCache(NotificationRecipientImpl.class);
    }

    public void clearCache(NotificationRecipient notificationRecipient) {
        this.entityCache.removeResult(NotificationRecipientImpl.class, (BaseModel)notificationRecipient);
    }

    public void clearCache(List<NotificationRecipient> notificationRecipients) {
        for (NotificationRecipient notificationRecipient : notificationRecipients) {
            this.entityCache.removeResult(NotificationRecipientImpl.class, (BaseModel)notificationRecipient);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(NotificationRecipientImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(NotificationRecipientImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(NotificationRecipientModelImpl notificationRecipientModelImpl) {
        Object[] args = new Object[]{notificationRecipientModelImpl.getClassPK()};
        this.finderCache.putResult(this._finderPathCountByClassPK, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByClassPK, args, (Object)notificationRecipientModelImpl);
    }

    public NotificationRecipient create(long notificationRecipientId) {
        NotificationRecipientImpl notificationRecipient = new NotificationRecipientImpl();
        notificationRecipient.setNew(true);
        notificationRecipient.setPrimaryKey(notificationRecipientId);
        String uuid = PortalUUIDUtil.generate();
        notificationRecipient.setUuid(uuid);
        notificationRecipient.setCompanyId(CompanyThreadLocal.getCompanyId());
        return notificationRecipient;
    }

    public NotificationRecipient remove(long notificationRecipientId) throws NoSuchNotificationRecipientException {
        return this.remove(Long.valueOf(notificationRecipientId));
    }

    public NotificationRecipient remove(Serializable primaryKey) throws NoSuchNotificationRecipientException {
        Session session = null;
        try {
            session = this.openSession();
            NotificationRecipient notificationRecipient = (NotificationRecipient)session.get(NotificationRecipientImpl.class, primaryKey);
            if (notificationRecipient == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchNotificationRecipientException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            NotificationRecipient notificationRecipient2 = (NotificationRecipient)this.remove((BaseModel)notificationRecipient);
            return notificationRecipient2;
        }
        catch (NoSuchNotificationRecipientException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected NotificationRecipient removeImpl(NotificationRecipient notificationRecipient) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)notificationRecipient)) {
                notificationRecipient = (NotificationRecipient)session.get(NotificationRecipientImpl.class, notificationRecipient.getPrimaryKeyObj());
            }
            if (notificationRecipient != null) {
                session.delete((Object)notificationRecipient);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (notificationRecipient != null) {
            this.clearCache(notificationRecipient);
        }
        return notificationRecipient;
    }

    public NotificationRecipient updateImpl(NotificationRecipient notificationRecipient) {
        boolean isNew = notificationRecipient.isNew();
        if (!(notificationRecipient instanceof NotificationRecipientModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(notificationRecipient.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)notificationRecipient);
                throw new IllegalArgumentException("Implement ModelWrapper in notificationRecipient proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom NotificationRecipient implementation " + notificationRecipient.getClass());
        }
        NotificationRecipientModelImpl notificationRecipientModelImpl = (NotificationRecipientModelImpl)notificationRecipient;
        if (Validator.isNull((String)notificationRecipient.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            notificationRecipient.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && notificationRecipient.getCreateDate() == null) {
            if (serviceContext == null) {
                notificationRecipient.setCreateDate(date);
            } else {
                notificationRecipient.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!notificationRecipientModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                notificationRecipient.setModifiedDate(date);
            } else {
                notificationRecipient.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)notificationRecipient);
            } else {
                notificationRecipient = (NotificationRecipient)session.merge((Object)notificationRecipient);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(NotificationRecipientImpl.class, (BaseModel)notificationRecipientModelImpl, false, true);
        this.cacheUniqueFindersCache(notificationRecipientModelImpl);
        if (isNew) {
            notificationRecipient.setNew(false);
        }
        notificationRecipient.resetOriginalValues();
        return notificationRecipient;
    }

    public NotificationRecipient findByPrimaryKey(Serializable primaryKey) throws NoSuchNotificationRecipientException {
        NotificationRecipient notificationRecipient = (NotificationRecipient)this.fetchByPrimaryKey(primaryKey);
        if (notificationRecipient == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchNotificationRecipientException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return notificationRecipient;
    }

    public NotificationRecipient findByPrimaryKey(long notificationRecipientId) throws NoSuchNotificationRecipientException {
        return this.findByPrimaryKey(Long.valueOf(notificationRecipientId));
    }

    public NotificationRecipient fetchByPrimaryKey(long notificationRecipientId) {
        return (NotificationRecipient)this.fetchByPrimaryKey(Long.valueOf(notificationRecipientId));
    }

    public List<NotificationRecipient> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<NotificationRecipient> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<NotificationRecipient> findAll(int start, int end, OrderByComparator<NotificationRecipient> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<NotificationRecipient> findAll(int start, int end, OrderByComparator<NotificationRecipient> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_NOTIFICATIONRECIPIENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_NOTIFICATIONRECIPIENT;
                sql = sql.concat(" ORDER BY notificationRecipient.notificationRecipientId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (NotificationRecipient notificationRecipient : this.findAll()) {
            this.remove((BaseModel)notificationRecipient);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_NOTIFICATIONRECIPIENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "notificationRecipientId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_NOTIFICATIONRECIPIENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return NotificationRecipientModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathFetchByClassPK = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByClassPK", new String[]{Long.class.getName()}, new String[]{"classPK"}, true);
        this._finderPathCountByClassPK = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByClassPK", new String[]{Long.class.getName()}, new String[]{"classPK"}, false);
        NotificationRecipientUtil.setPersistence((NotificationRecipientPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        NotificationRecipientUtil.setPersistence(null);
        this.entityCache.removeCache(NotificationRecipientImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.notification.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.notification.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.notification.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

