/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationQueueEntryStatusException;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.service.NotificationQueueEntryAttachmentLocalService;
import com.liferay.notification.service.NotificationRecipientLocalService;
import com.liferay.notification.service.NotificationRecipientSettingLocalService;
import com.liferay.notification.service.NotificationTemplateAttachmentLocalService;
import com.liferay.notification.service.base.NotificationQueueEntryLocalServiceBaseImpl;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.notification.model.NotificationQueueEntry"}, service={AopService.class})
public class NotificationQueueEntryLocalServiceImpl
extends NotificationQueueEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(NotificationQueueEntryLocalServiceImpl.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private NotificationQueueEntryAttachmentLocalService _notificationQueueEntryAttachmentLocalService;
    @Reference
    private NotificationRecipientLocalService _notificationRecipientLocalService;
    @Reference
    private NotificationRecipientSettingLocalService _notificationRecipientSettingLocalService;
    @Reference
    private NotificationTemplateAttachmentLocalService _notificationTemplateAttachmentLocalService;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public NotificationQueueEntry addNotificationQueueEntry(NotificationContext notificationContext) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = notificationContext.getNotificationQueueEntry();
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationQueueEntry.getType());
        notificationType.validateNotificationQueueEntry(notificationContext);
        notificationQueueEntry.setNotificationQueueEntryId(this.counterLocalService.increment());
        notificationQueueEntry = (NotificationQueueEntry)this.notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
        this._resourceLocalService.addResources(notificationQueueEntry.getCompanyId(), 0L, notificationQueueEntry.getUserId(), NotificationQueueEntry.class.getName(), notificationQueueEntry.getNotificationQueueEntryId(), false, true, true);
        this._addNotificationQueueEntryAttachments(notificationContext, notificationQueueEntry);
        NotificationRecipient notificationRecipient = notificationContext.getNotificationRecipient();
        notificationRecipient.setNotificationRecipientId(this.counterLocalService.increment());
        notificationRecipient.setClassNameId(this._portal.getClassNameId(NotificationQueueEntry.class));
        notificationRecipient.setClassPK(notificationQueueEntry.getNotificationQueueEntryId());
        notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationContext.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setNotificationRecipientSettingId(this.counterLocalService.increment());
            notificationRecipientSetting.setNotificationRecipientId(notificationRecipient.getNotificationRecipientId());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
        }
        return notificationQueueEntry;
    }

    public void deleteNotificationQueueEntries(Date sentDate) throws PortalException {
        for (NotificationQueueEntry notificationQueueEntry : this.notificationQueueEntryPersistence.findByLtSentDate(sentDate)) {
            this.notificationQueueEntryLocalService.deleteNotificationQueueEntry(notificationQueueEntry);
        }
    }

    @Override
    public NotificationQueueEntry deleteNotificationQueueEntry(long notificationQueueEntryId) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = this.notificationQueueEntryPersistence.findByPrimaryKey(notificationQueueEntryId);
        return this.notificationQueueEntryLocalService.deleteNotificationQueueEntry(notificationQueueEntry);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public NotificationQueueEntry deleteNotificationQueueEntry(NotificationQueueEntry notificationQueueEntry) throws PortalException {
        block4: {
            notificationQueueEntry = (NotificationQueueEntry)this.notificationQueueEntryPersistence.remove((BaseModel)notificationQueueEntry);
            this._resourceLocalService.deleteResource((AuditedModel)notificationQueueEntry, 4);
            this._notificationQueueEntryAttachmentLocalService.deleteNotificationQueueEntryAttachments(notificationQueueEntry.getNotificationQueueEntryId());
            NotificationRecipient notificationRecipient = notificationQueueEntry.getNotificationRecipient();
            this._notificationRecipientLocalService.deleteNotificationRecipient(notificationRecipient);
            for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
                this._notificationRecipientSettingLocalService.deleteNotificationRecipientSetting(notificationRecipientSetting);
            }
            Repository repository = this._getRepository(notificationQueueEntry);
            if (repository != null) {
                try {
                    Folder folder = this._portletFileRepository.getPortletFolder(repository.getRepositoryId(), 0L, String.valueOf(notificationQueueEntry.getNotificationQueueEntryId()));
                    this._portletFileRepository.deletePortletFolder(folder.getFolderId());
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        return notificationQueueEntry;
    }

    public List<NotificationQueueEntry> getNotificationEntries(String type, int status) {
        return this.notificationQueueEntryPersistence.findByT_S(type, status);
    }

    public NotificationQueueEntry resendNotificationQueueEntry(long notificationQueueEntryId) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = this.getNotificationQueueEntry(notificationQueueEntryId);
        if (notificationQueueEntry.getStatus() == 1) {
            throw new NotificationQueueEntryStatusException("Notification queue entry " + notificationQueueEntry.getNotificationQueueEntryId() + " was already sent");
        }
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationQueueEntry.getType());
        notificationType.resendNotification(notificationQueueEntry);
        return this.getNotificationQueueEntry(notificationQueueEntryId);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public NotificationQueueEntry updateNotificationQueueEntry(NotificationQueueEntry notificationQueueEntry) {
        return (NotificationQueueEntry)this.notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationQueueEntry updateStatus(long notificationQueueEntryId, int status) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = this.notificationQueueEntryPersistence.findByPrimaryKey(notificationQueueEntryId);
        if (status == 1) {
            notificationQueueEntry.setSentDate(new Date());
        } else {
            notificationQueueEntry.setSentDate(null);
        }
        notificationQueueEntry.setStatus(status);
        return (NotificationQueueEntry)this.notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
    }

    private void _addNotificationQueueEntryAttachments(NotificationContext notificationContext, NotificationQueueEntry notificationQueueEntry) throws PortalException {
        Folder folder;
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        if (notificationTemplate == null) {
            return;
        }
        List notificationTemplateAttachments = this._notificationTemplateAttachmentLocalService.getNotificationTemplateAttachments(notificationTemplate.getNotificationTemplateId());
        if (ListUtil.isEmpty((List)notificationTemplateAttachments)) {
            return;
        }
        Repository repository = this._getRepository(notificationQueueEntry);
        if (repository == null) {
            return;
        }
        this._resourceLocalService.addResources(repository.getCompanyId(), repository.getGroupId(), repository.getUserId(), DLFolder.class.getName(), repository.getDlFolderId(), false, true, true);
        try {
            folder = this._portletFileRepository.addPortletFolder(this._userLocalService.getGuestUserId(notificationQueueEntry.getCompanyId()), repository.getRepositoryId(), 0L, String.valueOf(notificationQueueEntry.getNotificationQueueEntryId()), new ServiceContext());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return;
        }
        for (NotificationTemplateAttachment notificationTemplateAttachment : notificationTemplateAttachments) {
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(notificationTemplateAttachment.getObjectFieldId());
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(MapUtil.getLong((Map)notificationContext.getTermValues(), (String)objectField.getName()));
            if (dlFileEntry == null) continue;
            FileEntry fileEntry = this._portletFileRepository.addPortletFileEntry(null, repository.getGroupId(), this._userLocalService.getGuestUserId(notificationQueueEntry.getCompanyId()), NotificationTemplate.class.getName(), 0L, "com_liferay_notification_web_internal_portlet_NotificationTemplatesPortlet", folder.getFolderId(), dlFileEntry.getContentStream(), this._portletFileRepository.getUniqueFileName(repository.getGroupId(), folder.getFolderId(), dlFileEntry.getFileName()), dlFileEntry.getMimeType(), false);
            this._notificationQueueEntryAttachmentLocalService.addNotificationQueueEntryAttachment(notificationQueueEntry.getCompanyId(), fileEntry.getFileEntryId(), notificationQueueEntry.getNotificationQueueEntryId());
        }
    }

    private Repository _getRepository(NotificationQueueEntry notificationQueueEntry) {
        try {
            Group group = this._groupLocalService.getCompanyGroup(notificationQueueEntry.getCompanyId());
            return this._portletFileRepository.addPortletRepository(group.getGroupId(), "com_liferay_notification_web_internal_portlet_NotificationTemplatesPortlet", new ServiceContext());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }
}

