/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.BaseUsersProvider;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.LinkedHashSet;
import java.util.List;

public class RoleUsersProvider
extends BaseUsersProvider
implements UsersProvider {
    private final RoleLocalService _roleLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;

    public RoleUsersProvider(PermissionCheckerFactory permissionCheckerFactory, RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        super(permissionCheckerFactory);
        this._roleLocalService = roleLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String getRecipientType() {
        return "role";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext) throws PortalException {
        LinkedHashSet<Long> userIds = new LinkedHashSet<Long>();
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            Role role = this._roleLocalService.getRole(notificationRecipientSetting.getCompanyId(), notificationRecipientSetting.getValue());
            if (role.getType() == 3 || role.getType() == 2) {
                userIds.addAll(ListUtil.toList((List)this._userGroupRoleLocalService.getUserGroupRolesByGroup(notificationContext.getGroupId()), UserGroupRoleModel::getUserId));
                continue;
            }
            for (long userId2 : this._userLocalService.getRoleUserIds(role.getRoleId(), 1L)) {
                userIds.add(userId2);
            }
        }
        return TransformUtil.unsafeTransform(userIds, userId -> {
            User user = this._userLocalService.getUser(userId.longValue());
            if (!this.hasViewPermission(notificationContext.getClassName(), notificationContext.getClassPK(), user)) {
                return null;
            }
            return user;
        });
    }
}

