/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.BaseUsersProvider;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"recipient.type=user"}, service={UsersProvider.class})
public class DefaultUsersProvider
extends BaseUsersProvider
implements UsersProvider {
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public String getRecipientType() {
        return "user";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        return TransformUtil.unsafeTransform((Collection)notificationRecipient.getNotificationRecipientSettings(), notificationRecipientSetting -> {
            User user = this._userLocalService.getUserByScreenName(notificationRecipientSetting.getCompanyId(), notificationRecipientSetting.getValue());
            if (!this.hasViewPermission(notificationContext.getClassName(), notificationContext.getClassPK(), user)) {
                return null;
            }
            return user;
        });
    }
}

